package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QuickConnectId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateQuickConnectConfigRequest(
    instanceId: InstanceId,
    quickConnectId: QuickConnectId,
    quickConnectConfig: zio.aws.connect.model.QuickConnectConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest = {
    import UpdateQuickConnectConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .quickConnectId(QuickConnectId.unwrap(quickConnectId): java.lang.String)
      .quickConnectConfig(quickConnectConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateQuickConnectConfigRequest.ReadOnly =
    zio.aws.connect.model.UpdateQuickConnectConfigRequest.wrap(buildAwsValue())
}
object UpdateQuickConnectConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQuickConnectConfigRequest =
      zio.aws.connect.model.UpdateQuickConnectConfigRequest(
        instanceId,
        quickConnectId,
        quickConnectConfig.asEditable
      )
    def instanceId: InstanceId
    def quickConnectId: QuickConnectId
    def quickConnectConfig: zio.aws.connect.model.QuickConnectConfig.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQuickConnectId: ZIO[Any, Nothing, QuickConnectId] =
      ZIO.succeed(quickConnectId)
    def getQuickConnectConfig
        : ZIO[Any, Nothing, zio.aws.connect.model.QuickConnectConfig.ReadOnly] =
      ZIO.succeed(quickConnectConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest
  ) extends zio.aws.connect.model.UpdateQuickConnectConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val quickConnectId: QuickConnectId =
      zio.aws.connect.model.primitives.QuickConnectId(impl.quickConnectId())
    override val quickConnectConfig
        : zio.aws.connect.model.QuickConnectConfig.ReadOnly =
      zio.aws.connect.model.QuickConnectConfig.wrap(impl.quickConnectConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest
  ): zio.aws.connect.model.UpdateQuickConnectConfigRequest.ReadOnly =
    new Wrapper(impl)
}
