package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  InstanceId,
  SecurityProfileId,
  SecurityProfilePermission,
  SecurityProfileDescription
}
import scala.jdk.CollectionConverters._
final case class UpdateSecurityProfileRequest(
    description: Option[SecurityProfileDescription] = None,
    permissions: Option[Iterable[SecurityProfilePermission]] = None,
    securityProfileId: SecurityProfileId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest = {
    import UpdateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .securityProfileId(
        SecurityProfileId.unwrap(securityProfileId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.UpdateSecurityProfileRequest.wrap(buildAwsValue())
}
object UpdateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateSecurityProfileRequest =
      zio.aws.connect.model.UpdateSecurityProfileRequest(
        description.map(value => value),
        permissions.map(value => value),
        securityProfileId,
        instanceId
      )
    def description: Option[SecurityProfileDescription]
    def permissions: Option[List[SecurityProfilePermission]]
    def securityProfileId: SecurityProfileId
    def instanceId: InstanceId
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getSecurityProfileId: ZIO[Any, Nothing, SecurityProfileId] =
      ZIO.succeed(securityProfileId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ) extends zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly {
    override val description: Option[SecurityProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.SecurityProfileDescription(value)
      )
    override val permissions: Option[List[SecurityProfilePermission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.SecurityProfilePermission(item)
        }.toList
      )
    override val securityProfileId: SecurityProfileId =
      zio.aws.connect.model.primitives
        .SecurityProfileId(impl.securityProfileId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest
  ): zio.aws.connect.model.UpdateSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
