package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class UpdateUserHierarchyStructureRequest(
    hierarchyStructure: zio.aws.connect.model.HierarchyStructureUpdate,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest = {
    import UpdateUserHierarchyStructureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest
      .builder()
      .hierarchyStructure(hierarchyStructure.buildAwsValue())
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateUserHierarchyStructureRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserHierarchyStructureRequest
      .wrap(buildAwsValue())
}
object UpdateUserHierarchyStructureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserHierarchyStructureRequest =
      zio.aws.connect.model.UpdateUserHierarchyStructureRequest(
        hierarchyStructure.asEditable,
        instanceId
      )
    def hierarchyStructure
        : zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly
    def instanceId: InstanceId
    def getHierarchyStructure: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly
    ] = ZIO.succeed(hierarchyStructure)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest
  ) extends zio.aws.connect.model.UpdateUserHierarchyStructureRequest.ReadOnly {
    override val hierarchyStructure
        : zio.aws.connect.model.HierarchyStructureUpdate.ReadOnly =
      zio.aws.connect.model.HierarchyStructureUpdate
        .wrap(impl.hierarchyStructure())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest
  ): zio.aws.connect.model.UpdateUserHierarchyStructureRequest.ReadOnly =
    new Wrapper(impl)
}
