package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ReferenceValue, ReferenceKey}
import scala.jdk.CollectionConverters._
final case class UrlReference(
    name: Option[ReferenceKey] = None,
    value: Option[ReferenceValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UrlReference = {
    import UrlReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UrlReference
      .builder()
      .optionallyWith(
        name.map(value => ReferenceKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ReferenceValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UrlReference.ReadOnly =
    zio.aws.connect.model.UrlReference.wrap(buildAwsValue())
}
object UrlReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UrlReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UrlReference = zio.aws.connect.model
      .UrlReference(name.map(value => value), value.map(value => value))
    def name: Option[ReferenceKey]
    def value: Option[ReferenceValue]
    def getName: ZIO[Any, AwsError, ReferenceKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ReferenceValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UrlReference
  ) extends zio.aws.connect.model.UrlReference.ReadOnly {
    override val name: Option[ReferenceKey] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.ReferenceKey(value))
    override val value: Option[ReferenceValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.connect.model.primitives.ReferenceValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UrlReference
  ): zio.aws.connect.model.UrlReference.ReadOnly = new Wrapper(impl)
}
