package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{Email, AgentLastName, AgentFirstName}
import scala.jdk.CollectionConverters._
final case class UserIdentityInfo(
    firstName: Option[AgentFirstName] = None,
    lastName: Option[AgentLastName] = None,
    email: Option[Email] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserIdentityInfo = {
    import UserIdentityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserIdentityInfo
      .builder()
      .optionallyWith(
        firstName.map(value => AgentFirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => AgentLastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserIdentityInfo.ReadOnly =
    zio.aws.connect.model.UserIdentityInfo.wrap(buildAwsValue())
}
object UserIdentityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserIdentityInfo =
      zio.aws.connect.model.UserIdentityInfo(
        firstName.map(value => value),
        lastName.map(value => value),
        email.map(value => value)
      )
    def firstName: Option[AgentFirstName]
    def lastName: Option[AgentLastName]
    def email: Option[Email]
    def getFirstName: ZIO[Any, AwsError, AgentFirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, AgentLastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ) extends zio.aws.connect.model.UserIdentityInfo.ReadOnly {
    override val firstName: Option[AgentFirstName] = scala
      .Option(impl.firstName())
      .map(value => zio.aws.connect.model.primitives.AgentFirstName(value))
    override val lastName: Option[AgentLastName] = scala
      .Option(impl.lastName())
      .map(value => zio.aws.connect.model.primitives.AgentLastName(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.connect.model.primitives.Email(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfo
  ): zio.aws.connect.model.UserIdentityInfo.ReadOnly = new Wrapper(impl)
}
