package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  PhoneNumber,
  AfterContactWorkTimeLimit,
  AutoAccept
}
import scala.jdk.CollectionConverters._
final case class UserPhoneConfig(
    phoneType: zio.aws.connect.model.PhoneType,
    autoAccept: Option[AutoAccept] = None,
    afterContactWorkTimeLimit: Option[AfterContactWorkTimeLimit] = None,
    deskPhoneNumber: Option[PhoneNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserPhoneConfig = {
    import UserPhoneConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserPhoneConfig
      .builder()
      .phoneType(phoneType.unwrap)
      .optionallyWith(
        autoAccept.map(value => AutoAccept.unwrap(value): java.lang.Boolean)
      )(_.autoAccept)
      .optionallyWith(
        afterContactWorkTimeLimit.map(value =>
          AfterContactWorkTimeLimit.unwrap(value): Integer
        )
      )(_.afterContactWorkTimeLimit)
      .optionallyWith(
        deskPhoneNumber.map(value =>
          PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.deskPhoneNumber)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserPhoneConfig.ReadOnly =
    zio.aws.connect.model.UserPhoneConfig.wrap(buildAwsValue())
}
object UserPhoneConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserPhoneConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserPhoneConfig =
      zio.aws.connect.model.UserPhoneConfig(
        phoneType,
        autoAccept.map(value => value),
        afterContactWorkTimeLimit.map(value => value),
        deskPhoneNumber.map(value => value)
      )
    def phoneType: zio.aws.connect.model.PhoneType
    def autoAccept: Option[AutoAccept]
    def afterContactWorkTimeLimit: Option[AfterContactWorkTimeLimit]
    def deskPhoneNumber: Option[PhoneNumber]
    def getPhoneType: ZIO[Any, Nothing, zio.aws.connect.model.PhoneType] =
      ZIO.succeed(phoneType)
    def getAutoAccept: ZIO[Any, AwsError, AutoAccept] =
      AwsError.unwrapOptionField("autoAccept", autoAccept)
    def getAfterContactWorkTimeLimit
        : ZIO[Any, AwsError, AfterContactWorkTimeLimit] = AwsError
      .unwrapOptionField("afterContactWorkTimeLimit", afterContactWorkTimeLimit)
    def getDeskPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("deskPhoneNumber", deskPhoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserPhoneConfig
  ) extends zio.aws.connect.model.UserPhoneConfig.ReadOnly {
    override val phoneType: zio.aws.connect.model.PhoneType =
      zio.aws.connect.model.PhoneType.wrap(impl.phoneType())
    override val autoAccept: Option[AutoAccept] = scala
      .Option(impl.autoAccept())
      .map(value => zio.aws.connect.model.primitives.AutoAccept(value))
    override val afterContactWorkTimeLimit: Option[AfterContactWorkTimeLimit] =
      scala
        .Option(impl.afterContactWorkTimeLimit())
        .map(value =>
          zio.aws.connect.model.primitives.AfterContactWorkTimeLimit(value)
        )
    override val deskPhoneNumber: Option[PhoneNumber] = scala
      .Option(impl.deskPhoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserPhoneConfig
  ): zio.aws.connect.model.UserPhoneConfig.ReadOnly = new Wrapper(impl)
}
