package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{AgentUsername, ARN, UserId}
import scala.jdk.CollectionConverters._
final case class UserSummary(
    id: Option[UserId] = None,
    arn: Option[ARN] = None,
    username: Option[AgentUsername] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserSummary = {
    import UserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserSummary
      .builder()
      .optionallyWith(id.map(value => UserId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        username.map(value => AgentUsername.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserSummary.ReadOnly =
    zio.aws.connect.model.UserSummary.wrap(buildAwsValue())
}
object UserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserSummary =
      zio.aws.connect.model.UserSummary(
        id.map(value => value),
        arn.map(value => value),
        username.map(value => value)
      )
    def id: Option[UserId]
    def arn: Option[ARN]
    def username: Option[AgentUsername]
    def getId: ZIO[Any, AwsError, UserId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getUsername: ZIO[Any, AwsError, AgentUsername] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserSummary
  ) extends zio.aws.connect.model.UserSummary.ReadOnly {
    override val id: Option[UserId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.UserId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val username: Option[AgentUsername] = scala
      .Option(impl.username())
      .map(value => zio.aws.connect.model.primitives.AgentUsername(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserSummary
  ): zio.aws.connect.model.UserSummary.ReadOnly = new Wrapper(impl)
}
