package zio.aws.connect
import zio.aws.connect.model.ListSecurityProfilesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.connect.model.primitives.{
  Origin,
  SecurityProfilePermission,
  FunctionArn
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.connect.model.{
  GetCurrentUserDataRequest,
  UpdateContactFlowContentRequest,
  DeleteUserRequest,
  GetTaskTemplateRequest,
  ListLexBotsRequest,
  ListTaskTemplatesRequest,
  StartOutboundVoiceContactRequest,
  UpdateTrafficDistributionRequest,
  ListSecurityProfilePermissionsRequest,
  UpdateQueueMaxContactsRequest,
  CreateQuickConnectRequest,
  DescribeUserRequest,
  DisassociateRoutingProfileQueuesRequest,
  AssociateRoutingProfileQueuesRequest,
  UpdateUserSecurityProfilesRequest,
  DeleteContactFlowRequest,
  ListQueuesRequest,
  UpdateTaskTemplateRequest,
  DescribeVocabularyRequest,
  CreateRoutingProfileRequest,
  DeleteQuickConnectRequest,
  ListDefaultVocabulariesRequest,
  UpdateUserRoutingProfileRequest,
  DescribeQuickConnectRequest,
  AssociateInstanceStorageConfigRequest,
  SearchAvailablePhoneNumbersRequest,
  CreateInstanceRequest,
  UpdateQueueNameRequest,
  ReleasePhoneNumberRequest,
  CreateContactFlowRequest,
  CreateVocabularyRequest,
  DeleteTaskTemplateRequest,
  UpdateContactFlowMetadataRequest,
  DeleteUseCaseRequest,
  CreateTrafficDistributionGroupRequest,
  DescribeInstanceAttributeRequest,
  ListUsersRequest,
  ListUseCasesRequest,
  AssociateSecurityKeyRequest,
  PutUserStatusRequest,
  UpdateContactFlowNameRequest,
  DescribeUserHierarchyStructureRequest,
  CreateAgentStatusRequest,
  UpdateHoursOfOperationRequest,
  UpdateAgentStatusRequest,
  DisassociateInstanceStorageConfigRequest,
  AssociateLexBotRequest,
  CreateContactFlowModuleRequest,
  ListQuickConnectsRequest,
  DisassociateQueueQuickConnectsRequest,
  UpdateUserHierarchyStructureRequest,
  CreateTaskTemplateRequest,
  AssociateQueueQuickConnectsRequest,
  GetCurrentMetricDataRequest,
  CreateQueueRequest,
  ListInstancesRequest,
  UpdateUserPhoneConfigRequest,
  DisassociatePhoneNumberContactFlowRequest,
  DescribeInstanceRequest,
  UpdatePhoneNumberRequest,
  DeleteUserHierarchyGroupRequest,
  ListTagsForResourceRequest,
  GetTrafficDistributionRequest,
  DisassociateBotRequest,
  ListBotsRequest,
  GetFederationTokenRequest,
  UpdateQuickConnectNameRequest,
  UpdateRoutingProfileQueuesRequest,
  DescribeRoutingProfileRequest,
  DescribeInstanceStorageConfigRequest,
  ListInstanceAttributesRequest,
  CreateHoursOfOperationRequest,
  ListRoutingProfileQueuesRequest,
  DeleteIntegrationAssociationRequest,
  StartChatContactRequest,
  ResumeContactRecordingRequest,
  ListPromptsRequest,
  UpdateInstanceStorageConfigRequest,
  DisassociateLambdaFunctionRequest,
  SearchUsersRequest,
  ListSecurityKeysRequest,
  TransferContactRequest,
  DeleteContactFlowModuleRequest,
  AssociateApprovedOriginRequest,
  CreateUserRequest,
  ListIntegrationAssociationsRequest,
  ListAgentStatusesRequest,
  SearchRoutingProfilesRequest,
  ListPhoneNumbersRequest,
  AssociateBotRequest,
  UpdateQueueStatusRequest,
  UpdateContactFlowModuleMetadataRequest,
  DisassociateSecurityKeyRequest,
  UpdateContactScheduleRequest,
  DescribeSecurityProfileRequest,
  DescribeContactRequest,
  DescribePhoneNumberRequest,
  DescribeHoursOfOperationRequest,
  ClaimPhoneNumberRequest,
  ListRoutingProfilesRequest,
  UpdateRoutingProfileConcurrencyRequest,
  ListApprovedOriginsRequest,
  CreateIntegrationAssociationRequest,
  UpdateRoutingProfileNameRequest,
  StopContactRecordingRequest,
  UpdateContactFlowModuleContentRequest,
  ListContactFlowsRequest,
  UpdateSecurityProfileRequest,
  CreateUseCaseRequest,
  AssociatePhoneNumberContactFlowRequest,
  UntagResourceRequest,
  StartTaskContactRequest,
  UpdateQueueHoursOfOperationRequest,
  ReplicateInstanceRequest,
  DeleteInstanceRequest,
  DeleteTrafficDistributionGroupRequest,
  UpdateUserHierarchyGroupNameRequest,
  DisassociateLexBotRequest,
  CreateUserHierarchyGroupRequest,
  UpdateUserIdentityInfoRequest,
  SearchSecurityProfilesRequest,
  GetMetricDataRequest,
  SearchQueuesRequest,
  StopContactRequest,
  UpdateContactAttributesRequest,
  DeleteVocabularyRequest,
  StartContactStreamingRequest,
  ListLambdaFunctionsRequest,
  ListUserHierarchyGroupsRequest,
  StartContactRecordingRequest,
  AssociateDefaultVocabularyRequest,
  SuspendContactRecordingRequest,
  ListQueueQuickConnectsRequest,
  DeleteHoursOfOperationRequest,
  AssociateLambdaFunctionRequest,
  SearchVocabulariesRequest,
  DescribeContactFlowRequest,
  ListSecurityProfilesRequest,
  ListContactFlowModulesRequest,
  CreateSecurityProfileRequest,
  UpdateInstanceAttributeRequest,
  StopContactStreamingRequest,
  DisassociateApprovedOriginRequest,
  UpdateQueueOutboundCallerConfigRequest,
  DescribeUserHierarchyGroupRequest,
  UpdateRoutingProfileDefaultOutboundQueueRequest,
  DescribeAgentStatusRequest,
  ListTrafficDistributionGroupsRequest,
  ListContactReferencesRequest,
  UpdateQuickConnectConfigRequest,
  UpdateContactRequest,
  UpdateUserHierarchyRequest,
  DescribeQueueRequest,
  ListPhoneNumbersV2Request,
  DeleteSecurityProfileRequest,
  TagResourceRequest,
  DescribeTrafficDistributionGroupRequest,
  DescribeContactFlowModuleRequest,
  ListHoursOfOperationsRequest,
  GetContactAttributesRequest,
  ListInstanceStorageConfigsRequest
}
import software.amazon.awssdk.services.connect.{
  ConnectAsyncClientBuilder,
  ConnectAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.connect.model.{
  CreateQueueResponse,
  SecurityKey,
  UpdateQueueStatusResponse,
  StopContactRecordingResponse,
  CreateUserHierarchyGroupResponse,
  UpdateQueueMaxContactsResponse,
  UpdateUserPhoneConfigResponse,
  DescribeRoutingProfileResponse,
  ReferenceSummary,
  ListContactReferencesResponse,
  ResumeContactRecordingResponse,
  SecurityProfileSearchSummary,
  CreateTrafficDistributionGroupResponse,
  InstanceSummary,
  DisassociateInstanceStorageConfigResponse,
  CreateRoutingProfileResponse,
  DeleteTaskTemplateResponse,
  ListApprovedOriginsResponse,
  DeleteVocabularyResponse,
  SearchRoutingProfilesResponse,
  DeleteQuickConnectResponse,
  ListInstancesResponse,
  QuickConnectSummary,
  DeleteContactFlowResponse,
  UserSummary,
  UpdateContactFlowMetadataResponse,
  GetContactAttributesResponse,
  CreateVocabularyResponse,
  ListContactFlowModulesResponse,
  AssociateRoutingProfileQueuesResponse,
  Attribute,
  ListInstanceStorageConfigsResponse,
  ListSecurityProfilesResponse,
  SearchAvailablePhoneNumbersResponse,
  UpdateRoutingProfileConcurrencyResponse,
  UpdateContactFlowModuleContentResponse,
  ListIntegrationAssociationsResponse,
  StartContactStreamingResponse,
  ListQuickConnectsResponse,
  DisassociateBotResponse,
  DisassociateApprovedOriginResponse,
  DisassociateLexBotResponse,
  ListInstanceAttributesResponse,
  DeleteUseCaseResponse,
  UpdateRoutingProfileQueuesResponse,
  UpdateQueueHoursOfOperationResponse,
  DescribeUserHierarchyStructureResponse,
  ListHoursOfOperationsResponse,
  LexBot,
  UpdateSecurityProfileResponse,
  ListRoutingProfilesResponse,
  InstanceStorageConfig,
  ListTaskTemplatesResponse,
  ListUsersResponse,
  DescribeSecurityProfileResponse,
  DeleteIntegrationAssociationResponse,
  ListSecurityKeysResponse,
  ListTrafficDistributionGroupsResponse,
  CreateUseCaseResponse,
  DescribeUserResponse,
  UpdateUserHierarchyStructureResponse,
  AssociateInstanceStorageConfigResponse,
  UpdateUserSecurityProfilesResponse,
  GetCurrentUserDataResponse,
  UpdateInstanceAttributeResponse,
  GetMetricDataResponse,
  AgentStatusSummary,
  DescribeInstanceAttributeResponse,
  ListAgentStatusesResponse,
  UpdateTrafficDistributionResponse,
  Queue,
  DeleteUserHierarchyGroupResponse,
  ListDefaultVocabulariesResponse,
  CreateHoursOfOperationResponse,
  DescribeAgentStatusResponse,
  DescribeTrafficDistributionGroupResponse,
  DescribePhoneNumberResponse,
  UpdateContactResponse,
  GetCurrentMetricDataResponse,
  DeleteHoursOfOperationResponse,
  UpdateQuickConnectNameResponse,
  DescribeInstanceResponse,
  StartTaskContactResponse,
  UpdateQueueNameResponse,
  ContactFlowSummary,
  CreateIntegrationAssociationResponse,
  DescribeInstanceStorageConfigResponse,
  RoutingProfileSummary,
  DisassociateSecurityKeyResponse,
  LexBotConfig,
  DefaultVocabulary,
  PromptSummary,
  ReplicateInstanceResponse,
  ListPromptsResponse,
  DescribeContactFlowResponse,
  DeleteInstanceResponse,
  DescribeContactResponse,
  QueueSummary,
  PhoneNumberSummary,
  IntegrationAssociationSummary,
  ListPhoneNumbersV2Response,
  SecurityProfileSummary,
  SearchUsersResponse,
  AssociateQueueQuickConnectsResponse,
  AssociateApprovedOriginResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateInstanceResponse,
  DescribeHoursOfOperationResponse,
  StopContactStreamingResponse,
  AssociateDefaultVocabularyResponse,
  SearchQueuesResponse,
  AssociateBotResponse,
  AssociateLambdaFunctionResponse,
  ListUserHierarchyGroupsResponse,
  UpdateUserIdentityInfoResponse,
  UpdateContactAttributesResponse,
  UpdateRoutingProfileDefaultOutboundQueueResponse,
  ListQueuesResponse,
  TaskTemplateMetadata,
  UpdateContactScheduleResponse,
  UpdateRoutingProfileNameResponse,
  PutUserStatusResponse,
  CreateUserResponse,
  DescribeContactFlowModuleResponse,
  CreateContactFlowResponse,
  DisassociateLambdaFunctionResponse,
  CreateQuickConnectResponse,
  ListPhoneNumbersSummary,
  DescribeQueueResponse,
  UpdateUserHierarchyGroupNameResponse,
  ListRoutingProfileQueuesResponse,
  TrafficDistributionGroupSummary,
  UpdateUserHierarchyResponse,
  UpdateInstanceStorageConfigResponse,
  DescribeQuickConnectResponse,
  CreateAgentStatusResponse,
  RoutingProfile,
  UpdateAgentStatusResponse,
  SearchSecurityProfilesResponse,
  ListBotsResponse,
  UseCase,
  DeleteTrafficDistributionGroupResponse,
  DisassociatePhoneNumberContactFlowResponse,
  ListQueueQuickConnectsResponse,
  UpdateUserRoutingProfileResponse,
  DeleteSecurityProfileResponse,
  StopContactResponse,
  UpdateQuickConnectConfigResponse,
  UserData,
  UpdatePhoneNumberResponse,
  UpdateQueueOutboundCallerConfigResponse,
  DeleteUserResponse,
  VocabularySummary,
  DeleteContactFlowModuleResponse,
  RoutingProfileQueueConfigSummary,
  GetTrafficDistributionResponse,
  DisassociateQueueQuickConnectsResponse,
  UserSearchSummary,
  ListPhoneNumbersResponse,
  UpdateHoursOfOperationResponse,
  CurrentMetricResult,
  StartOutboundVoiceContactResponse,
  CreateTaskTemplateResponse,
  DescribeVocabularyResponse,
  AssociatePhoneNumberContactFlowResponse,
  GetTaskTemplateResponse,
  AssociateSecurityKeyResponse,
  ListUseCasesResponse,
  UpdateContactFlowModuleMetadataResponse,
  ListLambdaFunctionsResponse,
  HierarchyGroupSummary,
  CreateContactFlowModuleResponse,
  GetFederationTokenResponse,
  ListLexBotsResponse,
  HoursOfOperationSummary,
  TransferContactResponse,
  StartChatContactResponse,
  TagResourceResponse,
  StartContactRecordingResponse,
  AssociateLexBotResponse,
  DescribeUserHierarchyGroupResponse,
  AvailableNumberSummary,
  ListContactFlowsResponse,
  DisassociateRoutingProfileQueuesResponse,
  SearchVocabulariesResponse,
  ClaimPhoneNumberResponse,
  UpdateContactFlowNameResponse,
  HistoricalMetricResult,
  ContactFlowModuleSummary,
  UpdateTaskTemplateResponse,
  ReleasePhoneNumberResponse,
  SuspendContactRecordingResponse,
  ListSecurityProfilePermissionsResponse,
  UpdateContactFlowContentResponse,
  CreateSecurityProfileResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Connect extends AspectSupport[Connect] {
  val api: ConnectAsyncClient
  def updateContact(
      request: UpdateContactRequest
  ): IO[AwsError, zio.aws.connect.model.UpdateContactResponse.ReadOnly]
  def listContactFlowModules(request: ListContactFlowModulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
  ]
  def listContactFlowModulesPaginated(
      request: ListContactFlowModulesRequest
  ): IO[AwsError, zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly]
  def deleteTaskTemplate(
      request: DeleteTaskTemplateRequest
  ): IO[AwsError, zio.aws.connect.model.DeleteTaskTemplateResponse.ReadOnly]
  def listAgentStatuses(
      request: ListAgentStatusesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.AgentStatusSummary.ReadOnly]
  def listAgentStatusesPaginated(
      request: ListAgentStatusesRequest
  ): IO[AwsError, zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly]
  def createUseCase(
      request: CreateUseCaseRequest
  ): IO[AwsError, zio.aws.connect.model.CreateUseCaseResponse.ReadOnly]
  def updateRoutingProfileDefaultOutboundQueue(
      request: UpdateRoutingProfileDefaultOutboundQueueRequest
  ): IO[AwsError, Unit]
  def listUsers(
      request: ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.UserSummary.ReadOnly]
  def listUsersPaginated(
      request: ListUsersRequest
  ): IO[AwsError, zio.aws.connect.model.ListUsersResponse.ReadOnly]
  def createRoutingProfile(
      request: CreateRoutingProfileRequest
  ): IO[AwsError, zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly]
  def listRoutingProfiles(request: ListRoutingProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.RoutingProfileSummary.ReadOnly
  ]
  def listRoutingProfilesPaginated(
      request: ListRoutingProfilesRequest
  ): IO[AwsError, zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly]
  def updateTaskTemplate(
      request: UpdateTaskTemplateRequest
  ): IO[AwsError, zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly]
  def deleteContactFlow(request: DeleteContactFlowRequest): IO[AwsError, Unit]
  def getTrafficDistribution(
      request: GetTrafficDistributionRequest
  ): IO[AwsError, zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly]
  def disassociateRoutingProfileQueues(
      request: DisassociateRoutingProfileQueuesRequest
  ): IO[AwsError, Unit]
  def disassociateLambdaFunction(
      request: DisassociateLambdaFunctionRequest
  ): IO[AwsError, Unit]
  def describePhoneNumber(
      request: DescribePhoneNumberRequest
  ): IO[AwsError, zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly]
  def describeVocabulary(
      request: DescribeVocabularyRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly]
  def searchUsers(
      request: SearchUsersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchUsersResponse.ReadOnly,
    zio.aws.connect.model.UserSearchSummary.ReadOnly
  ]]
  def searchUsersPaginated(
      request: SearchUsersRequest
  ): IO[AwsError, zio.aws.connect.model.SearchUsersResponse.ReadOnly]
  def createAgentStatus(
      request: CreateAgentStatusRequest
  ): IO[AwsError, zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly]
  def deleteVocabulary(
      request: DeleteVocabularyRequest
  ): IO[AwsError, zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly]
  def listInstanceStorageConfigs(
      request: ListInstanceStorageConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.InstanceStorageConfig.ReadOnly
  ]
  def listInstanceStorageConfigsPaginated(
      request: ListInstanceStorageConfigsRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly
  ]
  def updateHoursOfOperation(
      request: UpdateHoursOfOperationRequest
  ): IO[AwsError, Unit]
  def startChatContact(
      request: StartChatContactRequest
  ): IO[AwsError, zio.aws.connect.model.StartChatContactResponse.ReadOnly]
  def updateRoutingProfileQueues(
      request: UpdateRoutingProfileQueuesRequest
  ): IO[AwsError, Unit]
  def describeInstance(
      request: DescribeInstanceRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeInstanceResponse.ReadOnly]
  def getContactAttributes(
      request: GetContactAttributesRequest
  ): IO[AwsError, zio.aws.connect.model.GetContactAttributesResponse.ReadOnly]
  def createSecurityProfile(
      request: CreateSecurityProfileRequest
  ): IO[AwsError, zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly]
  def disassociatePhoneNumberContactFlow(
      request: DisassociatePhoneNumberContactFlowRequest
  ): IO[AwsError, Unit]
  def updateQueueOutboundCallerConfig(
      request: UpdateQueueOutboundCallerConfigRequest
  ): IO[AwsError, Unit]
  def listPhoneNumbersV2(request: ListPhoneNumbersV2Request): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
  ]
  def listPhoneNumbersV2Paginated(
      request: ListPhoneNumbersV2Request
  ): IO[AwsError, zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly]
  def createTrafficDistributionGroup(
      request: CreateTrafficDistributionGroupRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly
  ]
  def deleteContactFlowModule(request: DeleteContactFlowModuleRequest): IO[
    AwsError,
    zio.aws.connect.model.DeleteContactFlowModuleResponse.ReadOnly
  ]
  def getTaskTemplate(
      request: GetTaskTemplateRequest
  ): IO[AwsError, zio.aws.connect.model.GetTaskTemplateResponse.ReadOnly]
  def createContactFlow(
      request: CreateContactFlowRequest
  ): IO[AwsError, zio.aws.connect.model.CreateContactFlowResponse.ReadOnly]
  def listInstances(
      request: ListInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.InstanceSummary.ReadOnly]
  def listInstancesPaginated(
      request: ListInstancesRequest
  ): IO[AwsError, zio.aws.connect.model.ListInstancesResponse.ReadOnly]
  def updateContactFlowContent(
      request: UpdateContactFlowContentRequest
  ): IO[AwsError, Unit]
  def associateDefaultVocabulary(
      request: AssociateDefaultVocabularyRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.AssociateDefaultVocabularyResponse.ReadOnly
  ]
  def associateLexBot(request: AssociateLexBotRequest): IO[AwsError, Unit]
  def associatePhoneNumberContactFlow(
      request: AssociatePhoneNumberContactFlowRequest
  ): IO[AwsError, Unit]
  def describeHoursOfOperation(request: DescribeHoursOfOperationRequest): IO[
    AwsError,
    zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly
  ]
  def describeRoutingProfile(
      request: DescribeRoutingProfileRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly]
  def updateRoutingProfileName(
      request: UpdateRoutingProfileNameRequest
  ): IO[AwsError, Unit]
  def listDefaultVocabularies(
      request: ListDefaultVocabulariesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.DefaultVocabulary.ReadOnly]
  def listDefaultVocabulariesPaginated(
      request: ListDefaultVocabulariesRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly
  ]
  def updateContactFlowModuleContent(
      request: UpdateContactFlowModuleContentRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.UpdateContactFlowModuleContentResponse.ReadOnly
  ]
  def releasePhoneNumber(request: ReleasePhoneNumberRequest): IO[AwsError, Unit]
  def updateQuickConnectConfig(
      request: UpdateQuickConnectConfigRequest
  ): IO[AwsError, Unit]
  def updateUserIdentityInfo(
      request: UpdateUserIdentityInfoRequest
  ): IO[AwsError, Unit]
  def updateUserSecurityProfiles(
      request: UpdateUserSecurityProfilesRequest
  ): IO[AwsError, Unit]
  def listContactFlows(
      request: ListContactFlowsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.ContactFlowSummary.ReadOnly]
  def listContactFlowsPaginated(
      request: ListContactFlowsRequest
  ): IO[AwsError, zio.aws.connect.model.ListContactFlowsResponse.ReadOnly]
  def listQueues(
      request: ListQueuesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.QueueSummary.ReadOnly]
  def listQueuesPaginated(
      request: ListQueuesRequest
  ): IO[AwsError, zio.aws.connect.model.ListQueuesResponse.ReadOnly]
  def updateRoutingProfileConcurrency(
      request: UpdateRoutingProfileConcurrencyRequest
  ): IO[AwsError, Unit]
  def associateBot(request: AssociateBotRequest): IO[AwsError, Unit]
  def updateContactFlowModuleMetadata(
      request: UpdateContactFlowModuleMetadataRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.ReadOnly
  ]
  def describeTrafficDistributionGroup(
      request: DescribeTrafficDistributionGroupRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly
  ]
  def resumeContactRecording(
      request: ResumeContactRecordingRequest
  ): IO[AwsError, zio.aws.connect.model.ResumeContactRecordingResponse.ReadOnly]
  def getFederationToken(
      request: GetFederationTokenRequest
  ): IO[AwsError, zio.aws.connect.model.GetFederationTokenResponse.ReadOnly]
  def updateContactSchedule(
      request: UpdateContactScheduleRequest
  ): IO[AwsError, zio.aws.connect.model.UpdateContactScheduleResponse.ReadOnly]
  def deleteInstance(request: DeleteInstanceRequest): IO[AwsError, Unit]
  def searchRoutingProfiles(
      request: SearchRoutingProfilesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly,
    zio.aws.connect.model.RoutingProfile.ReadOnly
  ]]
  def searchRoutingProfilesPaginated(
      request: SearchRoutingProfilesRequest
  ): IO[AwsError, zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly]
  def updateTrafficDistribution(request: UpdateTrafficDistributionRequest): IO[
    AwsError,
    zio.aws.connect.model.UpdateTrafficDistributionResponse.ReadOnly
  ]
  def getMetricData(request: GetMetricDataRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.HistoricalMetricResult.ReadOnly
  ]
  def getMetricDataPaginated(
      request: GetMetricDataRequest
  ): IO[AwsError, zio.aws.connect.model.GetMetricDataResponse.ReadOnly]
  def listQuickConnects(
      request: ListQuickConnectsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.QuickConnectSummary.ReadOnly]
  def listQuickConnectsPaginated(
      request: ListQuickConnectsRequest
  ): IO[AwsError, zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly]
  def getCurrentUserData(
      request: GetCurrentUserDataRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.UserData.ReadOnly]
  def getCurrentUserDataPaginated(
      request: GetCurrentUserDataRequest
  ): IO[AwsError, zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly]
  def updateQueueName(request: UpdateQueueNameRequest): IO[AwsError, Unit]
  def listQueueQuickConnects(
      request: ListQueueQuickConnectsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.QuickConnectSummary.ReadOnly]
  def listQueueQuickConnectsPaginated(
      request: ListQueueQuickConnectsRequest
  ): IO[AwsError, zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly]
  def associateSecurityKey(
      request: AssociateSecurityKeyRequest
  ): IO[AwsError, zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly]
  def listLambdaFunctions(
      request: ListLambdaFunctionsRequest
  ): ZStream[Any, AwsError, FunctionArn]
  def listLambdaFunctionsPaginated(
      request: ListLambdaFunctionsRequest
  ): IO[AwsError, zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly]
  def associateQueueQuickConnects(
      request: AssociateQueueQuickConnectsRequest
  ): IO[AwsError, Unit]
  def updateAgentStatus(request: UpdateAgentStatusRequest): IO[AwsError, Unit]
  def describeQueue(
      request: DescribeQueueRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeQueueResponse.ReadOnly]
  def createVocabulary(
      request: CreateVocabularyRequest
  ): IO[AwsError, zio.aws.connect.model.CreateVocabularyResponse.ReadOnly]
  def searchQueues(
      request: SearchQueuesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchQueuesResponse.ReadOnly,
    zio.aws.connect.model.Queue.ReadOnly
  ]]
  def searchQueuesPaginated(
      request: SearchQueuesRequest
  ): IO[AwsError, zio.aws.connect.model.SearchQueuesResponse.ReadOnly]
  def disassociateSecurityKey(
      request: DisassociateSecurityKeyRequest
  ): IO[AwsError, Unit]
  def startContactStreaming(
      request: StartContactStreamingRequest
  ): IO[AwsError, zio.aws.connect.model.StartContactStreamingResponse.ReadOnly]
  def updateContactAttributes(request: UpdateContactAttributesRequest): IO[
    AwsError,
    zio.aws.connect.model.UpdateContactAttributesResponse.ReadOnly
  ]
  def deleteSecurityProfile(
      request: DeleteSecurityProfileRequest
  ): IO[AwsError, Unit]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.connect.model.CreateUserResponse.ReadOnly]
  def createContactFlowModule(request: CreateContactFlowModuleRequest): IO[
    AwsError,
    zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly
  ]
  def disassociateBot(request: DisassociateBotRequest): IO[AwsError, Unit]
  def listPhoneNumbers(
      request: ListPhoneNumbersRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.PhoneNumberSummary.ReadOnly]
  def listPhoneNumbersPaginated(
      request: ListPhoneNumbersRequest
  ): IO[AwsError, zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly]
  def updateUserHierarchyGroupName(
      request: UpdateUserHierarchyGroupNameRequest
  ): IO[AwsError, Unit]
  def disassociateQueueQuickConnects(
      request: DisassociateQueueQuickConnectsRequest
  ): IO[AwsError, Unit]
  def claimPhoneNumber(
      request: ClaimPhoneNumberRequest
  ): IO[AwsError, zio.aws.connect.model.ClaimPhoneNumberResponse.ReadOnly]
  def describeSecurityProfile(request: DescribeSecurityProfileRequest): IO[
    AwsError,
    zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly
  ]
  def updatePhoneNumber(
      request: UpdatePhoneNumberRequest
  ): IO[AwsError, zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly]
  def listContactReferences(
      request: ListContactReferencesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.ReferenceSummary.ReadOnly]
  def listContactReferencesPaginated(
      request: ListContactReferencesRequest
  ): IO[AwsError, zio.aws.connect.model.ListContactReferencesResponse.ReadOnly]
  def updateQueueHoursOfOperation(
      request: UpdateQueueHoursOfOperationRequest
  ): IO[AwsError, Unit]
  def updateInstanceStorageConfig(
      request: UpdateInstanceStorageConfigRequest
  ): IO[AwsError, Unit]
  def listPrompts(
      request: ListPromptsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.PromptSummary.ReadOnly]
  def listPromptsPaginated(
      request: ListPromptsRequest
  ): IO[AwsError, zio.aws.connect.model.ListPromptsResponse.ReadOnly]
  def deleteHoursOfOperation(
      request: DeleteHoursOfOperationRequest
  ): IO[AwsError, Unit]
  def listTrafficDistributionGroups(
      request: ListTrafficDistributionGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
  ]
  def listTrafficDistributionGroupsPaginated(
      request: ListTrafficDistributionGroupsRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly
  ]
  def deleteUseCase(request: DeleteUseCaseRequest): IO[AwsError, Unit]
  def listTaskTemplates(
      request: ListTaskTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.TaskTemplateMetadata.ReadOnly]
  def listTaskTemplatesPaginated(
      request: ListTaskTemplatesRequest
  ): IO[AwsError, zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly]
  def associateRoutingProfileQueues(
      request: AssociateRoutingProfileQueuesRequest
  ): IO[AwsError, Unit]
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.AvailableNumberSummary.ReadOnly
  ]
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def describeContact(
      request: DescribeContactRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeContactResponse.ReadOnly]
  def searchSecurityProfiles(
      request: SearchSecurityProfilesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly,
    zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
  ]]
  def searchSecurityProfilesPaginated(
      request: SearchSecurityProfilesRequest
  ): IO[AwsError, zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly]
  def updateUserPhoneConfig(
      request: UpdateUserPhoneConfigRequest
  ): IO[AwsError, Unit]
  def listRoutingProfileQueues(
      request: ListRoutingProfileQueuesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
  ]
  def listRoutingProfileQueuesPaginated(
      request: ListRoutingProfileQueuesRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly
  ]
  def updateQueueStatus(request: UpdateQueueStatusRequest): IO[AwsError, Unit]
  def replicateInstance(
      request: ReplicateInstanceRequest
  ): IO[AwsError, zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly]
  def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.SecurityProfileSummary.ReadOnly
  ]
  def listSecurityProfilesPaginated(
      request: ListSecurityProfilesRequest
  ): IO[AwsError, ReadOnly]
  def listSecurityProfilePermissions(
      request: ListSecurityProfilePermissionsRequest
  ): ZStream[Any, AwsError, SecurityProfilePermission]
  def listSecurityProfilePermissionsPaginated(
      request: ListSecurityProfilePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly
  ]
  def deleteIntegrationAssociation(
      request: DeleteIntegrationAssociationRequest
  ): IO[AwsError, Unit]
  def stopContactStreaming(
      request: StopContactStreamingRequest
  ): IO[AwsError, zio.aws.connect.model.StopContactStreamingResponse.ReadOnly]
  def listBots(
      request: ListBotsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.LexBotConfig.ReadOnly]
  def listBotsPaginated(
      request: ListBotsRequest
  ): IO[AwsError, zio.aws.connect.model.ListBotsResponse.ReadOnly]
  def deleteQuickConnect(request: DeleteQuickConnectRequest): IO[AwsError, Unit]
  def listSecurityKeys(
      request: ListSecurityKeysRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.SecurityKey.ReadOnly]
  def listSecurityKeysPaginated(
      request: ListSecurityKeysRequest
  ): IO[AwsError, zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly]
  def stopContact(
      request: StopContactRequest
  ): IO[AwsError, zio.aws.connect.model.StopContactResponse.ReadOnly]
  def createQueue(
      request: CreateQueueRequest
  ): IO[AwsError, zio.aws.connect.model.CreateQueueResponse.ReadOnly]
  def updateQueueMaxContacts(
      request: UpdateQueueMaxContactsRequest
  ): IO[AwsError, Unit]
  def deleteTrafficDistributionGroup(
      request: DeleteTrafficDistributionGroupRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.ReadOnly
  ]
  def describeInstanceStorageConfig(
      request: DescribeInstanceStorageConfigRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly
  ]
  def describeAgentStatus(
      request: DescribeAgentStatusRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly]
  def associateApprovedOrigin(
      request: AssociateApprovedOriginRequest
  ): IO[AwsError, Unit]
  def transferContact(
      request: TransferContactRequest
  ): IO[AwsError, zio.aws.connect.model.TransferContactResponse.ReadOnly]
  def listLexBots(
      request: ListLexBotsRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly]
  def listLexBotsPaginated(
      request: ListLexBotsRequest
  ): IO[AwsError, zio.aws.connect.model.ListLexBotsResponse.ReadOnly]
  def getCurrentMetricData(
      request: GetCurrentMetricDataRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly,
    zio.aws.connect.model.CurrentMetricResult.ReadOnly
  ]]
  def getCurrentMetricDataPaginated(
      request: GetCurrentMetricDataRequest
  ): IO[AwsError, zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly]
  def stopContactRecording(
      request: StopContactRecordingRequest
  ): IO[AwsError, zio.aws.connect.model.StopContactRecordingResponse.ReadOnly]
  def describeInstanceAttribute(request: DescribeInstanceAttributeRequest): IO[
    AwsError,
    zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly
  ]
  def describeUser(
      request: DescribeUserRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeUserResponse.ReadOnly]
  def updateContactFlowMetadata(
      request: UpdateContactFlowMetadataRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.connect.model.ListTagsForResourceResponse.ReadOnly]
  def describeUserHierarchyGroup(
      request: DescribeUserHierarchyGroupRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly
  ]
  def createTaskTemplate(
      request: CreateTaskTemplateRequest
  ): IO[AwsError, zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def listUseCases(
      request: ListUseCasesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.UseCase.ReadOnly]
  def listUseCasesPaginated(
      request: ListUseCasesRequest
  ): IO[AwsError, zio.aws.connect.model.ListUseCasesResponse.ReadOnly]
  def suspendContactRecording(request: SuspendContactRecordingRequest): IO[
    AwsError,
    zio.aws.connect.model.SuspendContactRecordingResponse.ReadOnly
  ]
  def describeContactFlow(
      request: DescribeContactFlowRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly]
  def startContactRecording(
      request: StartContactRecordingRequest
  ): IO[AwsError, zio.aws.connect.model.StartContactRecordingResponse.ReadOnly]
  def associateInstanceStorageConfig(
      request: AssociateInstanceStorageConfigRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly
  ]
  def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit]
  def listIntegrationAssociations(
      request: ListIntegrationAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
  ]
  def listIntegrationAssociationsPaginated(
      request: ListIntegrationAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly
  ]
  def searchVocabularies(
      request: SearchVocabulariesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.VocabularySummary.ReadOnly]
  def searchVocabulariesPaginated(
      request: SearchVocabulariesRequest
  ): IO[AwsError, zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly]
  def createIntegrationAssociation(
      request: CreateIntegrationAssociationRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly
  ]
  def disassociateLexBot(request: DisassociateLexBotRequest): IO[AwsError, Unit]
  def listInstanceAttributes(
      request: ListInstanceAttributesRequest
  ): ZStream[Any, AwsError, zio.aws.connect.model.Attribute.ReadOnly]
  def listInstanceAttributesPaginated(
      request: ListInstanceAttributesRequest
  ): IO[AwsError, zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly]
  def listHoursOfOperations(request: ListHoursOfOperationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
  ]
  def listHoursOfOperationsPaginated(
      request: ListHoursOfOperationsRequest
  ): IO[AwsError, zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly]
  def updateContactFlowName(
      request: UpdateContactFlowNameRequest
  ): IO[AwsError, Unit]
  def createInstance(
      request: CreateInstanceRequest
  ): IO[AwsError, zio.aws.connect.model.CreateInstanceResponse.ReadOnly]
  def listUserHierarchyGroups(request: ListUserHierarchyGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
  ]
  def listUserHierarchyGroupsPaginated(
      request: ListUserHierarchyGroupsRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly
  ]
  def disassociateInstanceStorageConfig(
      request: DisassociateInstanceStorageConfigRequest
  ): IO[AwsError, Unit]
  def updateSecurityProfile(
      request: UpdateSecurityProfileRequest
  ): IO[AwsError, Unit]
  def describeContactFlowModule(request: DescribeContactFlowModuleRequest): IO[
    AwsError,
    zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly
  ]
  def startOutboundVoiceContact(request: StartOutboundVoiceContactRequest): IO[
    AwsError,
    zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly
  ]
  def updateInstanceAttribute(
      request: UpdateInstanceAttributeRequest
  ): IO[AwsError, Unit]
  def updateUserHierarchyStructure(
      request: UpdateUserHierarchyStructureRequest
  ): IO[AwsError, Unit]
  def describeQuickConnect(
      request: DescribeQuickConnectRequest
  ): IO[AwsError, zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly]
  def listApprovedOrigins(
      request: ListApprovedOriginsRequest
  ): ZStream[Any, AwsError, Origin]
  def listApprovedOriginsPaginated(
      request: ListApprovedOriginsRequest
  ): IO[AwsError, zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly]
  def updateUserRoutingProfile(
      request: UpdateUserRoutingProfileRequest
  ): IO[AwsError, Unit]
  def createQuickConnect(
      request: CreateQuickConnectRequest
  ): IO[AwsError, zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly]
  def putUserStatus(
      request: PutUserStatusRequest
  ): IO[AwsError, zio.aws.connect.model.PutUserStatusResponse.ReadOnly]
  def updateQuickConnectName(
      request: UpdateQuickConnectNameRequest
  ): IO[AwsError, Unit]
  def createHoursOfOperation(
      request: CreateHoursOfOperationRequest
  ): IO[AwsError, zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly]
  def createUserHierarchyGroup(request: CreateUserHierarchyGroupRequest): IO[
    AwsError,
    zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly
  ]
  def deleteUserHierarchyGroup(
      request: DeleteUserHierarchyGroupRequest
  ): IO[AwsError, Unit]
  def associateLambdaFunction(
      request: AssociateLambdaFunctionRequest
  ): IO[AwsError, Unit]
  def updateUserHierarchy(
      request: UpdateUserHierarchyRequest
  ): IO[AwsError, Unit]
  def startTaskContact(
      request: StartTaskContactRequest
  ): IO[AwsError, zio.aws.connect.model.StartTaskContactResponse.ReadOnly]
  def describeUserHierarchyStructure(
      request: DescribeUserHierarchyStructureRequest
  ): IO[
    AwsError,
    zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly
  ]
  def disassociateApprovedOrigin(
      request: DisassociateApprovedOriginRequest
  ): IO[AwsError, Unit]
}
object Connect {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Connect] = customized(
    identity
  )
  def customized(
      customization: ConnectAsyncClientBuilder => ConnectAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Connect] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ConnectAsyncClientBuilder => ConnectAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Connect] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ConnectAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[ConnectAsyncClient, ConnectAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[ConnectAsyncClient, ConnectAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ConnectImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ConnectImpl[R](
      override val api: ConnectAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Connect
      with AwsServiceBase[R] {
    override val serviceName: String = "Connect"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ConnectImpl[R1] = new ConnectImpl(api, newAspect, r)
    def updateContact(
        request: UpdateContactRequest
    ): IO[AwsError, zio.aws.connect.model.UpdateContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.UpdateContactRequest,
        UpdateContactResponse
      ]("updateContact", api.updateContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.UpdateContactResponse.wrap)
        .provideEnvironment(r)
    def listContactFlowModules(request: ListContactFlowModulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest,
      ListContactFlowModulesResponse,
      ContactFlowModuleSummary
    ](
      "listContactFlowModules",
      api.listContactFlowModules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.contactFlowModulesSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.ContactFlowModuleSummary.wrap(item))
      .provideEnvironment(r)
    def listContactFlowModulesPaginated(
        request: ListContactFlowModulesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest,
      ListContactFlowModulesResponse
    ]("listContactFlowModules", api.listContactFlowModules)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListContactFlowModulesResponse.wrap)
      .provideEnvironment(r)
    def deleteTaskTemplate(
        request: DeleteTaskTemplateRequest
    ): IO[AwsError, zio.aws.connect.model.DeleteTaskTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest,
        DeleteTaskTemplateResponse
      ]("deleteTaskTemplate", api.deleteTaskTemplate)(request.buildAwsValue())
        .map(zio.aws.connect.model.DeleteTaskTemplateResponse.wrap)
        .provideEnvironment(r)
    def listAgentStatuses(request: ListAgentStatusesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.AgentStatusSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest,
      ListAgentStatusesResponse,
      AgentStatusSummary
    ](
      "listAgentStatuses",
      api.listAgentStatuses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.agentStatusSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.AgentStatusSummary.wrap(item))
      .provideEnvironment(r)
    def listAgentStatusesPaginated(
        request: ListAgentStatusesRequest
    ): IO[AwsError, zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest,
        ListAgentStatusesResponse
      ]("listAgentStatuses", api.listAgentStatuses)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListAgentStatusesResponse.wrap)
        .provideEnvironment(r)
    def createUseCase(
        request: CreateUseCaseRequest
    ): IO[AwsError, zio.aws.connect.model.CreateUseCaseResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateUseCaseRequest,
        CreateUseCaseResponse
      ]("createUseCase", api.createUseCase)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateUseCaseResponse.wrap)
        .provideEnvironment(r)
    def updateRoutingProfileDefaultOutboundQueue(
        request: UpdateRoutingProfileDefaultOutboundQueueRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest,
      UpdateRoutingProfileDefaultOutboundQueueResponse
    ](
      "updateRoutingProfileDefaultOutboundQueue",
      api.updateRoutingProfileDefaultOutboundQueue
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listUsers(
        request: ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.UserSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListUsersRequest,
        ListUsersResponse,
        UserSummary
      ](
        "listUsers",
        api.listUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.userSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.UserSummary.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: ListUsersRequest
    ): IO[AwsError, zio.aws.connect.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListUsersRequest,
        ListUsersResponse
      ]("listUsers", api.listUsers)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def createRoutingProfile(request: CreateRoutingProfileRequest): IO[
      AwsError,
      zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest,
      CreateRoutingProfileResponse
    ]("createRoutingProfile", api.createRoutingProfile)(request.buildAwsValue())
      .map(zio.aws.connect.model.CreateRoutingProfileResponse.wrap)
      .provideEnvironment(r)
    def listRoutingProfiles(request: ListRoutingProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.RoutingProfileSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest,
      ListRoutingProfilesResponse,
      RoutingProfileSummary
    ](
      "listRoutingProfiles",
      api.listRoutingProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.routingProfileSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.RoutingProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listRoutingProfilesPaginated(request: ListRoutingProfilesRequest): IO[
      AwsError,
      zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest,
      ListRoutingProfilesResponse
    ]("listRoutingProfiles", api.listRoutingProfiles)(request.buildAwsValue())
      .map(zio.aws.connect.model.ListRoutingProfilesResponse.wrap)
      .provideEnvironment(r)
    def updateTaskTemplate(
        request: UpdateTaskTemplateRequest
    ): IO[AwsError, zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest,
        UpdateTaskTemplateResponse
      ]("updateTaskTemplate", api.updateTaskTemplate)(request.buildAwsValue())
        .map(zio.aws.connect.model.UpdateTaskTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteContactFlow(
        request: DeleteContactFlowRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest,
      DeleteContactFlowResponse
    ]("deleteContactFlow", api.deleteContactFlow)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def getTrafficDistribution(request: GetTrafficDistributionRequest): IO[
      AwsError,
      zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest,
      GetTrafficDistributionResponse
    ]("getTrafficDistribution", api.getTrafficDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.GetTrafficDistributionResponse.wrap)
      .provideEnvironment(r)
    def disassociateRoutingProfileQueues(
        request: DisassociateRoutingProfileQueuesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest,
      DisassociateRoutingProfileQueuesResponse
    ]("disassociateRoutingProfileQueues", api.disassociateRoutingProfileQueues)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateLambdaFunction(
        request: DisassociateLambdaFunctionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest,
      DisassociateLambdaFunctionResponse
    ]("disassociateLambdaFunction", api.disassociateLambdaFunction)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describePhoneNumber(request: DescribePhoneNumberRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest,
      DescribePhoneNumberResponse
    ]("describePhoneNumber", api.describePhoneNumber)(request.buildAwsValue())
      .map(zio.aws.connect.model.DescribePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def describeVocabulary(
        request: DescribeVocabularyRequest
    ): IO[AwsError, zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest,
        DescribeVocabularyResponse
      ]("describeVocabulary", api.describeVocabulary)(request.buildAwsValue())
        .map(zio.aws.connect.model.DescribeVocabularyResponse.wrap)
        .provideEnvironment(r)
    def searchUsers(
        request: SearchUsersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.connect.model.SearchUsersResponse.ReadOnly,
      zio.aws.connect.model.UserSearchSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchUsersRequest,
      SearchUsersResponse,
      UserSearchSummary
    ](
      "searchUsers",
      api.searchUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.connect.model.SearchUsersResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.connect.model.UserSearchSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchUsersPaginated(
        request: SearchUsersRequest
    ): IO[AwsError, zio.aws.connect.model.SearchUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.SearchUsersRequest,
        SearchUsersResponse
      ]("searchUsers", api.searchUsers)(request.buildAwsValue())
        .map(zio.aws.connect.model.SearchUsersResponse.wrap)
        .provideEnvironment(r)
    def createAgentStatus(
        request: CreateAgentStatusRequest
    ): IO[AwsError, zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest,
        CreateAgentStatusResponse
      ]("createAgentStatus", api.createAgentStatus)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateAgentStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteVocabulary(
        request: DeleteVocabularyRequest
    ): IO[AwsError, zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest,
        DeleteVocabularyResponse
      ]("deleteVocabulary", api.deleteVocabulary)(request.buildAwsValue())
        .map(zio.aws.connect.model.DeleteVocabularyResponse.wrap)
        .provideEnvironment(r)
    def listInstanceStorageConfigs(
        request: ListInstanceStorageConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest,
      ListInstanceStorageConfigsResponse,
      InstanceStorageConfig
    ](
      "listInstanceStorageConfigs",
      api.listInstanceStorageConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storageConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.InstanceStorageConfig.wrap(item))
      .provideEnvironment(r)
    def listInstanceStorageConfigsPaginated(
        request: ListInstanceStorageConfigsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest,
      ListInstanceStorageConfigsResponse
    ]("listInstanceStorageConfigs", api.listInstanceStorageConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListInstanceStorageConfigsResponse.wrap)
      .provideEnvironment(r)
    def updateHoursOfOperation(
        request: UpdateHoursOfOperationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest,
      UpdateHoursOfOperationResponse
    ]("updateHoursOfOperation", api.updateHoursOfOperation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startChatContact(
        request: StartChatContactRequest
    ): IO[AwsError, zio.aws.connect.model.StartChatContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.StartChatContactRequest,
        StartChatContactResponse
      ]("startChatContact", api.startChatContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.StartChatContactResponse.wrap)
        .provideEnvironment(r)
    def updateRoutingProfileQueues(
        request: UpdateRoutingProfileQueuesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesRequest,
      UpdateRoutingProfileQueuesResponse
    ]("updateRoutingProfileQueues", api.updateRoutingProfileQueues)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeInstance(
        request: DescribeInstanceRequest
    ): IO[AwsError, zio.aws.connect.model.DescribeInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DescribeInstanceRequest,
        DescribeInstanceResponse
      ]("describeInstance", api.describeInstance)(request.buildAwsValue())
        .map(zio.aws.connect.model.DescribeInstanceResponse.wrap)
        .provideEnvironment(r)
    def getContactAttributes(request: GetContactAttributesRequest): IO[
      AwsError,
      zio.aws.connect.model.GetContactAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.GetContactAttributesRequest,
      GetContactAttributesResponse
    ]("getContactAttributes", api.getContactAttributes)(request.buildAwsValue())
      .map(zio.aws.connect.model.GetContactAttributesResponse.wrap)
      .provideEnvironment(r)
    def createSecurityProfile(request: CreateSecurityProfileRequest): IO[
      AwsError,
      zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest,
      CreateSecurityProfileResponse
    ]("createSecurityProfile", api.createSecurityProfile)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateSecurityProfileResponse.wrap)
      .provideEnvironment(r)
    def disassociatePhoneNumberContactFlow(
        request: DisassociatePhoneNumberContactFlowRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest,
      DisassociatePhoneNumberContactFlowResponse
    ](
      "disassociatePhoneNumberContactFlow",
      api.disassociatePhoneNumberContactFlow
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateQueueOutboundCallerConfig(
        request: UpdateQueueOutboundCallerConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest,
      UpdateQueueOutboundCallerConfigResponse
    ]("updateQueueOutboundCallerConfig", api.updateQueueOutboundCallerConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPhoneNumbersV2(request: ListPhoneNumbersV2Request): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request,
      ListPhoneNumbersV2Response,
      ListPhoneNumbersSummary
    ](
      "listPhoneNumbersV2",
      api.listPhoneNumbersV2,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.listPhoneNumbersSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.ListPhoneNumbersSummary.wrap(item))
      .provideEnvironment(r)
    def listPhoneNumbersV2Paginated(
        request: ListPhoneNumbersV2Request
    ): IO[AwsError, zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request,
        ListPhoneNumbersV2Response
      ]("listPhoneNumbersV2", api.listPhoneNumbersV2)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListPhoneNumbersV2Response.wrap)
        .provideEnvironment(r)
    def createTrafficDistributionGroup(
        request: CreateTrafficDistributionGroupRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest,
      CreateTrafficDistributionGroupResponse
    ]("createTrafficDistributionGroup", api.createTrafficDistributionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateTrafficDistributionGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteContactFlowModule(request: DeleteContactFlowModuleRequest): IO[
      AwsError,
      zio.aws.connect.model.DeleteContactFlowModuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest,
      DeleteContactFlowModuleResponse
    ]("deleteContactFlowModule", api.deleteContactFlowModule)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DeleteContactFlowModuleResponse.wrap)
      .provideEnvironment(r)
    def getTaskTemplate(
        request: GetTaskTemplateRequest
    ): IO[AwsError, zio.aws.connect.model.GetTaskTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest,
        GetTaskTemplateResponse
      ]("getTaskTemplate", api.getTaskTemplate)(request.buildAwsValue())
        .map(zio.aws.connect.model.GetTaskTemplateResponse.wrap)
        .provideEnvironment(r)
    def createContactFlow(
        request: CreateContactFlowRequest
    ): IO[AwsError, zio.aws.connect.model.CreateContactFlowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateContactFlowRequest,
        CreateContactFlowResponse
      ]("createContactFlow", api.createContactFlow)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateContactFlowResponse.wrap)
        .provideEnvironment(r)
    def listInstances(
        request: ListInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.InstanceSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListInstancesRequest,
        ListInstancesResponse,
        InstanceSummary
      ](
        "listInstances",
        api.listInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.InstanceSummary.wrap(item))
        .provideEnvironment(r)
    def listInstancesPaginated(
        request: ListInstancesRequest
    ): IO[AwsError, zio.aws.connect.model.ListInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListInstancesRequest,
        ListInstancesResponse
      ]("listInstances", api.listInstances)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListInstancesResponse.wrap)
        .provideEnvironment(r)
    def updateContactFlowContent(
        request: UpdateContactFlowContentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest,
      UpdateContactFlowContentResponse
    ]("updateContactFlowContent", api.updateContactFlowContent)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def associateDefaultVocabulary(
        request: AssociateDefaultVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.AssociateDefaultVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest,
      AssociateDefaultVocabularyResponse
    ]("associateDefaultVocabulary", api.associateDefaultVocabulary)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.AssociateDefaultVocabularyResponse.wrap)
      .provideEnvironment(r)
    def associateLexBot(request: AssociateLexBotRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.AssociateLexBotRequest,
        AssociateLexBotResponse
      ]("associateLexBot", api.associateLexBot)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def associatePhoneNumberContactFlow(
        request: AssociatePhoneNumberContactFlowRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest,
      AssociatePhoneNumberContactFlowResponse
    ]("associatePhoneNumberContactFlow", api.associatePhoneNumberContactFlow)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeHoursOfOperation(request: DescribeHoursOfOperationRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest,
      DescribeHoursOfOperationResponse
    ]("describeHoursOfOperation", api.describeHoursOfOperation)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeHoursOfOperationResponse.wrap)
      .provideEnvironment(r)
    def describeRoutingProfile(request: DescribeRoutingProfileRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest,
      DescribeRoutingProfileResponse
    ]("describeRoutingProfile", api.describeRoutingProfile)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeRoutingProfileResponse.wrap)
      .provideEnvironment(r)
    def updateRoutingProfileName(
        request: UpdateRoutingProfileNameRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest,
      UpdateRoutingProfileNameResponse
    ]("updateRoutingProfileName", api.updateRoutingProfileName)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDefaultVocabularies(
        request: ListDefaultVocabulariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.DefaultVocabulary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest,
      ListDefaultVocabulariesResponse,
      DefaultVocabulary
    ](
      "listDefaultVocabularies",
      api.listDefaultVocabularies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.defaultVocabularyList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.DefaultVocabulary.wrap(item))
      .provideEnvironment(r)
    def listDefaultVocabulariesPaginated(
        request: ListDefaultVocabulariesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest,
      ListDefaultVocabulariesResponse
    ]("listDefaultVocabularies", api.listDefaultVocabularies)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListDefaultVocabulariesResponse.wrap)
      .provideEnvironment(r)
    def updateContactFlowModuleContent(
        request: UpdateContactFlowModuleContentRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.UpdateContactFlowModuleContentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest,
      UpdateContactFlowModuleContentResponse
    ]("updateContactFlowModuleContent", api.updateContactFlowModuleContent)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.UpdateContactFlowModuleContentResponse.wrap)
      .provideEnvironment(r)
    def releasePhoneNumber(
        request: ReleasePhoneNumberRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest,
      ReleasePhoneNumberResponse
    ]("releasePhoneNumber", api.releasePhoneNumber)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateQuickConnectConfig(
        request: UpdateQuickConnectConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest,
      UpdateQuickConnectConfigResponse
    ]("updateQuickConnectConfig", api.updateQuickConnectConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateUserIdentityInfo(
        request: UpdateUserIdentityInfoRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest,
      UpdateUserIdentityInfoResponse
    ]("updateUserIdentityInfo", api.updateUserIdentityInfo)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateUserSecurityProfiles(
        request: UpdateUserSecurityProfilesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest,
      UpdateUserSecurityProfilesResponse
    ]("updateUserSecurityProfiles", api.updateUserSecurityProfiles)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listContactFlows(request: ListContactFlowsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.ContactFlowSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListContactFlowsRequest,
      ListContactFlowsResponse,
      ContactFlowSummary
    ](
      "listContactFlows",
      api.listContactFlows,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.contactFlowSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.ContactFlowSummary.wrap(item))
      .provideEnvironment(r)
    def listContactFlowsPaginated(
        request: ListContactFlowsRequest
    ): IO[AwsError, zio.aws.connect.model.ListContactFlowsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListContactFlowsRequest,
        ListContactFlowsResponse
      ]("listContactFlows", api.listContactFlows)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListContactFlowsResponse.wrap)
        .provideEnvironment(r)
    def listQueues(
        request: ListQueuesRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.QueueSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListQueuesRequest,
        ListQueuesResponse,
        QueueSummary
      ](
        "listQueues",
        api.listQueues,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.queueSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.QueueSummary.wrap(item))
        .provideEnvironment(r)
    def listQueuesPaginated(
        request: ListQueuesRequest
    ): IO[AwsError, zio.aws.connect.model.ListQueuesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListQueuesRequest,
        ListQueuesResponse
      ]("listQueues", api.listQueues)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListQueuesResponse.wrap)
        .provideEnvironment(r)
    def updateRoutingProfileConcurrency(
        request: UpdateRoutingProfileConcurrencyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest,
      UpdateRoutingProfileConcurrencyResponse
    ]("updateRoutingProfileConcurrency", api.updateRoutingProfileConcurrency)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def associateBot(request: AssociateBotRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.AssociateBotRequest,
        AssociateBotResponse
      ]("associateBot", api.associateBot)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateContactFlowModuleMetadata(
        request: UpdateContactFlowModuleMetadataRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest,
      UpdateContactFlowModuleMetadataResponse
    ]("updateContactFlowModuleMetadata", api.updateContactFlowModuleMetadata)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.wrap)
      .provideEnvironment(r)
    def describeTrafficDistributionGroup(
        request: DescribeTrafficDistributionGroupRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest,
      DescribeTrafficDistributionGroupResponse
    ]("describeTrafficDistributionGroup", api.describeTrafficDistributionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.wrap)
      .provideEnvironment(r)
    def resumeContactRecording(request: ResumeContactRecordingRequest): IO[
      AwsError,
      zio.aws.connect.model.ResumeContactRecordingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest,
      ResumeContactRecordingResponse
    ]("resumeContactRecording", api.resumeContactRecording)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ResumeContactRecordingResponse.wrap)
      .provideEnvironment(r)
    def getFederationToken(
        request: GetFederationTokenRequest
    ): IO[AwsError, zio.aws.connect.model.GetFederationTokenResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.GetFederationTokenRequest,
        GetFederationTokenResponse
      ]("getFederationToken", api.getFederationToken)(request.buildAwsValue())
        .map(zio.aws.connect.model.GetFederationTokenResponse.wrap)
        .provideEnvironment(r)
    def updateContactSchedule(request: UpdateContactScheduleRequest): IO[
      AwsError,
      zio.aws.connect.model.UpdateContactScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest,
      UpdateContactScheduleResponse
    ]("updateContactSchedule", api.updateContactSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.UpdateContactScheduleResponse.wrap)
      .provideEnvironment(r)
    def deleteInstance(request: DeleteInstanceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DeleteInstanceRequest,
        DeleteInstanceResponse
      ]("deleteInstance", api.deleteInstance)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def searchRoutingProfiles(
        request: SearchRoutingProfilesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly,
      zio.aws.connect.model.RoutingProfile.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest,
      SearchRoutingProfilesResponse,
      RoutingProfile
    ](
      "searchRoutingProfiles",
      api.searchRoutingProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.routingProfiles().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.connect.model.SearchRoutingProfilesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.connect.model.RoutingProfile.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchRoutingProfilesPaginated(
        request: SearchRoutingProfilesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest,
      SearchRoutingProfilesResponse
    ]("searchRoutingProfiles", api.searchRoutingProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.SearchRoutingProfilesResponse.wrap)
      .provideEnvironment(r)
    def updateTrafficDistribution(
        request: UpdateTrafficDistributionRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.UpdateTrafficDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest,
      UpdateTrafficDistributionResponse
    ]("updateTrafficDistribution", api.updateTrafficDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.UpdateTrafficDistributionResponse.wrap)
      .provideEnvironment(r)
    def getMetricData(request: GetMetricDataRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.HistoricalMetricResult.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.GetMetricDataRequest,
      GetMetricDataResponse,
      HistoricalMetricResult
    ](
      "getMetricData",
      api.getMetricData,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metricResults().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.HistoricalMetricResult.wrap(item))
      .provideEnvironment(r)
    def getMetricDataPaginated(
        request: GetMetricDataRequest
    ): IO[AwsError, zio.aws.connect.model.GetMetricDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.GetMetricDataRequest,
        GetMetricDataResponse
      ]("getMetricData", api.getMetricData)(request.buildAwsValue())
        .map(zio.aws.connect.model.GetMetricDataResponse.wrap)
        .provideEnvironment(r)
    def listQuickConnects(request: ListQuickConnectsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.QuickConnectSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest,
      ListQuickConnectsResponse,
      QuickConnectSummary
    ](
      "listQuickConnects",
      api.listQuickConnects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.quickConnectSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.QuickConnectSummary.wrap(item))
      .provideEnvironment(r)
    def listQuickConnectsPaginated(
        request: ListQuickConnectsRequest
    ): IO[AwsError, zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest,
        ListQuickConnectsResponse
      ]("listQuickConnects", api.listQuickConnects)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListQuickConnectsResponse.wrap)
        .provideEnvironment(r)
    def getCurrentUserData(
        request: GetCurrentUserDataRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.UserData.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest,
        GetCurrentUserDataResponse,
        UserData
      ](
        "getCurrentUserData",
        api.getCurrentUserData,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.userDataList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.UserData.wrap(item))
        .provideEnvironment(r)
    def getCurrentUserDataPaginated(
        request: GetCurrentUserDataRequest
    ): IO[AwsError, zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest,
        GetCurrentUserDataResponse
      ]("getCurrentUserData", api.getCurrentUserData)(request.buildAwsValue())
        .map(zio.aws.connect.model.GetCurrentUserDataResponse.wrap)
        .provideEnvironment(r)
    def updateQueueName(request: UpdateQueueNameRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest,
        UpdateQueueNameResponse
      ]("updateQueueName", api.updateQueueName)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listQueueQuickConnects(request: ListQueueQuickConnectsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.QuickConnectSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest,
      ListQueueQuickConnectsResponse,
      QuickConnectSummary
    ](
      "listQueueQuickConnects",
      api.listQueueQuickConnects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.quickConnectSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.QuickConnectSummary.wrap(item))
      .provideEnvironment(r)
    def listQueueQuickConnectsPaginated(
        request: ListQueueQuickConnectsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest,
      ListQueueQuickConnectsResponse
    ]("listQueueQuickConnects", api.listQueueQuickConnects)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListQueueQuickConnectsResponse.wrap)
      .provideEnvironment(r)
    def associateSecurityKey(request: AssociateSecurityKeyRequest): IO[
      AwsError,
      zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest,
      AssociateSecurityKeyResponse
    ]("associateSecurityKey", api.associateSecurityKey)(request.buildAwsValue())
      .map(zio.aws.connect.model.AssociateSecurityKeyResponse.wrap)
      .provideEnvironment(r)
    def listLambdaFunctions(
        request: ListLambdaFunctionsRequest
    ): ZStream[Any, AwsError, FunctionArn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest,
      ListLambdaFunctionsResponse,
      java.lang.String
    ](
      "listLambdaFunctions",
      api.listLambdaFunctions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.lambdaFunctions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.primitives.FunctionArn(item))
      .provideEnvironment(r)
    def listLambdaFunctionsPaginated(request: ListLambdaFunctionsRequest): IO[
      AwsError,
      zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest,
      ListLambdaFunctionsResponse
    ]("listLambdaFunctions", api.listLambdaFunctions)(request.buildAwsValue())
      .map(zio.aws.connect.model.ListLambdaFunctionsResponse.wrap)
      .provideEnvironment(r)
    def associateQueueQuickConnects(
        request: AssociateQueueQuickConnectsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest,
      AssociateQueueQuickConnectsResponse
    ]("associateQueueQuickConnects", api.associateQueueQuickConnects)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateAgentStatus(
        request: UpdateAgentStatusRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest,
      UpdateAgentStatusResponse
    ]("updateAgentStatus", api.updateAgentStatus)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeQueue(
        request: DescribeQueueRequest
    ): IO[AwsError, zio.aws.connect.model.DescribeQueueResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DescribeQueueRequest,
        DescribeQueueResponse
      ]("describeQueue", api.describeQueue)(request.buildAwsValue())
        .map(zio.aws.connect.model.DescribeQueueResponse.wrap)
        .provideEnvironment(r)
    def createVocabulary(
        request: CreateVocabularyRequest
    ): IO[AwsError, zio.aws.connect.model.CreateVocabularyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateVocabularyRequest,
        CreateVocabularyResponse
      ]("createVocabulary", api.createVocabulary)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateVocabularyResponse.wrap)
        .provideEnvironment(r)
    def searchQueues(
        request: SearchQueuesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.connect.model.SearchQueuesResponse.ReadOnly,
      zio.aws.connect.model.Queue.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchQueuesRequest,
      SearchQueuesResponse,
      Queue
    ](
      "searchQueues",
      api.searchQueues,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queues().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.connect.model.SearchQueuesResponse.wrap)
          .mapOutput(_.map(item => zio.aws.connect.model.Queue.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchQueuesPaginated(
        request: SearchQueuesRequest
    ): IO[AwsError, zio.aws.connect.model.SearchQueuesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.SearchQueuesRequest,
        SearchQueuesResponse
      ]("searchQueues", api.searchQueues)(request.buildAwsValue())
        .map(zio.aws.connect.model.SearchQueuesResponse.wrap)
        .provideEnvironment(r)
    def disassociateSecurityKey(
        request: DisassociateSecurityKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest,
      DisassociateSecurityKeyResponse
    ]("disassociateSecurityKey", api.disassociateSecurityKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startContactStreaming(request: StartContactStreamingRequest): IO[
      AwsError,
      zio.aws.connect.model.StartContactStreamingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.StartContactStreamingRequest,
      StartContactStreamingResponse
    ]("startContactStreaming", api.startContactStreaming)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.StartContactStreamingResponse.wrap)
      .provideEnvironment(r)
    def updateContactAttributes(request: UpdateContactAttributesRequest): IO[
      AwsError,
      zio.aws.connect.model.UpdateContactAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest,
      UpdateContactAttributesResponse
    ]("updateContactAttributes", api.updateContactAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.UpdateContactAttributesResponse.wrap)
      .provideEnvironment(r)
    def deleteSecurityProfile(
        request: DeleteSecurityProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest,
      DeleteSecurityProfileResponse
    ]("deleteSecurityProfile", api.deleteSecurityProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createUser(
        request: CreateUserRequest
    ): IO[AwsError, zio.aws.connect.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateUserRequest,
        CreateUserResponse
      ]("createUser", api.createUser)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def createContactFlowModule(request: CreateContactFlowModuleRequest): IO[
      AwsError,
      zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest,
      CreateContactFlowModuleResponse
    ]("createContactFlowModule", api.createContactFlowModule)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateContactFlowModuleResponse.wrap)
      .provideEnvironment(r)
    def disassociateBot(request: DisassociateBotRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DisassociateBotRequest,
        DisassociateBotResponse
      ]("disassociateBot", api.disassociateBot)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.PhoneNumberSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest,
      ListPhoneNumbersResponse,
      PhoneNumberSummary
    ](
      "listPhoneNumbers",
      api.listPhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumberSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.PhoneNumberSummary.wrap(item))
      .provideEnvironment(r)
    def listPhoneNumbersPaginated(
        request: ListPhoneNumbersRequest
    ): IO[AwsError, zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest,
        ListPhoneNumbersResponse
      ]("listPhoneNumbers", api.listPhoneNumbers)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListPhoneNumbersResponse.wrap)
        .provideEnvironment(r)
    def updateUserHierarchyGroupName(
        request: UpdateUserHierarchyGroupNameRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest,
      UpdateUserHierarchyGroupNameResponse
    ]("updateUserHierarchyGroupName", api.updateUserHierarchyGroupName)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateQueueQuickConnects(
        request: DisassociateQueueQuickConnectsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest,
      DisassociateQueueQuickConnectsResponse
    ]("disassociateQueueQuickConnects", api.disassociateQueueQuickConnects)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def claimPhoneNumber(
        request: ClaimPhoneNumberRequest
    ): IO[AwsError, zio.aws.connect.model.ClaimPhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest,
        ClaimPhoneNumberResponse
      ]("claimPhoneNumber", api.claimPhoneNumber)(request.buildAwsValue())
        .map(zio.aws.connect.model.ClaimPhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def describeSecurityProfile(request: DescribeSecurityProfileRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest,
      DescribeSecurityProfileResponse
    ]("describeSecurityProfile", api.describeSecurityProfile)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeSecurityProfileResponse.wrap)
      .provideEnvironment(r)
    def updatePhoneNumber(
        request: UpdatePhoneNumberRequest
    ): IO[AwsError, zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest,
        UpdatePhoneNumberResponse
      ]("updatePhoneNumber", api.updatePhoneNumber)(request.buildAwsValue())
        .map(zio.aws.connect.model.UpdatePhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def listContactReferences(request: ListContactReferencesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.ReferenceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListContactReferencesRequest,
      ListContactReferencesResponse,
      ReferenceSummary
    ](
      "listContactReferences",
      api.listContactReferences,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.referenceSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.ReferenceSummary.wrap(item))
      .provideEnvironment(r)
    def listContactReferencesPaginated(
        request: ListContactReferencesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListContactReferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListContactReferencesRequest,
      ListContactReferencesResponse
    ]("listContactReferences", api.listContactReferences)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListContactReferencesResponse.wrap)
      .provideEnvironment(r)
    def updateQueueHoursOfOperation(
        request: UpdateQueueHoursOfOperationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest,
      UpdateQueueHoursOfOperationResponse
    ]("updateQueueHoursOfOperation", api.updateQueueHoursOfOperation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateInstanceStorageConfig(
        request: UpdateInstanceStorageConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest,
      UpdateInstanceStorageConfigResponse
    ]("updateInstanceStorageConfig", api.updateInstanceStorageConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPrompts(
        request: ListPromptsRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.PromptSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListPromptsRequest,
        ListPromptsResponse,
        PromptSummary
      ](
        "listPrompts",
        api.listPrompts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.promptSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.PromptSummary.wrap(item))
        .provideEnvironment(r)
    def listPromptsPaginated(
        request: ListPromptsRequest
    ): IO[AwsError, zio.aws.connect.model.ListPromptsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListPromptsRequest,
        ListPromptsResponse
      ]("listPrompts", api.listPrompts)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListPromptsResponse.wrap)
        .provideEnvironment(r)
    def deleteHoursOfOperation(
        request: DeleteHoursOfOperationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest,
      DeleteHoursOfOperationResponse
    ]("deleteHoursOfOperation", api.deleteHoursOfOperation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTrafficDistributionGroups(
        request: ListTrafficDistributionGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest,
      ListTrafficDistributionGroupsResponse,
      TrafficDistributionGroupSummary
    ](
      "listTrafficDistributionGroups",
      api.listTrafficDistributionGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.trafficDistributionGroupSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.connect.model.TrafficDistributionGroupSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listTrafficDistributionGroupsPaginated(
        request: ListTrafficDistributionGroupsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest,
      ListTrafficDistributionGroupsResponse
    ]("listTrafficDistributionGroups", api.listTrafficDistributionGroups)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListTrafficDistributionGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteUseCase(request: DeleteUseCaseRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest,
        DeleteUseCaseResponse
      ]("deleteUseCase", api.deleteUseCase)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listTaskTemplates(request: ListTaskTemplatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest,
      ListTaskTemplatesResponse,
      TaskTemplateMetadata
    ](
      "listTaskTemplates",
      api.listTaskTemplates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.taskTemplates().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.TaskTemplateMetadata.wrap(item))
      .provideEnvironment(r)
    def listTaskTemplatesPaginated(
        request: ListTaskTemplatesRequest
    ): IO[AwsError, zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest,
        ListTaskTemplatesResponse
      ]("listTaskTemplates", api.listTaskTemplates)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListTaskTemplatesResponse.wrap)
        .provideEnvironment(r)
    def associateRoutingProfileQueues(
        request: AssociateRoutingProfileQueuesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest,
      AssociateRoutingProfileQueuesResponse
    ]("associateRoutingProfileQueues", api.associateRoutingProfileQueues)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def searchAvailablePhoneNumbers(
        request: SearchAvailablePhoneNumbersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.AvailableNumberSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse,
      AvailableNumberSummary
    ](
      "searchAvailablePhoneNumbers",
      api.searchAvailablePhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.availableNumbersList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.AvailableNumberSummary.wrap(item))
      .provideEnvironment(r)
    def searchAvailablePhoneNumbersPaginated(
        request: SearchAvailablePhoneNumbersRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse
    ]("searchAvailablePhoneNumbers", api.searchAvailablePhoneNumbers)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeContact(
        request: DescribeContactRequest
    ): IO[AwsError, zio.aws.connect.model.DescribeContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DescribeContactRequest,
        DescribeContactResponse
      ]("describeContact", api.describeContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.DescribeContactResponse.wrap)
        .provideEnvironment(r)
    def searchSecurityProfiles(
        request: SearchSecurityProfilesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly,
      zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest,
      SearchSecurityProfilesResponse,
      SecurityProfileSearchSummary
    ](
      "searchSecurityProfiles",
      api.searchSecurityProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityProfiles().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.connect.model.SearchSecurityProfilesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.connect.model.SecurityProfileSearchSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchSecurityProfilesPaginated(
        request: SearchSecurityProfilesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest,
      SearchSecurityProfilesResponse
    ]("searchSecurityProfiles", api.searchSecurityProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.SearchSecurityProfilesResponse.wrap)
      .provideEnvironment(r)
    def updateUserPhoneConfig(
        request: UpdateUserPhoneConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest,
      UpdateUserPhoneConfigResponse
    ]("updateUserPhoneConfig", api.updateUserPhoneConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRoutingProfileQueues(
        request: ListRoutingProfileQueuesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest,
      ListRoutingProfileQueuesResponse,
      RoutingProfileQueueConfigSummary
    ](
      "listRoutingProfileQueues",
      api.listRoutingProfileQueues,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.routingProfileQueueConfigSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.connect.model.RoutingProfileQueueConfigSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRoutingProfileQueuesPaginated(
        request: ListRoutingProfileQueuesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest,
      ListRoutingProfileQueuesResponse
    ]("listRoutingProfileQueues", api.listRoutingProfileQueues)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListRoutingProfileQueuesResponse.wrap)
      .provideEnvironment(r)
    def updateQueueStatus(
        request: UpdateQueueStatusRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest,
      UpdateQueueStatusResponse
    ]("updateQueueStatus", api.updateQueueStatus)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def replicateInstance(
        request: ReplicateInstanceRequest
    ): IO[AwsError, zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest,
        ReplicateInstanceResponse
      ]("replicateInstance", api.replicateInstance)(request.buildAwsValue())
        .map(zio.aws.connect.model.ReplicateInstanceResponse.wrap)
        .provideEnvironment(r)
    def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.SecurityProfileSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest,
      ListSecurityProfilesResponse,
      SecurityProfileSummary
    ](
      "listSecurityProfiles",
      api.listSecurityProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityProfileSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.SecurityProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listSecurityProfilesPaginated(
        request: ListSecurityProfilesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest,
      ListSecurityProfilesResponse
    ]("listSecurityProfiles", api.listSecurityProfiles)(request.buildAwsValue())
      .map(zio.aws.connect.model.ListSecurityProfilesResponse.wrap)
      .provideEnvironment(r)
    def listSecurityProfilePermissions(
        request: ListSecurityProfilePermissionsRequest
    ): ZStream[Any, AwsError, SecurityProfilePermission] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest,
        ListSecurityProfilePermissionsResponse,
        java.lang.String
      ](
        "listSecurityProfilePermissions",
        api.listSecurityProfilePermissions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.permissions().asScala)
      )(request.buildAwsValue())
        .map(item =>
          zio.aws.connect.model.primitives.SecurityProfilePermission(item)
        )
        .provideEnvironment(r)
    def listSecurityProfilePermissionsPaginated(
        request: ListSecurityProfilePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest,
      ListSecurityProfilePermissionsResponse
    ]("listSecurityProfilePermissions", api.listSecurityProfilePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListSecurityProfilePermissionsResponse.wrap)
      .provideEnvironment(r)
    def deleteIntegrationAssociation(
        request: DeleteIntegrationAssociationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest,
      DeleteIntegrationAssociationResponse
    ]("deleteIntegrationAssociation", api.deleteIntegrationAssociation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def stopContactStreaming(request: StopContactStreamingRequest): IO[
      AwsError,
      zio.aws.connect.model.StopContactStreamingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.StopContactStreamingRequest,
      StopContactStreamingResponse
    ]("stopContactStreaming", api.stopContactStreaming)(request.buildAwsValue())
      .map(zio.aws.connect.model.StopContactStreamingResponse.wrap)
      .provideEnvironment(r)
    def listBots(
        request: ListBotsRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.LexBotConfig.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListBotsRequest,
        ListBotsResponse,
        LexBotConfig
      ](
        "listBots",
        api.listBots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.lexBots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.LexBotConfig.wrap(item))
        .provideEnvironment(r)
    def listBotsPaginated(
        request: ListBotsRequest
    ): IO[AwsError, zio.aws.connect.model.ListBotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListBotsRequest,
        ListBotsResponse
      ]("listBots", api.listBots)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListBotsResponse.wrap)
        .provideEnvironment(r)
    def deleteQuickConnect(
        request: DeleteQuickConnectRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest,
      DeleteQuickConnectResponse
    ]("deleteQuickConnect", api.deleteQuickConnect)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listSecurityKeys(
        request: ListSecurityKeysRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.SecurityKey.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest,
        ListSecurityKeysResponse,
        SecurityKey
      ](
        "listSecurityKeys",
        api.listSecurityKeys,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.securityKeys().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.SecurityKey.wrap(item))
        .provideEnvironment(r)
    def listSecurityKeysPaginated(
        request: ListSecurityKeysRequest
    ): IO[AwsError, zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest,
        ListSecurityKeysResponse
      ]("listSecurityKeys", api.listSecurityKeys)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListSecurityKeysResponse.wrap)
        .provideEnvironment(r)
    def stopContact(
        request: StopContactRequest
    ): IO[AwsError, zio.aws.connect.model.StopContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.StopContactRequest,
        StopContactResponse
      ]("stopContact", api.stopContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.StopContactResponse.wrap)
        .provideEnvironment(r)
    def createQueue(
        request: CreateQueueRequest
    ): IO[AwsError, zio.aws.connect.model.CreateQueueResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateQueueRequest,
        CreateQueueResponse
      ]("createQueue", api.createQueue)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateQueueResponse.wrap)
        .provideEnvironment(r)
    def updateQueueMaxContacts(
        request: UpdateQueueMaxContactsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest,
      UpdateQueueMaxContactsResponse
    ]("updateQueueMaxContacts", api.updateQueueMaxContacts)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteTrafficDistributionGroup(
        request: DeleteTrafficDistributionGroupRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest,
      DeleteTrafficDistributionGroupResponse
    ]("deleteTrafficDistributionGroup", api.deleteTrafficDistributionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceStorageConfig(
        request: DescribeInstanceStorageConfigRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest,
      DescribeInstanceStorageConfigResponse
    ]("describeInstanceStorageConfig", api.describeInstanceStorageConfig)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeInstanceStorageConfigResponse.wrap)
      .provideEnvironment(r)
    def describeAgentStatus(request: DescribeAgentStatusRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest,
      DescribeAgentStatusResponse
    ]("describeAgentStatus", api.describeAgentStatus)(request.buildAwsValue())
      .map(zio.aws.connect.model.DescribeAgentStatusResponse.wrap)
      .provideEnvironment(r)
    def associateApprovedOrigin(
        request: AssociateApprovedOriginRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest,
      AssociateApprovedOriginResponse
    ]("associateApprovedOrigin", api.associateApprovedOrigin)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def transferContact(
        request: TransferContactRequest
    ): IO[AwsError, zio.aws.connect.model.TransferContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.TransferContactRequest,
        TransferContactResponse
      ]("transferContact", api.transferContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.TransferContactResponse.wrap)
        .provideEnvironment(r)
    def listLexBots(
        request: ListLexBotsRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListLexBotsRequest,
        ListLexBotsResponse,
        LexBot
      ](
        "listLexBots",
        api.listLexBots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.lexBots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.LexBot.wrap(item))
        .provideEnvironment(r)
    def listLexBotsPaginated(
        request: ListLexBotsRequest
    ): IO[AwsError, zio.aws.connect.model.ListLexBotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListLexBotsRequest,
        ListLexBotsResponse
      ]("listLexBots", api.listLexBots)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListLexBotsResponse.wrap)
        .provideEnvironment(r)
    def getCurrentMetricData(
        request: GetCurrentMetricDataRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly,
      zio.aws.connect.model.CurrentMetricResult.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest,
      GetCurrentMetricDataResponse,
      CurrentMetricResult
    ](
      "getCurrentMetricData",
      api.getCurrentMetricData,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metricResults().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.connect.model.GetCurrentMetricDataResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.connect.model.CurrentMetricResult.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getCurrentMetricDataPaginated(request: GetCurrentMetricDataRequest): IO[
      AwsError,
      zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest,
      GetCurrentMetricDataResponse
    ]("getCurrentMetricData", api.getCurrentMetricData)(request.buildAwsValue())
      .map(zio.aws.connect.model.GetCurrentMetricDataResponse.wrap)
      .provideEnvironment(r)
    def stopContactRecording(request: StopContactRecordingRequest): IO[
      AwsError,
      zio.aws.connect.model.StopContactRecordingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.StopContactRecordingRequest,
      StopContactRecordingResponse
    ]("stopContactRecording", api.stopContactRecording)(request.buildAwsValue())
      .map(zio.aws.connect.model.StopContactRecordingResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceAttribute(
        request: DescribeInstanceAttributeRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest,
      DescribeInstanceAttributeResponse
    ]("describeInstanceAttribute", api.describeInstanceAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeInstanceAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeUser(
        request: DescribeUserRequest
    ): IO[AwsError, zio.aws.connect.model.DescribeUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DescribeUserRequest,
        DescribeUserResponse
      ]("describeUser", api.describeUser)(request.buildAwsValue())
        .map(zio.aws.connect.model.DescribeUserResponse.wrap)
        .provideEnvironment(r)
    def updateContactFlowMetadata(
        request: UpdateContactFlowMetadataRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest,
      UpdateContactFlowMetadataResponse
    ]("updateContactFlowMetadata", api.updateContactFlowMetadata)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.connect.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.connect.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeUserHierarchyGroup(
        request: DescribeUserHierarchyGroupRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest,
      DescribeUserHierarchyGroupResponse
    ]("describeUserHierarchyGroup", api.describeUserHierarchyGroup)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeUserHierarchyGroupResponse.wrap)
      .provideEnvironment(r)
    def createTaskTemplate(
        request: CreateTaskTemplateRequest
    ): IO[AwsError, zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest,
        CreateTaskTemplateResponse
      ]("createTaskTemplate", api.createTaskTemplate)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateTaskTemplateResponse.wrap)
        .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listUseCases(
        request: ListUseCasesRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.UseCase.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListUseCasesRequest,
        ListUseCasesResponse,
        UseCase
      ](
        "listUseCases",
        api.listUseCases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.useCaseSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.UseCase.wrap(item))
        .provideEnvironment(r)
    def listUseCasesPaginated(
        request: ListUseCasesRequest
    ): IO[AwsError, zio.aws.connect.model.ListUseCasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.ListUseCasesRequest,
        ListUseCasesResponse
      ]("listUseCases", api.listUseCases)(request.buildAwsValue())
        .map(zio.aws.connect.model.ListUseCasesResponse.wrap)
        .provideEnvironment(r)
    def suspendContactRecording(request: SuspendContactRecordingRequest): IO[
      AwsError,
      zio.aws.connect.model.SuspendContactRecordingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.SuspendContactRecordingRequest,
      SuspendContactRecordingResponse
    ]("suspendContactRecording", api.suspendContactRecording)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.SuspendContactRecordingResponse.wrap)
      .provideEnvironment(r)
    def describeContactFlow(request: DescribeContactFlowRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest,
      DescribeContactFlowResponse
    ]("describeContactFlow", api.describeContactFlow)(request.buildAwsValue())
      .map(zio.aws.connect.model.DescribeContactFlowResponse.wrap)
      .provideEnvironment(r)
    def startContactRecording(request: StartContactRecordingRequest): IO[
      AwsError,
      zio.aws.connect.model.StartContactRecordingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.StartContactRecordingRequest,
      StartContactRecordingResponse
    ]("startContactRecording", api.startContactRecording)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.StartContactRecordingResponse.wrap)
      .provideEnvironment(r)
    def associateInstanceStorageConfig(
        request: AssociateInstanceStorageConfigRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest,
      AssociateInstanceStorageConfigResponse
    ]("associateInstanceStorageConfig", api.associateInstanceStorageConfig)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.AssociateInstanceStorageConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.DeleteUserRequest,
        DeleteUserResponse
      ]("deleteUser", api.deleteUser)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listIntegrationAssociations(
        request: ListIntegrationAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest,
      ListIntegrationAssociationsResponse,
      IntegrationAssociationSummary
    ](
      "listIntegrationAssociations",
      api.listIntegrationAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.integrationAssociationSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.connect.model.IntegrationAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listIntegrationAssociationsPaginated(
        request: ListIntegrationAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest,
      ListIntegrationAssociationsResponse
    ]("listIntegrationAssociations", api.listIntegrationAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListIntegrationAssociationsResponse.wrap)
      .provideEnvironment(r)
    def searchVocabularies(request: SearchVocabulariesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.VocabularySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest,
      SearchVocabulariesResponse,
      VocabularySummary
    ](
      "searchVocabularies",
      api.searchVocabularies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vocabularySummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.VocabularySummary.wrap(item))
      .provideEnvironment(r)
    def searchVocabulariesPaginated(
        request: SearchVocabulariesRequest
    ): IO[AwsError, zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest,
        SearchVocabulariesResponse
      ]("searchVocabularies", api.searchVocabularies)(request.buildAwsValue())
        .map(zio.aws.connect.model.SearchVocabulariesResponse.wrap)
        .provideEnvironment(r)
    def createIntegrationAssociation(
        request: CreateIntegrationAssociationRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest,
      CreateIntegrationAssociationResponse
    ]("createIntegrationAssociation", api.createIntegrationAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateIntegrationAssociationResponse.wrap)
      .provideEnvironment(r)
    def disassociateLexBot(
        request: DisassociateLexBotRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest,
      DisassociateLexBotResponse
    ]("disassociateLexBot", api.disassociateLexBot)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listInstanceAttributes(
        request: ListInstanceAttributesRequest
    ): ZStream[Any, AwsError, zio.aws.connect.model.Attribute.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest,
        ListInstanceAttributesResponse,
        Attribute
      ](
        "listInstanceAttributes",
        api.listInstanceAttributes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.attributes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.connect.model.Attribute.wrap(item))
        .provideEnvironment(r)
    def listInstanceAttributesPaginated(
        request: ListInstanceAttributesRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest,
      ListInstanceAttributesResponse
    ]("listInstanceAttributes", api.listInstanceAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListInstanceAttributesResponse.wrap)
      .provideEnvironment(r)
    def listHoursOfOperations(request: ListHoursOfOperationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest,
      ListHoursOfOperationsResponse,
      HoursOfOperationSummary
    ](
      "listHoursOfOperations",
      api.listHoursOfOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hoursOfOperationSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.HoursOfOperationSummary.wrap(item))
      .provideEnvironment(r)
    def listHoursOfOperationsPaginated(
        request: ListHoursOfOperationsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest,
      ListHoursOfOperationsResponse
    ]("listHoursOfOperations", api.listHoursOfOperations)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListHoursOfOperationsResponse.wrap)
      .provideEnvironment(r)
    def updateContactFlowName(
        request: UpdateContactFlowNameRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest,
      UpdateContactFlowNameResponse
    ]("updateContactFlowName", api.updateContactFlowName)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createInstance(
        request: CreateInstanceRequest
    ): IO[AwsError, zio.aws.connect.model.CreateInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateInstanceRequest,
        CreateInstanceResponse
      ]("createInstance", api.createInstance)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateInstanceResponse.wrap)
        .provideEnvironment(r)
    def listUserHierarchyGroups(
        request: ListUserHierarchyGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest,
      ListUserHierarchyGroupsResponse,
      HierarchyGroupSummary
    ](
      "listUserHierarchyGroups",
      api.listUserHierarchyGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.userHierarchyGroupSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.HierarchyGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listUserHierarchyGroupsPaginated(
        request: ListUserHierarchyGroupsRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest,
      ListUserHierarchyGroupsResponse
    ]("listUserHierarchyGroups", api.listUserHierarchyGroups)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.ListUserHierarchyGroupsResponse.wrap)
      .provideEnvironment(r)
    def disassociateInstanceStorageConfig(
        request: DisassociateInstanceStorageConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest,
      DisassociateInstanceStorageConfigResponse
    ](
      "disassociateInstanceStorageConfig",
      api.disassociateInstanceStorageConfig
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateSecurityProfile(
        request: UpdateSecurityProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest,
      UpdateSecurityProfileResponse
    ]("updateSecurityProfile", api.updateSecurityProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeContactFlowModule(
        request: DescribeContactFlowModuleRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest,
      DescribeContactFlowModuleResponse
    ]("describeContactFlowModule", api.describeContactFlowModule)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeContactFlowModuleResponse.wrap)
      .provideEnvironment(r)
    def startOutboundVoiceContact(
        request: StartOutboundVoiceContactRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest,
      StartOutboundVoiceContactResponse
    ]("startOutboundVoiceContact", api.startOutboundVoiceContact)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.StartOutboundVoiceContactResponse.wrap)
      .provideEnvironment(r)
    def updateInstanceAttribute(
        request: UpdateInstanceAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest,
      UpdateInstanceAttributeResponse
    ]("updateInstanceAttribute", api.updateInstanceAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateUserHierarchyStructure(
        request: UpdateUserHierarchyStructureRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest,
      UpdateUserHierarchyStructureResponse
    ]("updateUserHierarchyStructure", api.updateUserHierarchyStructure)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeQuickConnect(request: DescribeQuickConnectRequest): IO[
      AwsError,
      zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest,
      DescribeQuickConnectResponse
    ]("describeQuickConnect", api.describeQuickConnect)(request.buildAwsValue())
      .map(zio.aws.connect.model.DescribeQuickConnectResponse.wrap)
      .provideEnvironment(r)
    def listApprovedOrigins(
        request: ListApprovedOriginsRequest
    ): ZStream[Any, AwsError, Origin] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest,
      ListApprovedOriginsResponse,
      java.lang.String
    ](
      "listApprovedOrigins",
      api.listApprovedOrigins,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.origins().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.connect.model.primitives.Origin(item))
      .provideEnvironment(r)
    def listApprovedOriginsPaginated(request: ListApprovedOriginsRequest): IO[
      AwsError,
      zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest,
      ListApprovedOriginsResponse
    ]("listApprovedOrigins", api.listApprovedOrigins)(request.buildAwsValue())
      .map(zio.aws.connect.model.ListApprovedOriginsResponse.wrap)
      .provideEnvironment(r)
    def updateUserRoutingProfile(
        request: UpdateUserRoutingProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest,
      UpdateUserRoutingProfileResponse
    ]("updateUserRoutingProfile", api.updateUserRoutingProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createQuickConnect(
        request: CreateQuickConnectRequest
    ): IO[AwsError, zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest,
        CreateQuickConnectResponse
      ]("createQuickConnect", api.createQuickConnect)(request.buildAwsValue())
        .map(zio.aws.connect.model.CreateQuickConnectResponse.wrap)
        .provideEnvironment(r)
    def putUserStatus(
        request: PutUserStatusRequest
    ): IO[AwsError, zio.aws.connect.model.PutUserStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.PutUserStatusRequest,
        PutUserStatusResponse
      ]("putUserStatus", api.putUserStatus)(request.buildAwsValue())
        .map(zio.aws.connect.model.PutUserStatusResponse.wrap)
        .provideEnvironment(r)
    def updateQuickConnectName(
        request: UpdateQuickConnectNameRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest,
      UpdateQuickConnectNameResponse
    ]("updateQuickConnectName", api.updateQuickConnectName)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createHoursOfOperation(request: CreateHoursOfOperationRequest): IO[
      AwsError,
      zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest,
      CreateHoursOfOperationResponse
    ]("createHoursOfOperation", api.createHoursOfOperation)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateHoursOfOperationResponse.wrap)
      .provideEnvironment(r)
    def createUserHierarchyGroup(request: CreateUserHierarchyGroupRequest): IO[
      AwsError,
      zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest,
      CreateUserHierarchyGroupResponse
    ]("createUserHierarchyGroup", api.createUserHierarchyGroup)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.CreateUserHierarchyGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteUserHierarchyGroup(
        request: DeleteUserHierarchyGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest,
      DeleteUserHierarchyGroupResponse
    ]("deleteUserHierarchyGroup", api.deleteUserHierarchyGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def associateLambdaFunction(
        request: AssociateLambdaFunctionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest,
      AssociateLambdaFunctionResponse
    ]("associateLambdaFunction", api.associateLambdaFunction)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateUserHierarchy(
        request: UpdateUserHierarchyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest,
      UpdateUserHierarchyResponse
    ]("updateUserHierarchy", api.updateUserHierarchy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startTaskContact(
        request: StartTaskContactRequest
    ): IO[AwsError, zio.aws.connect.model.StartTaskContactResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.connect.model.StartTaskContactRequest,
        StartTaskContactResponse
      ]("startTaskContact", api.startTaskContact)(request.buildAwsValue())
        .map(zio.aws.connect.model.StartTaskContactResponse.wrap)
        .provideEnvironment(r)
    def describeUserHierarchyStructure(
        request: DescribeUserHierarchyStructureRequest
    ): IO[
      AwsError,
      zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest,
      DescribeUserHierarchyStructureResponse
    ]("describeUserHierarchyStructure", api.describeUserHierarchyStructure)(
      request.buildAwsValue()
    ).map(zio.aws.connect.model.DescribeUserHierarchyStructureResponse.wrap)
      .provideEnvironment(r)
    def disassociateApprovedOrigin(
        request: DisassociateApprovedOriginRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest,
      DisassociateApprovedOriginResponse
    ]("disassociateApprovedOrigin", api.disassociateApprovedOrigin)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def updateContact(request: UpdateContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContact(request))
  def listContactFlowModules(request: ListContactFlowModulesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContactFlowModules(request))
  def listContactFlowModulesPaginated(
      request: ListContactFlowModulesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactFlowModulesPaginated(request))
  def deleteTaskTemplate(request: DeleteTaskTemplateRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DeleteTaskTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTaskTemplate(request))
  def listAgentStatuses(request: ListAgentStatusesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.AgentStatusSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAgentStatuses(request))
  def listAgentStatusesPaginated(request: ListAgentStatusesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAgentStatusesPaginated(request))
  def createUseCase(request: CreateUseCaseRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateUseCaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUseCase(request))
  def updateRoutingProfileDefaultOutboundQueue(
      request: UpdateRoutingProfileDefaultOutboundQueueRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRoutingProfileDefaultOutboundQueue(request))
  def listUsers(request: ListUsersRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UserSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(request: ListUsersRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def createRoutingProfile(request: CreateRoutingProfileRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoutingProfile(request))
  def listRoutingProfiles(request: ListRoutingProfilesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.RoutingProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutingProfiles(request))
  def listRoutingProfilesPaginated(request: ListRoutingProfilesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutingProfilesPaginated(request))
  def updateTaskTemplate(request: UpdateTaskTemplateRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTaskTemplate(request))
  def deleteContactFlow(
      request: DeleteContactFlowRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteContactFlow(request))
  def getTrafficDistribution(request: GetTrafficDistributionRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrafficDistribution(request))
  def disassociateRoutingProfileQueues(
      request: DisassociateRoutingProfileQueuesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateRoutingProfileQueues(request))
  def disassociateLambdaFunction(
      request: DisassociateLambdaFunctionRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateLambdaFunction(request))
  def describePhoneNumber(request: DescribePhoneNumberRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePhoneNumber(request))
  def describeVocabulary(request: DescribeVocabularyRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVocabulary(request))
  def searchUsers(
      request: SearchUsersRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchUsersResponse.ReadOnly,
    zio.aws.connect.model.UserSearchSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.searchUsers(request))
  def searchUsersPaginated(request: SearchUsersRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchUsersPaginated(request))
  def createAgentStatus(request: CreateAgentStatusRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAgentStatus(request))
  def deleteVocabulary(request: DeleteVocabularyRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVocabulary(request))
  def listInstanceStorageConfigs(
      request: ListInstanceStorageConfigsRequest
  ): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.InstanceStorageConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceStorageConfigs(request))
  def listInstanceStorageConfigsPaginated(
      request: ListInstanceStorageConfigsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceStorageConfigsPaginated(request))
  def updateHoursOfOperation(
      request: UpdateHoursOfOperationRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateHoursOfOperation(request))
  def startChatContact(request: StartChatContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StartChatContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startChatContact(request))
  def updateRoutingProfileQueues(
      request: UpdateRoutingProfileQueuesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRoutingProfileQueues(request))
  def describeInstance(request: DescribeInstanceRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstance(request))
  def getContactAttributes(request: GetContactAttributesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetContactAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContactAttributes(request))
  def createSecurityProfile(request: CreateSecurityProfileRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityProfile(request))
  def disassociatePhoneNumberContactFlow(
      request: DisassociatePhoneNumberContactFlowRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociatePhoneNumberContactFlow(request))
  def updateQueueOutboundCallerConfig(
      request: UpdateQueueOutboundCallerConfigRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQueueOutboundCallerConfig(request))
  def listPhoneNumbersV2(request: ListPhoneNumbersV2Request): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumbersV2(request))
  def listPhoneNumbersV2Paginated(request: ListPhoneNumbersV2Request): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumbersV2Paginated(request))
  def createTrafficDistributionGroup(
      request: CreateTrafficDistributionGroupRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficDistributionGroup(request))
  def deleteContactFlowModule(request: DeleteContactFlowModuleRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DeleteContactFlowModuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContactFlowModule(request))
  def getTaskTemplate(request: GetTaskTemplateRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetTaskTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTaskTemplate(request))
  def createContactFlow(request: CreateContactFlowRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateContactFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContactFlow(request))
  def listInstances(request: ListInstancesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.InstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstances(request))
  def listInstancesPaginated(request: ListInstancesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstancesPaginated(request))
  def updateContactFlowContent(
      request: UpdateContactFlowContentRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateContactFlowContent(request))
  def associateDefaultVocabulary(
      request: AssociateDefaultVocabularyRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.AssociateDefaultVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDefaultVocabulary(request))
  def associateLexBot(
      request: AssociateLexBotRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateLexBot(request))
  def associatePhoneNumberContactFlow(
      request: AssociatePhoneNumberContactFlowRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associatePhoneNumberContactFlow(request))
  def describeHoursOfOperation(request: DescribeHoursOfOperationRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHoursOfOperation(request))
  def describeRoutingProfile(request: DescribeRoutingProfileRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRoutingProfile(request))
  def updateRoutingProfileName(
      request: UpdateRoutingProfileNameRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRoutingProfileName(request))
  def listDefaultVocabularies(request: ListDefaultVocabulariesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DefaultVocabulary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDefaultVocabularies(request))
  def listDefaultVocabulariesPaginated(
      request: ListDefaultVocabulariesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDefaultVocabulariesPaginated(request))
  def updateContactFlowModuleContent(
      request: UpdateContactFlowModuleContentRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateContactFlowModuleContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactFlowModuleContent(request))
  def releasePhoneNumber(
      request: ReleasePhoneNumberRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.releasePhoneNumber(request))
  def updateQuickConnectConfig(
      request: UpdateQuickConnectConfigRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQuickConnectConfig(request))
  def updateUserIdentityInfo(
      request: UpdateUserIdentityInfoRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserIdentityInfo(request))
  def updateUserSecurityProfiles(
      request: UpdateUserSecurityProfilesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserSecurityProfiles(request))
  def listContactFlows(request: ListContactFlowsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ContactFlowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContactFlows(request))
  def listContactFlowsPaginated(request: ListContactFlowsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListContactFlowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactFlowsPaginated(request))
  def listQueues(request: ListQueuesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.QueueSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueues(request))
  def listQueuesPaginated(request: ListQueuesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueuesPaginated(request))
  def updateRoutingProfileConcurrency(
      request: UpdateRoutingProfileConcurrencyRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRoutingProfileConcurrency(request))
  def associateBot(
      request: AssociateBotRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateBot(request))
  def updateContactFlowModuleMetadata(
      request: UpdateContactFlowModuleMetadataRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactFlowModuleMetadata(request))
  def describeTrafficDistributionGroup(
      request: DescribeTrafficDistributionGroupRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrafficDistributionGroup(request))
  def resumeContactRecording(request: ResumeContactRecordingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ResumeContactRecordingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resumeContactRecording(request))
  def getFederationToken(request: GetFederationTokenRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetFederationTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFederationToken(request))
  def updateContactSchedule(request: UpdateContactScheduleRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateContactScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactSchedule(request))
  def deleteInstance(
      request: DeleteInstanceRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteInstance(request))
  def searchRoutingProfiles(
      request: SearchRoutingProfilesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly,
    zio.aws.connect.model.RoutingProfile.ReadOnly
  ]] = ZIO.serviceWithZIO(_.searchRoutingProfiles(request))
  def searchRoutingProfilesPaginated(
      request: SearchRoutingProfilesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchRoutingProfilesPaginated(request))
  def updateTrafficDistribution(request: UpdateTrafficDistributionRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateTrafficDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrafficDistribution(request))
  def getMetricData(request: GetMetricDataRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.HistoricalMetricResult.ReadOnly
  ] = ZStream.serviceWithStream(_.getMetricData(request))
  def getMetricDataPaginated(request: GetMetricDataRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricDataPaginated(request))
  def listQuickConnects(request: ListQuickConnectsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.QuickConnectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQuickConnects(request))
  def listQuickConnectsPaginated(request: ListQuickConnectsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQuickConnectsPaginated(request))
  def getCurrentUserData(request: GetCurrentUserDataRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UserData.ReadOnly
  ] = ZStream.serviceWithStream(_.getCurrentUserData(request))
  def getCurrentUserDataPaginated(request: GetCurrentUserDataRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCurrentUserDataPaginated(request))
  def updateQueueName(
      request: UpdateQueueNameRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQueueName(request))
  def listQueueQuickConnects(request: ListQueueQuickConnectsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.QuickConnectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueueQuickConnects(request))
  def listQueueQuickConnectsPaginated(
      request: ListQueueQuickConnectsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueueQuickConnectsPaginated(request))
  def associateSecurityKey(request: AssociateSecurityKeyRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSecurityKey(request))
  def listLambdaFunctions(
      request: ListLambdaFunctionsRequest
  ): ZStream[zio.aws.connect.Connect, AwsError, FunctionArn] =
    ZStream.serviceWithStream(_.listLambdaFunctions(request))
  def listLambdaFunctionsPaginated(request: ListLambdaFunctionsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLambdaFunctionsPaginated(request))
  def associateQueueQuickConnects(
      request: AssociateQueueQuickConnectsRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateQueueQuickConnects(request))
  def updateAgentStatus(
      request: UpdateAgentStatusRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAgentStatus(request))
  def describeQueue(request: DescribeQueueRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeQueue(request))
  def createVocabulary(request: CreateVocabularyRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVocabulary(request))
  def searchQueues(
      request: SearchQueuesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchQueuesResponse.ReadOnly,
    zio.aws.connect.model.Queue.ReadOnly
  ]] = ZIO.serviceWithZIO(_.searchQueues(request))
  def searchQueuesPaginated(request: SearchQueuesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchQueuesPaginated(request))
  def disassociateSecurityKey(
      request: DisassociateSecurityKeyRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateSecurityKey(request))
  def startContactStreaming(request: StartContactStreamingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StartContactStreamingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startContactStreaming(request))
  def updateContactAttributes(request: UpdateContactAttributesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdateContactAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactAttributes(request))
  def deleteSecurityProfile(
      request: DeleteSecurityProfileRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSecurityProfile(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def createContactFlowModule(request: CreateContactFlowModuleRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContactFlowModule(request))
  def disassociateBot(
      request: DisassociateBotRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateBot(request))
  def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.PhoneNumberSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumbers(request))
  def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumbersPaginated(request))
  def updateUserHierarchyGroupName(
      request: UpdateUserHierarchyGroupNameRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserHierarchyGroupName(request))
  def disassociateQueueQuickConnects(
      request: DisassociateQueueQuickConnectsRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateQueueQuickConnects(request))
  def claimPhoneNumber(request: ClaimPhoneNumberRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ClaimPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.claimPhoneNumber(request))
  def describeSecurityProfile(request: DescribeSecurityProfileRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityProfile(request))
  def updatePhoneNumber(request: UpdatePhoneNumberRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePhoneNumber(request))
  def listContactReferences(request: ListContactReferencesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ReferenceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContactReferences(request))
  def listContactReferencesPaginated(
      request: ListContactReferencesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListContactReferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactReferencesPaginated(request))
  def updateQueueHoursOfOperation(
      request: UpdateQueueHoursOfOperationRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQueueHoursOfOperation(request))
  def updateInstanceStorageConfig(
      request: UpdateInstanceStorageConfigRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateInstanceStorageConfig(request))
  def listPrompts(request: ListPromptsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.PromptSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPrompts(request))
  def listPromptsPaginated(request: ListPromptsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListPromptsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPromptsPaginated(request))
  def deleteHoursOfOperation(
      request: DeleteHoursOfOperationRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteHoursOfOperation(request))
  def listTrafficDistributionGroups(
      request: ListTrafficDistributionGroupsRequest
  ): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTrafficDistributionGroups(request))
  def listTrafficDistributionGroupsPaginated(
      request: ListTrafficDistributionGroupsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficDistributionGroupsPaginated(request))
  def deleteUseCase(
      request: DeleteUseCaseRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUseCase(request))
  def listTaskTemplates(request: ListTaskTemplatesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.TaskTemplateMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listTaskTemplates(request))
  def listTaskTemplatesPaginated(request: ListTaskTemplatesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTaskTemplatesPaginated(request))
  def associateRoutingProfileQueues(
      request: AssociateRoutingProfileQueuesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateRoutingProfileQueues(request))
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.AvailableNumberSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchAvailablePhoneNumbers(request))
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchAvailablePhoneNumbersPaginated(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def describeContact(request: DescribeContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContact(request))
  def searchSecurityProfiles(
      request: SearchSecurityProfilesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly,
    zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.searchSecurityProfiles(request))
  def searchSecurityProfilesPaginated(
      request: SearchSecurityProfilesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSecurityProfilesPaginated(request))
  def updateUserPhoneConfig(
      request: UpdateUserPhoneConfigRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserPhoneConfig(request))
  def listRoutingProfileQueues(
      request: ListRoutingProfileQueuesRequest
  ): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutingProfileQueues(request))
  def listRoutingProfileQueuesPaginated(
      request: ListRoutingProfileQueuesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutingProfileQueuesPaginated(request))
  def updateQueueStatus(
      request: UpdateQueueStatusRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQueueStatus(request))
  def replicateInstance(request: ReplicateInstanceRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replicateInstance(request))
  def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SecurityProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityProfiles(request))
  def listSecurityProfilesPaginated(
      request: ListSecurityProfilesRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listSecurityProfilesPaginated(request))
  def listSecurityProfilePermissions(
      request: ListSecurityProfilePermissionsRequest
  ): ZStream[zio.aws.connect.Connect, AwsError, SecurityProfilePermission] =
    ZStream.serviceWithStream(_.listSecurityProfilePermissions(request))
  def listSecurityProfilePermissionsPaginated(
      request: ListSecurityProfilePermissionsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityProfilePermissionsPaginated(request))
  def deleteIntegrationAssociation(
      request: DeleteIntegrationAssociationRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntegrationAssociation(request))
  def stopContactStreaming(request: StopContactStreamingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StopContactStreamingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopContactStreaming(request))
  def listBots(request: ListBotsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.LexBotConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listBots(request))
  def listBotsPaginated(request: ListBotsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListBotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBotsPaginated(request))
  def deleteQuickConnect(
      request: DeleteQuickConnectRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteQuickConnect(request))
  def listSecurityKeys(request: ListSecurityKeysRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SecurityKey.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityKeys(request))
  def listSecurityKeysPaginated(request: ListSecurityKeysRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityKeysPaginated(request))
  def stopContact(request: StopContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StopContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopContact(request))
  def createQueue(request: CreateQueueRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueue(request))
  def updateQueueMaxContacts(
      request: UpdateQueueMaxContactsRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQueueMaxContacts(request))
  def deleteTrafficDistributionGroup(
      request: DeleteTrafficDistributionGroupRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficDistributionGroup(request))
  def describeInstanceStorageConfig(
      request: DescribeInstanceStorageConfigRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceStorageConfig(request))
  def describeAgentStatus(request: DescribeAgentStatusRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAgentStatus(request))
  def associateApprovedOrigin(
      request: AssociateApprovedOriginRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateApprovedOrigin(request))
  def transferContact(request: TransferContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.TransferContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.transferContact(request))
  def listLexBots(request: ListLexBotsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.LexBot.ReadOnly
  ] = ZStream.serviceWithStream(_.listLexBots(request))
  def listLexBotsPaginated(request: ListLexBotsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListLexBotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLexBotsPaginated(request))
  def getCurrentMetricData(
      request: GetCurrentMetricDataRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, StreamingOutputResult[
    Any,
    zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly,
    zio.aws.connect.model.CurrentMetricResult.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getCurrentMetricData(request))
  def getCurrentMetricDataPaginated(request: GetCurrentMetricDataRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCurrentMetricDataPaginated(request))
  def stopContactRecording(request: StopContactRecordingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StopContactRecordingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopContactRecording(request))
  def describeInstanceAttribute(request: DescribeInstanceAttributeRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceAttribute(request))
  def describeUser(request: DescribeUserRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUser(request))
  def updateContactFlowMetadata(
      request: UpdateContactFlowMetadataRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateContactFlowMetadata(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeUserHierarchyGroup(
      request: DescribeUserHierarchyGroupRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserHierarchyGroup(request))
  def createTaskTemplate(request: CreateTaskTemplateRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTaskTemplate(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listUseCases(request: ListUseCasesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.UseCase.ReadOnly
  ] = ZStream.serviceWithStream(_.listUseCases(request))
  def listUseCasesPaginated(request: ListUseCasesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListUseCasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUseCasesPaginated(request))
  def suspendContactRecording(request: SuspendContactRecordingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SuspendContactRecordingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.suspendContactRecording(request))
  def describeContactFlow(request: DescribeContactFlowRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContactFlow(request))
  def startContactRecording(request: StartContactRecordingRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StartContactRecordingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startContactRecording(request))
  def associateInstanceStorageConfig(
      request: AssociateInstanceStorageConfigRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateInstanceStorageConfig(request))
  def deleteUser(
      request: DeleteUserRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUser(request))
  def listIntegrationAssociations(
      request: ListIntegrationAssociationsRequest
  ): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listIntegrationAssociations(request))
  def listIntegrationAssociationsPaginated(
      request: ListIntegrationAssociationsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIntegrationAssociationsPaginated(request))
  def searchVocabularies(request: SearchVocabulariesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.VocabularySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchVocabularies(request))
  def searchVocabulariesPaginated(request: SearchVocabulariesRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchVocabulariesPaginated(request))
  def createIntegrationAssociation(
      request: CreateIntegrationAssociationRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIntegrationAssociation(request))
  def disassociateLexBot(
      request: DisassociateLexBotRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateLexBot(request))
  def listInstanceAttributes(request: ListInstanceAttributesRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.Attribute.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceAttributes(request))
  def listInstanceAttributesPaginated(
      request: ListInstanceAttributesRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceAttributesPaginated(request))
  def listHoursOfOperations(request: ListHoursOfOperationsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listHoursOfOperations(request))
  def listHoursOfOperationsPaginated(
      request: ListHoursOfOperationsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHoursOfOperationsPaginated(request))
  def updateContactFlowName(
      request: UpdateContactFlowNameRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateContactFlowName(request))
  def createInstance(request: CreateInstanceRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstance(request))
  def listUserHierarchyGroups(request: ListUserHierarchyGroupsRequest): ZStream[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listUserHierarchyGroups(request))
  def listUserHierarchyGroupsPaginated(
      request: ListUserHierarchyGroupsRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserHierarchyGroupsPaginated(request))
  def disassociateInstanceStorageConfig(
      request: DisassociateInstanceStorageConfigRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateInstanceStorageConfig(request))
  def updateSecurityProfile(
      request: UpdateSecurityProfileRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateSecurityProfile(request))
  def describeContactFlowModule(request: DescribeContactFlowModuleRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContactFlowModule(request))
  def startOutboundVoiceContact(request: StartOutboundVoiceContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startOutboundVoiceContact(request))
  def updateInstanceAttribute(
      request: UpdateInstanceAttributeRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateInstanceAttribute(request))
  def updateUserHierarchyStructure(
      request: UpdateUserHierarchyStructureRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserHierarchyStructure(request))
  def describeQuickConnect(request: DescribeQuickConnectRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeQuickConnect(request))
  def listApprovedOrigins(
      request: ListApprovedOriginsRequest
  ): ZStream[zio.aws.connect.Connect, AwsError, Origin] =
    ZStream.serviceWithStream(_.listApprovedOrigins(request))
  def listApprovedOriginsPaginated(request: ListApprovedOriginsRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApprovedOriginsPaginated(request))
  def updateUserRoutingProfile(
      request: UpdateUserRoutingProfileRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserRoutingProfile(request))
  def createQuickConnect(request: CreateQuickConnectRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQuickConnect(request))
  def putUserStatus(request: PutUserStatusRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.PutUserStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putUserStatus(request))
  def updateQuickConnectName(
      request: UpdateQuickConnectNameRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQuickConnectName(request))
  def createHoursOfOperation(request: CreateHoursOfOperationRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHoursOfOperation(request))
  def createUserHierarchyGroup(request: CreateUserHierarchyGroupRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserHierarchyGroup(request))
  def deleteUserHierarchyGroup(
      request: DeleteUserHierarchyGroupRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUserHierarchyGroup(request))
  def associateLambdaFunction(
      request: AssociateLambdaFunctionRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateLambdaFunction(request))
  def updateUserHierarchy(
      request: UpdateUserHierarchyRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserHierarchy(request))
  def startTaskContact(request: StartTaskContactRequest): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.StartTaskContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTaskContact(request))
  def describeUserHierarchyStructure(
      request: DescribeUserHierarchyStructureRequest
  ): ZIO[
    zio.aws.connect.Connect,
    AwsError,
    zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserHierarchyStructure(request))
  def disassociateApprovedOrigin(
      request: DisassociateApprovedOriginRequest
  ): ZIO[zio.aws.connect.Connect, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateApprovedOrigin(request))
}
