package zio.aws.connect
import zio.aws.connect.model.ListSecurityProfilesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.connect.model.primitives.{
  Origin,
  SecurityProfilePermission,
  FunctionArn
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.connect.model.{
  GetCurrentUserDataRequest,
  UpdateContactFlowContentRequest,
  DeleteUserRequest,
  GetTaskTemplateRequest,
  ListLexBotsRequest,
  ListTaskTemplatesRequest,
  StartOutboundVoiceContactRequest,
  UpdateTrafficDistributionRequest,
  ListSecurityProfilePermissionsRequest,
  UpdateQueueMaxContactsRequest,
  CreateQuickConnectRequest,
  DescribeUserRequest,
  DisassociateRoutingProfileQueuesRequest,
  AssociateRoutingProfileQueuesRequest,
  UpdateUserSecurityProfilesRequest,
  DeleteContactFlowRequest,
  ListQueuesRequest,
  UpdateTaskTemplateRequest,
  DescribeVocabularyRequest,
  CreateRoutingProfileRequest,
  DeleteQuickConnectRequest,
  ListDefaultVocabulariesRequest,
  UpdateUserRoutingProfileRequest,
  DescribeQuickConnectRequest,
  AssociateInstanceStorageConfigRequest,
  SearchAvailablePhoneNumbersRequest,
  CreateInstanceRequest,
  UpdateQueueNameRequest,
  ReleasePhoneNumberRequest,
  CreateContactFlowRequest,
  CreateVocabularyRequest,
  DeleteTaskTemplateRequest,
  UpdateContactFlowMetadataRequest,
  DeleteUseCaseRequest,
  CreateTrafficDistributionGroupRequest,
  DescribeInstanceAttributeRequest,
  ListUsersRequest,
  ListUseCasesRequest,
  AssociateSecurityKeyRequest,
  PutUserStatusRequest,
  UpdateContactFlowNameRequest,
  DescribeUserHierarchyStructureRequest,
  CreateAgentStatusRequest,
  UpdateHoursOfOperationRequest,
  UpdateAgentStatusRequest,
  DisassociateInstanceStorageConfigRequest,
  AssociateLexBotRequest,
  CreateContactFlowModuleRequest,
  ListQuickConnectsRequest,
  DisassociateQueueQuickConnectsRequest,
  UpdateUserHierarchyStructureRequest,
  CreateTaskTemplateRequest,
  AssociateQueueQuickConnectsRequest,
  GetCurrentMetricDataRequest,
  CreateQueueRequest,
  ListInstancesRequest,
  UpdateUserPhoneConfigRequest,
  DisassociatePhoneNumberContactFlowRequest,
  DescribeInstanceRequest,
  UpdatePhoneNumberRequest,
  DeleteUserHierarchyGroupRequest,
  ListTagsForResourceRequest,
  GetTrafficDistributionRequest,
  DisassociateBotRequest,
  ListBotsRequest,
  GetFederationTokenRequest,
  UpdateQuickConnectNameRequest,
  UpdateRoutingProfileQueuesRequest,
  DescribeRoutingProfileRequest,
  DescribeInstanceStorageConfigRequest,
  ListInstanceAttributesRequest,
  CreateHoursOfOperationRequest,
  ListRoutingProfileQueuesRequest,
  DeleteIntegrationAssociationRequest,
  StartChatContactRequest,
  ResumeContactRecordingRequest,
  ListPromptsRequest,
  UpdateInstanceStorageConfigRequest,
  DisassociateLambdaFunctionRequest,
  SearchUsersRequest,
  ListSecurityKeysRequest,
  TransferContactRequest,
  DeleteContactFlowModuleRequest,
  AssociateApprovedOriginRequest,
  CreateUserRequest,
  ListIntegrationAssociationsRequest,
  ListAgentStatusesRequest,
  SearchRoutingProfilesRequest,
  ListPhoneNumbersRequest,
  AssociateBotRequest,
  UpdateQueueStatusRequest,
  UpdateContactFlowModuleMetadataRequest,
  DisassociateSecurityKeyRequest,
  UpdateContactScheduleRequest,
  DescribeSecurityProfileRequest,
  DescribeContactRequest,
  DescribePhoneNumberRequest,
  DescribeHoursOfOperationRequest,
  ClaimPhoneNumberRequest,
  ListRoutingProfilesRequest,
  UpdateRoutingProfileConcurrencyRequest,
  ListApprovedOriginsRequest,
  CreateIntegrationAssociationRequest,
  UpdateRoutingProfileNameRequest,
  StopContactRecordingRequest,
  UpdateContactFlowModuleContentRequest,
  ListContactFlowsRequest,
  UpdateSecurityProfileRequest,
  CreateUseCaseRequest,
  AssociatePhoneNumberContactFlowRequest,
  UntagResourceRequest,
  StartTaskContactRequest,
  UpdateQueueHoursOfOperationRequest,
  ReplicateInstanceRequest,
  DeleteInstanceRequest,
  DeleteTrafficDistributionGroupRequest,
  UpdateUserHierarchyGroupNameRequest,
  DisassociateLexBotRequest,
  CreateUserHierarchyGroupRequest,
  UpdateUserIdentityInfoRequest,
  SearchSecurityProfilesRequest,
  GetMetricDataRequest,
  SearchQueuesRequest,
  StopContactRequest,
  UpdateContactAttributesRequest,
  DeleteVocabularyRequest,
  StartContactStreamingRequest,
  ListLambdaFunctionsRequest,
  ListUserHierarchyGroupsRequest,
  StartContactRecordingRequest,
  AssociateDefaultVocabularyRequest,
  SuspendContactRecordingRequest,
  ListQueueQuickConnectsRequest,
  DeleteHoursOfOperationRequest,
  AssociateLambdaFunctionRequest,
  SearchVocabulariesRequest,
  DescribeContactFlowRequest,
  ListSecurityProfilesRequest,
  ListContactFlowModulesRequest,
  CreateSecurityProfileRequest,
  UpdateInstanceAttributeRequest,
  StopContactStreamingRequest,
  DisassociateApprovedOriginRequest,
  UpdateQueueOutboundCallerConfigRequest,
  DescribeUserHierarchyGroupRequest,
  UpdateRoutingProfileDefaultOutboundQueueRequest,
  DescribeAgentStatusRequest,
  ListTrafficDistributionGroupsRequest,
  ListContactReferencesRequest,
  UpdateQuickConnectConfigRequest,
  UpdateContactRequest,
  UpdateUserHierarchyRequest,
  DescribeQueueRequest,
  ListPhoneNumbersV2Request,
  DeleteSecurityProfileRequest,
  TagResourceRequest,
  DescribeTrafficDistributionGroupRequest,
  DescribeContactFlowModuleRequest,
  ListHoursOfOperationsRequest,
  GetContactAttributesRequest,
  ListInstanceStorageConfigsRequest
}
import software.amazon.awssdk.services.connect.ConnectAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ConnectMock extends Mock[Connect] {
  object UpdateContact
      extends Effect[
        UpdateContactRequest,
        AwsError,
        zio.aws.connect.model.UpdateContactResponse.ReadOnly
      ]
  object ListContactFlowModules
      extends Stream[
        ListContactFlowModulesRequest,
        AwsError,
        zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
      ]
  object ListContactFlowModulesPaginated
      extends Effect[
        ListContactFlowModulesRequest,
        AwsError,
        zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly
      ]
  object DeleteTaskTemplate
      extends Effect[
        DeleteTaskTemplateRequest,
        AwsError,
        zio.aws.connect.model.DeleteTaskTemplateResponse.ReadOnly
      ]
  object ListAgentStatuses
      extends Stream[
        ListAgentStatusesRequest,
        AwsError,
        zio.aws.connect.model.AgentStatusSummary.ReadOnly
      ]
  object ListAgentStatusesPaginated
      extends Effect[
        ListAgentStatusesRequest,
        AwsError,
        zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly
      ]
  object CreateUseCase
      extends Effect[
        CreateUseCaseRequest,
        AwsError,
        zio.aws.connect.model.CreateUseCaseResponse.ReadOnly
      ]
  object UpdateRoutingProfileDefaultOutboundQueue
      extends Effect[
        UpdateRoutingProfileDefaultOutboundQueueRequest,
        AwsError,
        Unit
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.connect.model.UserSummary.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.connect.model.ListUsersResponse.ReadOnly
      ]
  object CreateRoutingProfile
      extends Effect[
        CreateRoutingProfileRequest,
        AwsError,
        zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly
      ]
  object ListRoutingProfiles
      extends Stream[
        ListRoutingProfilesRequest,
        AwsError,
        zio.aws.connect.model.RoutingProfileSummary.ReadOnly
      ]
  object ListRoutingProfilesPaginated
      extends Effect[
        ListRoutingProfilesRequest,
        AwsError,
        zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly
      ]
  object UpdateTaskTemplate
      extends Effect[
        UpdateTaskTemplateRequest,
        AwsError,
        zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly
      ]
  object DeleteContactFlow
      extends Effect[DeleteContactFlowRequest, AwsError, Unit]
  object GetTrafficDistribution
      extends Effect[
        GetTrafficDistributionRequest,
        AwsError,
        zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly
      ]
  object DisassociateRoutingProfileQueues
      extends Effect[DisassociateRoutingProfileQueuesRequest, AwsError, Unit]
  object DisassociateLambdaFunction
      extends Effect[DisassociateLambdaFunctionRequest, AwsError, Unit]
  object DescribePhoneNumber
      extends Effect[
        DescribePhoneNumberRequest,
        AwsError,
        zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly
      ]
  object DescribeVocabulary
      extends Effect[
        DescribeVocabularyRequest,
        AwsError,
        zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly
      ]
  object SearchUsers
      extends Effect[SearchUsersRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.connect.model.SearchUsersResponse.ReadOnly,
        zio.aws.connect.model.UserSearchSummary.ReadOnly
      ]]
  object SearchUsersPaginated
      extends Effect[
        SearchUsersRequest,
        AwsError,
        zio.aws.connect.model.SearchUsersResponse.ReadOnly
      ]
  object CreateAgentStatus
      extends Effect[
        CreateAgentStatusRequest,
        AwsError,
        zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly
      ]
  object DeleteVocabulary
      extends Effect[
        DeleteVocabularyRequest,
        AwsError,
        zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly
      ]
  object ListInstanceStorageConfigs
      extends Stream[
        ListInstanceStorageConfigsRequest,
        AwsError,
        zio.aws.connect.model.InstanceStorageConfig.ReadOnly
      ]
  object ListInstanceStorageConfigsPaginated
      extends Effect[
        ListInstanceStorageConfigsRequest,
        AwsError,
        zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly
      ]
  object UpdateHoursOfOperation
      extends Effect[UpdateHoursOfOperationRequest, AwsError, Unit]
  object StartChatContact
      extends Effect[
        StartChatContactRequest,
        AwsError,
        zio.aws.connect.model.StartChatContactResponse.ReadOnly
      ]
  object UpdateRoutingProfileQueues
      extends Effect[UpdateRoutingProfileQueuesRequest, AwsError, Unit]
  object DescribeInstance
      extends Effect[
        DescribeInstanceRequest,
        AwsError,
        zio.aws.connect.model.DescribeInstanceResponse.ReadOnly
      ]
  object GetContactAttributes
      extends Effect[
        GetContactAttributesRequest,
        AwsError,
        zio.aws.connect.model.GetContactAttributesResponse.ReadOnly
      ]
  object CreateSecurityProfile
      extends Effect[
        CreateSecurityProfileRequest,
        AwsError,
        zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly
      ]
  object DisassociatePhoneNumberContactFlow
      extends Effect[DisassociatePhoneNumberContactFlowRequest, AwsError, Unit]
  object UpdateQueueOutboundCallerConfig
      extends Effect[UpdateQueueOutboundCallerConfigRequest, AwsError, Unit]
  object ListPhoneNumbersV2
      extends Stream[
        ListPhoneNumbersV2Request,
        AwsError,
        zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
      ]
  object ListPhoneNumbersV2Paginated
      extends Effect[
        ListPhoneNumbersV2Request,
        AwsError,
        zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly
      ]
  object CreateTrafficDistributionGroup
      extends Effect[
        CreateTrafficDistributionGroupRequest,
        AwsError,
        zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly
      ]
  object DeleteContactFlowModule
      extends Effect[
        DeleteContactFlowModuleRequest,
        AwsError,
        zio.aws.connect.model.DeleteContactFlowModuleResponse.ReadOnly
      ]
  object GetTaskTemplate
      extends Effect[
        GetTaskTemplateRequest,
        AwsError,
        zio.aws.connect.model.GetTaskTemplateResponse.ReadOnly
      ]
  object CreateContactFlow
      extends Effect[
        CreateContactFlowRequest,
        AwsError,
        zio.aws.connect.model.CreateContactFlowResponse.ReadOnly
      ]
  object ListInstances
      extends Stream[
        ListInstancesRequest,
        AwsError,
        zio.aws.connect.model.InstanceSummary.ReadOnly
      ]
  object ListInstancesPaginated
      extends Effect[
        ListInstancesRequest,
        AwsError,
        zio.aws.connect.model.ListInstancesResponse.ReadOnly
      ]
  object UpdateContactFlowContent
      extends Effect[UpdateContactFlowContentRequest, AwsError, Unit]
  object AssociateDefaultVocabulary
      extends Effect[
        AssociateDefaultVocabularyRequest,
        AwsError,
        zio.aws.connect.model.AssociateDefaultVocabularyResponse.ReadOnly
      ]
  object AssociateLexBot extends Effect[AssociateLexBotRequest, AwsError, Unit]
  object AssociatePhoneNumberContactFlow
      extends Effect[AssociatePhoneNumberContactFlowRequest, AwsError, Unit]
  object DescribeHoursOfOperation
      extends Effect[
        DescribeHoursOfOperationRequest,
        AwsError,
        zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly
      ]
  object DescribeRoutingProfile
      extends Effect[
        DescribeRoutingProfileRequest,
        AwsError,
        zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly
      ]
  object UpdateRoutingProfileName
      extends Effect[UpdateRoutingProfileNameRequest, AwsError, Unit]
  object ListDefaultVocabularies
      extends Stream[
        ListDefaultVocabulariesRequest,
        AwsError,
        zio.aws.connect.model.DefaultVocabulary.ReadOnly
      ]
  object ListDefaultVocabulariesPaginated
      extends Effect[
        ListDefaultVocabulariesRequest,
        AwsError,
        zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly
      ]
  object UpdateContactFlowModuleContent
      extends Effect[
        UpdateContactFlowModuleContentRequest,
        AwsError,
        zio.aws.connect.model.UpdateContactFlowModuleContentResponse.ReadOnly
      ]
  object ReleasePhoneNumber
      extends Effect[ReleasePhoneNumberRequest, AwsError, Unit]
  object UpdateQuickConnectConfig
      extends Effect[UpdateQuickConnectConfigRequest, AwsError, Unit]
  object UpdateUserIdentityInfo
      extends Effect[UpdateUserIdentityInfoRequest, AwsError, Unit]
  object UpdateUserSecurityProfiles
      extends Effect[UpdateUserSecurityProfilesRequest, AwsError, Unit]
  object ListContactFlows
      extends Stream[
        ListContactFlowsRequest,
        AwsError,
        zio.aws.connect.model.ContactFlowSummary.ReadOnly
      ]
  object ListContactFlowsPaginated
      extends Effect[
        ListContactFlowsRequest,
        AwsError,
        zio.aws.connect.model.ListContactFlowsResponse.ReadOnly
      ]
  object ListQueues
      extends Stream[
        ListQueuesRequest,
        AwsError,
        zio.aws.connect.model.QueueSummary.ReadOnly
      ]
  object ListQueuesPaginated
      extends Effect[
        ListQueuesRequest,
        AwsError,
        zio.aws.connect.model.ListQueuesResponse.ReadOnly
      ]
  object UpdateRoutingProfileConcurrency
      extends Effect[UpdateRoutingProfileConcurrencyRequest, AwsError, Unit]
  object AssociateBot extends Effect[AssociateBotRequest, AwsError, Unit]
  object UpdateContactFlowModuleMetadata
      extends Effect[
        UpdateContactFlowModuleMetadataRequest,
        AwsError,
        zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.ReadOnly
      ]
  object DescribeTrafficDistributionGroup
      extends Effect[
        DescribeTrafficDistributionGroupRequest,
        AwsError,
        zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly
      ]
  object ResumeContactRecording
      extends Effect[
        ResumeContactRecordingRequest,
        AwsError,
        zio.aws.connect.model.ResumeContactRecordingResponse.ReadOnly
      ]
  object GetFederationToken
      extends Effect[
        GetFederationTokenRequest,
        AwsError,
        zio.aws.connect.model.GetFederationTokenResponse.ReadOnly
      ]
  object UpdateContactSchedule
      extends Effect[
        UpdateContactScheduleRequest,
        AwsError,
        zio.aws.connect.model.UpdateContactScheduleResponse.ReadOnly
      ]
  object DeleteInstance extends Effect[DeleteInstanceRequest, AwsError, Unit]
  object SearchRoutingProfiles
      extends Effect[
        SearchRoutingProfilesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly,
          zio.aws.connect.model.RoutingProfile.ReadOnly
        ]
      ]
  object SearchRoutingProfilesPaginated
      extends Effect[
        SearchRoutingProfilesRequest,
        AwsError,
        zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly
      ]
  object UpdateTrafficDistribution
      extends Effect[
        UpdateTrafficDistributionRequest,
        AwsError,
        zio.aws.connect.model.UpdateTrafficDistributionResponse.ReadOnly
      ]
  object GetMetricData
      extends Stream[
        GetMetricDataRequest,
        AwsError,
        zio.aws.connect.model.HistoricalMetricResult.ReadOnly
      ]
  object GetMetricDataPaginated
      extends Effect[
        GetMetricDataRequest,
        AwsError,
        zio.aws.connect.model.GetMetricDataResponse.ReadOnly
      ]
  object ListQuickConnects
      extends Stream[
        ListQuickConnectsRequest,
        AwsError,
        zio.aws.connect.model.QuickConnectSummary.ReadOnly
      ]
  object ListQuickConnectsPaginated
      extends Effect[
        ListQuickConnectsRequest,
        AwsError,
        zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly
      ]
  object GetCurrentUserData
      extends Stream[
        GetCurrentUserDataRequest,
        AwsError,
        zio.aws.connect.model.UserData.ReadOnly
      ]
  object GetCurrentUserDataPaginated
      extends Effect[
        GetCurrentUserDataRequest,
        AwsError,
        zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly
      ]
  object UpdateQueueName extends Effect[UpdateQueueNameRequest, AwsError, Unit]
  object ListQueueQuickConnects
      extends Stream[
        ListQueueQuickConnectsRequest,
        AwsError,
        zio.aws.connect.model.QuickConnectSummary.ReadOnly
      ]
  object ListQueueQuickConnectsPaginated
      extends Effect[
        ListQueueQuickConnectsRequest,
        AwsError,
        zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly
      ]
  object AssociateSecurityKey
      extends Effect[
        AssociateSecurityKeyRequest,
        AwsError,
        zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly
      ]
  object ListLambdaFunctions
      extends Stream[ListLambdaFunctionsRequest, AwsError, FunctionArn]
  object ListLambdaFunctionsPaginated
      extends Effect[
        ListLambdaFunctionsRequest,
        AwsError,
        zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly
      ]
  object AssociateQueueQuickConnects
      extends Effect[AssociateQueueQuickConnectsRequest, AwsError, Unit]
  object UpdateAgentStatus
      extends Effect[UpdateAgentStatusRequest, AwsError, Unit]
  object DescribeQueue
      extends Effect[
        DescribeQueueRequest,
        AwsError,
        zio.aws.connect.model.DescribeQueueResponse.ReadOnly
      ]
  object CreateVocabulary
      extends Effect[
        CreateVocabularyRequest,
        AwsError,
        zio.aws.connect.model.CreateVocabularyResponse.ReadOnly
      ]
  object SearchQueues
      extends Effect[SearchQueuesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.connect.model.SearchQueuesResponse.ReadOnly,
        zio.aws.connect.model.Queue.ReadOnly
      ]]
  object SearchQueuesPaginated
      extends Effect[
        SearchQueuesRequest,
        AwsError,
        zio.aws.connect.model.SearchQueuesResponse.ReadOnly
      ]
  object DisassociateSecurityKey
      extends Effect[DisassociateSecurityKeyRequest, AwsError, Unit]
  object StartContactStreaming
      extends Effect[
        StartContactStreamingRequest,
        AwsError,
        zio.aws.connect.model.StartContactStreamingResponse.ReadOnly
      ]
  object UpdateContactAttributes
      extends Effect[
        UpdateContactAttributesRequest,
        AwsError,
        zio.aws.connect.model.UpdateContactAttributesResponse.ReadOnly
      ]
  object DeleteSecurityProfile
      extends Effect[DeleteSecurityProfileRequest, AwsError, Unit]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.connect.model.CreateUserResponse.ReadOnly
      ]
  object CreateContactFlowModule
      extends Effect[
        CreateContactFlowModuleRequest,
        AwsError,
        zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly
      ]
  object DisassociateBot extends Effect[DisassociateBotRequest, AwsError, Unit]
  object ListPhoneNumbers
      extends Stream[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.connect.model.PhoneNumberSummary.ReadOnly
      ]
  object ListPhoneNumbersPaginated
      extends Effect[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly
      ]
  object UpdateUserHierarchyGroupName
      extends Effect[UpdateUserHierarchyGroupNameRequest, AwsError, Unit]
  object DisassociateQueueQuickConnects
      extends Effect[DisassociateQueueQuickConnectsRequest, AwsError, Unit]
  object ClaimPhoneNumber
      extends Effect[
        ClaimPhoneNumberRequest,
        AwsError,
        zio.aws.connect.model.ClaimPhoneNumberResponse.ReadOnly
      ]
  object DescribeSecurityProfile
      extends Effect[
        DescribeSecurityProfileRequest,
        AwsError,
        zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly
      ]
  object UpdatePhoneNumber
      extends Effect[
        UpdatePhoneNumberRequest,
        AwsError,
        zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly
      ]
  object ListContactReferences
      extends Stream[
        ListContactReferencesRequest,
        AwsError,
        zio.aws.connect.model.ReferenceSummary.ReadOnly
      ]
  object ListContactReferencesPaginated
      extends Effect[
        ListContactReferencesRequest,
        AwsError,
        zio.aws.connect.model.ListContactReferencesResponse.ReadOnly
      ]
  object UpdateQueueHoursOfOperation
      extends Effect[UpdateQueueHoursOfOperationRequest, AwsError, Unit]
  object UpdateInstanceStorageConfig
      extends Effect[UpdateInstanceStorageConfigRequest, AwsError, Unit]
  object ListPrompts
      extends Stream[
        ListPromptsRequest,
        AwsError,
        zio.aws.connect.model.PromptSummary.ReadOnly
      ]
  object ListPromptsPaginated
      extends Effect[
        ListPromptsRequest,
        AwsError,
        zio.aws.connect.model.ListPromptsResponse.ReadOnly
      ]
  object DeleteHoursOfOperation
      extends Effect[DeleteHoursOfOperationRequest, AwsError, Unit]
  object ListTrafficDistributionGroups
      extends Stream[
        ListTrafficDistributionGroupsRequest,
        AwsError,
        zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
      ]
  object ListTrafficDistributionGroupsPaginated
      extends Effect[
        ListTrafficDistributionGroupsRequest,
        AwsError,
        zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly
      ]
  object DeleteUseCase extends Effect[DeleteUseCaseRequest, AwsError, Unit]
  object ListTaskTemplates
      extends Stream[
        ListTaskTemplatesRequest,
        AwsError,
        zio.aws.connect.model.TaskTemplateMetadata.ReadOnly
      ]
  object ListTaskTemplatesPaginated
      extends Effect[
        ListTaskTemplatesRequest,
        AwsError,
        zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly
      ]
  object AssociateRoutingProfileQueues
      extends Effect[AssociateRoutingProfileQueuesRequest, AwsError, Unit]
  object SearchAvailablePhoneNumbers
      extends Stream[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        zio.aws.connect.model.AvailableNumberSummary.ReadOnly
      ]
  object SearchAvailablePhoneNumbersPaginated
      extends Effect[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DescribeContact
      extends Effect[
        DescribeContactRequest,
        AwsError,
        zio.aws.connect.model.DescribeContactResponse.ReadOnly
      ]
  object SearchSecurityProfiles
      extends Effect[
        SearchSecurityProfilesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly,
          zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
        ]
      ]
  object SearchSecurityProfilesPaginated
      extends Effect[
        SearchSecurityProfilesRequest,
        AwsError,
        zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly
      ]
  object UpdateUserPhoneConfig
      extends Effect[UpdateUserPhoneConfigRequest, AwsError, Unit]
  object ListRoutingProfileQueues
      extends Stream[
        ListRoutingProfileQueuesRequest,
        AwsError,
        zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
      ]
  object ListRoutingProfileQueuesPaginated
      extends Effect[
        ListRoutingProfileQueuesRequest,
        AwsError,
        zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly
      ]
  object UpdateQueueStatus
      extends Effect[UpdateQueueStatusRequest, AwsError, Unit]
  object ReplicateInstance
      extends Effect[
        ReplicateInstanceRequest,
        AwsError,
        zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly
      ]
  object ListSecurityProfiles
      extends Stream[
        ListSecurityProfilesRequest,
        AwsError,
        zio.aws.connect.model.SecurityProfileSummary.ReadOnly
      ]
  object ListSecurityProfilesPaginated
      extends Effect[ListSecurityProfilesRequest, AwsError, ReadOnly]
  object ListSecurityProfilePermissions
      extends Stream[
        ListSecurityProfilePermissionsRequest,
        AwsError,
        SecurityProfilePermission
      ]
  object ListSecurityProfilePermissionsPaginated
      extends Effect[
        ListSecurityProfilePermissionsRequest,
        AwsError,
        zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly
      ]
  object DeleteIntegrationAssociation
      extends Effect[DeleteIntegrationAssociationRequest, AwsError, Unit]
  object StopContactStreaming
      extends Effect[
        StopContactStreamingRequest,
        AwsError,
        zio.aws.connect.model.StopContactStreamingResponse.ReadOnly
      ]
  object ListBots
      extends Stream[
        ListBotsRequest,
        AwsError,
        zio.aws.connect.model.LexBotConfig.ReadOnly
      ]
  object ListBotsPaginated
      extends Effect[
        ListBotsRequest,
        AwsError,
        zio.aws.connect.model.ListBotsResponse.ReadOnly
      ]
  object DeleteQuickConnect
      extends Effect[DeleteQuickConnectRequest, AwsError, Unit]
  object ListSecurityKeys
      extends Stream[
        ListSecurityKeysRequest,
        AwsError,
        zio.aws.connect.model.SecurityKey.ReadOnly
      ]
  object ListSecurityKeysPaginated
      extends Effect[
        ListSecurityKeysRequest,
        AwsError,
        zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly
      ]
  object StopContact
      extends Effect[
        StopContactRequest,
        AwsError,
        zio.aws.connect.model.StopContactResponse.ReadOnly
      ]
  object CreateQueue
      extends Effect[
        CreateQueueRequest,
        AwsError,
        zio.aws.connect.model.CreateQueueResponse.ReadOnly
      ]
  object UpdateQueueMaxContacts
      extends Effect[UpdateQueueMaxContactsRequest, AwsError, Unit]
  object DeleteTrafficDistributionGroup
      extends Effect[
        DeleteTrafficDistributionGroupRequest,
        AwsError,
        zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.ReadOnly
      ]
  object DescribeInstanceStorageConfig
      extends Effect[
        DescribeInstanceStorageConfigRequest,
        AwsError,
        zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly
      ]
  object DescribeAgentStatus
      extends Effect[
        DescribeAgentStatusRequest,
        AwsError,
        zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly
      ]
  object AssociateApprovedOrigin
      extends Effect[AssociateApprovedOriginRequest, AwsError, Unit]
  object TransferContact
      extends Effect[
        TransferContactRequest,
        AwsError,
        zio.aws.connect.model.TransferContactResponse.ReadOnly
      ]
  object ListLexBots
      extends Stream[
        ListLexBotsRequest,
        AwsError,
        zio.aws.connect.model.LexBot.ReadOnly
      ]
  object ListLexBotsPaginated
      extends Effect[
        ListLexBotsRequest,
        AwsError,
        zio.aws.connect.model.ListLexBotsResponse.ReadOnly
      ]
  object GetCurrentMetricData
      extends Effect[
        GetCurrentMetricDataRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly,
          zio.aws.connect.model.CurrentMetricResult.ReadOnly
        ]
      ]
  object GetCurrentMetricDataPaginated
      extends Effect[
        GetCurrentMetricDataRequest,
        AwsError,
        zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly
      ]
  object StopContactRecording
      extends Effect[
        StopContactRecordingRequest,
        AwsError,
        zio.aws.connect.model.StopContactRecordingResponse.ReadOnly
      ]
  object DescribeInstanceAttribute
      extends Effect[
        DescribeInstanceAttributeRequest,
        AwsError,
        zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly
      ]
  object DescribeUser
      extends Effect[
        DescribeUserRequest,
        AwsError,
        zio.aws.connect.model.DescribeUserResponse.ReadOnly
      ]
  object UpdateContactFlowMetadata
      extends Effect[UpdateContactFlowMetadataRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.connect.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeUserHierarchyGroup
      extends Effect[
        DescribeUserHierarchyGroupRequest,
        AwsError,
        zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly
      ]
  object CreateTaskTemplate
      extends Effect[
        CreateTaskTemplateRequest,
        AwsError,
        zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object ListUseCases
      extends Stream[
        ListUseCasesRequest,
        AwsError,
        zio.aws.connect.model.UseCase.ReadOnly
      ]
  object ListUseCasesPaginated
      extends Effect[
        ListUseCasesRequest,
        AwsError,
        zio.aws.connect.model.ListUseCasesResponse.ReadOnly
      ]
  object SuspendContactRecording
      extends Effect[
        SuspendContactRecordingRequest,
        AwsError,
        zio.aws.connect.model.SuspendContactRecordingResponse.ReadOnly
      ]
  object DescribeContactFlow
      extends Effect[
        DescribeContactFlowRequest,
        AwsError,
        zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly
      ]
  object StartContactRecording
      extends Effect[
        StartContactRecordingRequest,
        AwsError,
        zio.aws.connect.model.StartContactRecordingResponse.ReadOnly
      ]
  object AssociateInstanceStorageConfig
      extends Effect[
        AssociateInstanceStorageConfigRequest,
        AwsError,
        zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly
      ]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object ListIntegrationAssociations
      extends Stream[
        ListIntegrationAssociationsRequest,
        AwsError,
        zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
      ]
  object ListIntegrationAssociationsPaginated
      extends Effect[
        ListIntegrationAssociationsRequest,
        AwsError,
        zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly
      ]
  object SearchVocabularies
      extends Stream[
        SearchVocabulariesRequest,
        AwsError,
        zio.aws.connect.model.VocabularySummary.ReadOnly
      ]
  object SearchVocabulariesPaginated
      extends Effect[
        SearchVocabulariesRequest,
        AwsError,
        zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly
      ]
  object CreateIntegrationAssociation
      extends Effect[
        CreateIntegrationAssociationRequest,
        AwsError,
        zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly
      ]
  object DisassociateLexBot
      extends Effect[DisassociateLexBotRequest, AwsError, Unit]
  object ListInstanceAttributes
      extends Stream[
        ListInstanceAttributesRequest,
        AwsError,
        zio.aws.connect.model.Attribute.ReadOnly
      ]
  object ListInstanceAttributesPaginated
      extends Effect[
        ListInstanceAttributesRequest,
        AwsError,
        zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly
      ]
  object ListHoursOfOperations
      extends Stream[
        ListHoursOfOperationsRequest,
        AwsError,
        zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
      ]
  object ListHoursOfOperationsPaginated
      extends Effect[
        ListHoursOfOperationsRequest,
        AwsError,
        zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly
      ]
  object UpdateContactFlowName
      extends Effect[UpdateContactFlowNameRequest, AwsError, Unit]
  object CreateInstance
      extends Effect[
        CreateInstanceRequest,
        AwsError,
        zio.aws.connect.model.CreateInstanceResponse.ReadOnly
      ]
  object ListUserHierarchyGroups
      extends Stream[
        ListUserHierarchyGroupsRequest,
        AwsError,
        zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
      ]
  object ListUserHierarchyGroupsPaginated
      extends Effect[
        ListUserHierarchyGroupsRequest,
        AwsError,
        zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly
      ]
  object DisassociateInstanceStorageConfig
      extends Effect[DisassociateInstanceStorageConfigRequest, AwsError, Unit]
  object UpdateSecurityProfile
      extends Effect[UpdateSecurityProfileRequest, AwsError, Unit]
  object DescribeContactFlowModule
      extends Effect[
        DescribeContactFlowModuleRequest,
        AwsError,
        zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly
      ]
  object StartOutboundVoiceContact
      extends Effect[
        StartOutboundVoiceContactRequest,
        AwsError,
        zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly
      ]
  object UpdateInstanceAttribute
      extends Effect[UpdateInstanceAttributeRequest, AwsError, Unit]
  object UpdateUserHierarchyStructure
      extends Effect[UpdateUserHierarchyStructureRequest, AwsError, Unit]
  object DescribeQuickConnect
      extends Effect[
        DescribeQuickConnectRequest,
        AwsError,
        zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly
      ]
  object ListApprovedOrigins
      extends Stream[ListApprovedOriginsRequest, AwsError, Origin]
  object ListApprovedOriginsPaginated
      extends Effect[
        ListApprovedOriginsRequest,
        AwsError,
        zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly
      ]
  object UpdateUserRoutingProfile
      extends Effect[UpdateUserRoutingProfileRequest, AwsError, Unit]
  object CreateQuickConnect
      extends Effect[
        CreateQuickConnectRequest,
        AwsError,
        zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly
      ]
  object PutUserStatus
      extends Effect[
        PutUserStatusRequest,
        AwsError,
        zio.aws.connect.model.PutUserStatusResponse.ReadOnly
      ]
  object UpdateQuickConnectName
      extends Effect[UpdateQuickConnectNameRequest, AwsError, Unit]
  object CreateHoursOfOperation
      extends Effect[
        CreateHoursOfOperationRequest,
        AwsError,
        zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly
      ]
  object CreateUserHierarchyGroup
      extends Effect[
        CreateUserHierarchyGroupRequest,
        AwsError,
        zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly
      ]
  object DeleteUserHierarchyGroup
      extends Effect[DeleteUserHierarchyGroupRequest, AwsError, Unit]
  object AssociateLambdaFunction
      extends Effect[AssociateLambdaFunctionRequest, AwsError, Unit]
  object UpdateUserHierarchy
      extends Effect[UpdateUserHierarchyRequest, AwsError, Unit]
  object StartTaskContact
      extends Effect[
        StartTaskContactRequest,
        AwsError,
        zio.aws.connect.model.StartTaskContactResponse.ReadOnly
      ]
  object DescribeUserHierarchyStructure
      extends Effect[
        DescribeUserHierarchyStructureRequest,
        AwsError,
        zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly
      ]
  object DisassociateApprovedOrigin
      extends Effect[DisassociateApprovedOriginRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Connect] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Connect] { rts =>
        ZIO.succeed {
          new Connect {
            val api: ConnectAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Connect = this
            def updateContact(request: UpdateContactRequest): IO[
              AwsError,
              zio.aws.connect.model.UpdateContactResponse.ReadOnly
            ] = proxy(UpdateContact, request)
            def listContactFlowModules(
                request: ListContactFlowModulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContactFlowModules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactFlowModulesPaginated(
                request: ListContactFlowModulesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListContactFlowModulesResponse.ReadOnly
            ] = proxy(ListContactFlowModulesPaginated, request)
            def deleteTaskTemplate(request: DeleteTaskTemplateRequest): IO[
              AwsError,
              zio.aws.connect.model.DeleteTaskTemplateResponse.ReadOnly
            ] = proxy(DeleteTaskTemplate, request)
            def listAgentStatuses(request: ListAgentStatusesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.AgentStatusSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAgentStatuses, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAgentStatusesPaginated(
                request: ListAgentStatusesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly
            ] = proxy(ListAgentStatusesPaginated, request)
            def createUseCase(request: CreateUseCaseRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateUseCaseResponse.ReadOnly
            ] = proxy(CreateUseCase, request)
            def updateRoutingProfileDefaultOutboundQueue(
                request: UpdateRoutingProfileDefaultOutboundQueueRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateRoutingProfileDefaultOutboundQueue, request)
            def listUsers(request: ListUsersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.UserSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsersPaginated(
                request: ListUsersRequest
            ): IO[AwsError, zio.aws.connect.model.ListUsersResponse.ReadOnly] =
              proxy(ListUsersPaginated, request)
            def createRoutingProfile(request: CreateRoutingProfileRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateRoutingProfileResponse.ReadOnly
            ] = proxy(CreateRoutingProfile, request)
            def listRoutingProfiles(
                request: ListRoutingProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.RoutingProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRoutingProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRoutingProfilesPaginated(
                request: ListRoutingProfilesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListRoutingProfilesResponse.ReadOnly
            ] = proxy(ListRoutingProfilesPaginated, request)
            def updateTaskTemplate(request: UpdateTaskTemplateRequest): IO[
              AwsError,
              zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly
            ] = proxy(UpdateTaskTemplate, request)
            def deleteContactFlow(
                request: DeleteContactFlowRequest
            ): IO[AwsError, Unit] = proxy(DeleteContactFlow, request)
            def getTrafficDistribution(
                request: GetTrafficDistributionRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly
            ] = proxy(GetTrafficDistribution, request)
            def disassociateRoutingProfileQueues(
                request: DisassociateRoutingProfileQueuesRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateRoutingProfileQueues, request)
            def disassociateLambdaFunction(
                request: DisassociateLambdaFunctionRequest
            ): IO[AwsError, Unit] = proxy(DisassociateLambdaFunction, request)
            def describePhoneNumber(request: DescribePhoneNumberRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly
            ] = proxy(DescribePhoneNumber, request)
            def describeVocabulary(request: DescribeVocabularyRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly
            ] = proxy(DescribeVocabulary, request)
            def searchUsers(
                request: SearchUsersRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.connect.model.SearchUsersResponse.ReadOnly,
              zio.aws.connect.model.UserSearchSummary.ReadOnly
            ]] = proxy(SearchUsers, request)
            def searchUsersPaginated(request: SearchUsersRequest): IO[
              AwsError,
              zio.aws.connect.model.SearchUsersResponse.ReadOnly
            ] = proxy(SearchUsersPaginated, request)
            def createAgentStatus(request: CreateAgentStatusRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly
            ] = proxy(CreateAgentStatus, request)
            def deleteVocabulary(request: DeleteVocabularyRequest): IO[
              AwsError,
              zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly
            ] = proxy(DeleteVocabulary, request)
            def listInstanceStorageConfigs(
                request: ListInstanceStorageConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.InstanceStorageConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInstanceStorageConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInstanceStorageConfigsPaginated(
                request: ListInstanceStorageConfigsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly
            ] = proxy(ListInstanceStorageConfigsPaginated, request)
            def updateHoursOfOperation(
                request: UpdateHoursOfOperationRequest
            ): IO[AwsError, Unit] = proxy(UpdateHoursOfOperation, request)
            def startChatContact(request: StartChatContactRequest): IO[
              AwsError,
              zio.aws.connect.model.StartChatContactResponse.ReadOnly
            ] = proxy(StartChatContact, request)
            def updateRoutingProfileQueues(
                request: UpdateRoutingProfileQueuesRequest
            ): IO[AwsError, Unit] = proxy(UpdateRoutingProfileQueues, request)
            def describeInstance(request: DescribeInstanceRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeInstanceResponse.ReadOnly
            ] = proxy(DescribeInstance, request)
            def getContactAttributes(request: GetContactAttributesRequest): IO[
              AwsError,
              zio.aws.connect.model.GetContactAttributesResponse.ReadOnly
            ] = proxy(GetContactAttributes, request)
            def createSecurityProfile(
                request: CreateSecurityProfileRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly
            ] = proxy(CreateSecurityProfile, request)
            def disassociatePhoneNumberContactFlow(
                request: DisassociatePhoneNumberContactFlowRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociatePhoneNumberContactFlow, request)
            def updateQueueOutboundCallerConfig(
                request: UpdateQueueOutboundCallerConfigRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateQueueOutboundCallerConfig, request)
            def listPhoneNumbersV2(request: ListPhoneNumbersV2Request): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPhoneNumbersV2, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPhoneNumbersV2Paginated(
                request: ListPhoneNumbersV2Request
            ): IO[
              AwsError,
              zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly
            ] = proxy(ListPhoneNumbersV2Paginated, request)
            def createTrafficDistributionGroup(
                request: CreateTrafficDistributionGroupRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly
            ] = proxy(CreateTrafficDistributionGroup, request)
            def deleteContactFlowModule(
                request: DeleteContactFlowModuleRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DeleteContactFlowModuleResponse.ReadOnly
            ] = proxy(DeleteContactFlowModule, request)
            def getTaskTemplate(request: GetTaskTemplateRequest): IO[
              AwsError,
              zio.aws.connect.model.GetTaskTemplateResponse.ReadOnly
            ] = proxy(GetTaskTemplate, request)
            def createContactFlow(request: CreateContactFlowRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateContactFlowResponse.ReadOnly
            ] = proxy(CreateContactFlow, request)
            def listInstances(request: ListInstancesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.InstanceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInstancesPaginated(request: ListInstancesRequest): IO[
              AwsError,
              zio.aws.connect.model.ListInstancesResponse.ReadOnly
            ] = proxy(ListInstancesPaginated, request)
            def updateContactFlowContent(
                request: UpdateContactFlowContentRequest
            ): IO[AwsError, Unit] = proxy(UpdateContactFlowContent, request)
            def associateDefaultVocabulary(
                request: AssociateDefaultVocabularyRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.AssociateDefaultVocabularyResponse.ReadOnly
            ] = proxy(AssociateDefaultVocabulary, request)
            def associateLexBot(
                request: AssociateLexBotRequest
            ): IO[AwsError, Unit] = proxy(AssociateLexBot, request)
            def associatePhoneNumberContactFlow(
                request: AssociatePhoneNumberContactFlowRequest
            ): IO[AwsError, Unit] =
              proxy(AssociatePhoneNumberContactFlow, request)
            def describeHoursOfOperation(
                request: DescribeHoursOfOperationRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly
            ] = proxy(DescribeHoursOfOperation, request)
            def describeRoutingProfile(
                request: DescribeRoutingProfileRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeRoutingProfileResponse.ReadOnly
            ] = proxy(DescribeRoutingProfile, request)
            def updateRoutingProfileName(
                request: UpdateRoutingProfileNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateRoutingProfileName, request)
            def listDefaultVocabularies(
                request: ListDefaultVocabulariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.DefaultVocabulary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDefaultVocabularies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDefaultVocabulariesPaginated(
                request: ListDefaultVocabulariesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly
            ] = proxy(ListDefaultVocabulariesPaginated, request)
            def updateContactFlowModuleContent(
                request: UpdateContactFlowModuleContentRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.UpdateContactFlowModuleContentResponse.ReadOnly
            ] = proxy(UpdateContactFlowModuleContent, request)
            def releasePhoneNumber(
                request: ReleasePhoneNumberRequest
            ): IO[AwsError, Unit] = proxy(ReleasePhoneNumber, request)
            def updateQuickConnectConfig(
                request: UpdateQuickConnectConfigRequest
            ): IO[AwsError, Unit] = proxy(UpdateQuickConnectConfig, request)
            def updateUserIdentityInfo(
                request: UpdateUserIdentityInfoRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserIdentityInfo, request)
            def updateUserSecurityProfiles(
                request: UpdateUserSecurityProfilesRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserSecurityProfiles, request)
            def listContactFlows(request: ListContactFlowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.ContactFlowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContactFlows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactFlowsPaginated(request: ListContactFlowsRequest): IO[
              AwsError,
              zio.aws.connect.model.ListContactFlowsResponse.ReadOnly
            ] = proxy(ListContactFlowsPaginated, request)
            def listQueues(request: ListQueuesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.QueueSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueues, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueuesPaginated(
                request: ListQueuesRequest
            ): IO[AwsError, zio.aws.connect.model.ListQueuesResponse.ReadOnly] =
              proxy(ListQueuesPaginated, request)
            def updateRoutingProfileConcurrency(
                request: UpdateRoutingProfileConcurrencyRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateRoutingProfileConcurrency, request)
            def associateBot(request: AssociateBotRequest): IO[AwsError, Unit] =
              proxy(AssociateBot, request)
            def updateContactFlowModuleMetadata(
                request: UpdateContactFlowModuleMetadataRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.UpdateContactFlowModuleMetadataResponse.ReadOnly
            ] = proxy(UpdateContactFlowModuleMetadata, request)
            def describeTrafficDistributionGroup(
                request: DescribeTrafficDistributionGroupRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly
            ] = proxy(DescribeTrafficDistributionGroup, request)
            def resumeContactRecording(
                request: ResumeContactRecordingRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ResumeContactRecordingResponse.ReadOnly
            ] = proxy(ResumeContactRecording, request)
            def getFederationToken(request: GetFederationTokenRequest): IO[
              AwsError,
              zio.aws.connect.model.GetFederationTokenResponse.ReadOnly
            ] = proxy(GetFederationToken, request)
            def updateContactSchedule(
                request: UpdateContactScheduleRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.UpdateContactScheduleResponse.ReadOnly
            ] = proxy(UpdateContactSchedule, request)
            def deleteInstance(
                request: DeleteInstanceRequest
            ): IO[AwsError, Unit] = proxy(DeleteInstance, request)
            def searchRoutingProfiles(
                request: SearchRoutingProfilesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly,
              zio.aws.connect.model.RoutingProfile.ReadOnly
            ]] = proxy(SearchRoutingProfiles, request)
            def searchRoutingProfilesPaginated(
                request: SearchRoutingProfilesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly
            ] = proxy(SearchRoutingProfilesPaginated, request)
            def updateTrafficDistribution(
                request: UpdateTrafficDistributionRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.UpdateTrafficDistributionResponse.ReadOnly
            ] = proxy(UpdateTrafficDistribution, request)
            def getMetricData(request: GetMetricDataRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.HistoricalMetricResult.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetMetricData, request)
                }
                .getOrThrowFiberFailure()
            }
            def getMetricDataPaginated(request: GetMetricDataRequest): IO[
              AwsError,
              zio.aws.connect.model.GetMetricDataResponse.ReadOnly
            ] = proxy(GetMetricDataPaginated, request)
            def listQuickConnects(request: ListQuickConnectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.QuickConnectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQuickConnects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQuickConnectsPaginated(
                request: ListQuickConnectsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly
            ] = proxy(ListQuickConnectsPaginated, request)
            def getCurrentUserData(
                request: GetCurrentUserDataRequest
            ): ZStream[Any, AwsError, zio.aws.connect.model.UserData.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetCurrentUserData, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getCurrentUserDataPaginated(
                request: GetCurrentUserDataRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly
            ] = proxy(GetCurrentUserDataPaginated, request)
            def updateQueueName(
                request: UpdateQueueNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateQueueName, request)
            def listQueueQuickConnects(
                request: ListQueueQuickConnectsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.QuickConnectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueueQuickConnects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueueQuickConnectsPaginated(
                request: ListQueueQuickConnectsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly
            ] = proxy(ListQueueQuickConnectsPaginated, request)
            def associateSecurityKey(request: AssociateSecurityKeyRequest): IO[
              AwsError,
              zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly
            ] = proxy(AssociateSecurityKey, request)
            def listLambdaFunctions(
                request: ListLambdaFunctionsRequest
            ): ZStream[Any, AwsError, FunctionArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLambdaFunctions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLambdaFunctionsPaginated(
                request: ListLambdaFunctionsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly
            ] = proxy(ListLambdaFunctionsPaginated, request)
            def associateQueueQuickConnects(
                request: AssociateQueueQuickConnectsRequest
            ): IO[AwsError, Unit] = proxy(AssociateQueueQuickConnects, request)
            def updateAgentStatus(
                request: UpdateAgentStatusRequest
            ): IO[AwsError, Unit] = proxy(UpdateAgentStatus, request)
            def describeQueue(request: DescribeQueueRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeQueueResponse.ReadOnly
            ] = proxy(DescribeQueue, request)
            def createVocabulary(request: CreateVocabularyRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateVocabularyResponse.ReadOnly
            ] = proxy(CreateVocabulary, request)
            def searchQueues(
                request: SearchQueuesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.connect.model.SearchQueuesResponse.ReadOnly,
              zio.aws.connect.model.Queue.ReadOnly
            ]] = proxy(SearchQueues, request)
            def searchQueuesPaginated(request: SearchQueuesRequest): IO[
              AwsError,
              zio.aws.connect.model.SearchQueuesResponse.ReadOnly
            ] = proxy(SearchQueuesPaginated, request)
            def disassociateSecurityKey(
                request: DisassociateSecurityKeyRequest
            ): IO[AwsError, Unit] = proxy(DisassociateSecurityKey, request)
            def startContactStreaming(
                request: StartContactStreamingRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.StartContactStreamingResponse.ReadOnly
            ] = proxy(StartContactStreaming, request)
            def updateContactAttributes(
                request: UpdateContactAttributesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.UpdateContactAttributesResponse.ReadOnly
            ] = proxy(UpdateContactAttributes, request)
            def deleteSecurityProfile(
                request: DeleteSecurityProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteSecurityProfile, request)
            def createUser(
                request: CreateUserRequest
            ): IO[AwsError, zio.aws.connect.model.CreateUserResponse.ReadOnly] =
              proxy(CreateUser, request)
            def createContactFlowModule(
                request: CreateContactFlowModuleRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly
            ] = proxy(CreateContactFlowModule, request)
            def disassociateBot(
                request: DisassociateBotRequest
            ): IO[AwsError, Unit] = proxy(DisassociateBot, request)
            def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.PhoneNumberSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPhoneNumbers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): IO[
              AwsError,
              zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly
            ] = proxy(ListPhoneNumbersPaginated, request)
            def updateUserHierarchyGroupName(
                request: UpdateUserHierarchyGroupNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserHierarchyGroupName, request)
            def disassociateQueueQuickConnects(
                request: DisassociateQueueQuickConnectsRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateQueueQuickConnects, request)
            def claimPhoneNumber(request: ClaimPhoneNumberRequest): IO[
              AwsError,
              zio.aws.connect.model.ClaimPhoneNumberResponse.ReadOnly
            ] = proxy(ClaimPhoneNumber, request)
            def describeSecurityProfile(
                request: DescribeSecurityProfileRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly
            ] = proxy(DescribeSecurityProfile, request)
            def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
              AwsError,
              zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly
            ] = proxy(UpdatePhoneNumber, request)
            def listContactReferences(
                request: ListContactReferencesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.ReferenceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContactReferences, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactReferencesPaginated(
                request: ListContactReferencesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListContactReferencesResponse.ReadOnly
            ] = proxy(ListContactReferencesPaginated, request)
            def updateQueueHoursOfOperation(
                request: UpdateQueueHoursOfOperationRequest
            ): IO[AwsError, Unit] = proxy(UpdateQueueHoursOfOperation, request)
            def updateInstanceStorageConfig(
                request: UpdateInstanceStorageConfigRequest
            ): IO[AwsError, Unit] = proxy(UpdateInstanceStorageConfig, request)
            def listPrompts(request: ListPromptsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.PromptSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPrompts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPromptsPaginated(request: ListPromptsRequest): IO[
              AwsError,
              zio.aws.connect.model.ListPromptsResponse.ReadOnly
            ] = proxy(ListPromptsPaginated, request)
            def deleteHoursOfOperation(
                request: DeleteHoursOfOperationRequest
            ): IO[AwsError, Unit] = proxy(DeleteHoursOfOperation, request)
            def listTrafficDistributionGroups(
                request: ListTrafficDistributionGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTrafficDistributionGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTrafficDistributionGroupsPaginated(
                request: ListTrafficDistributionGroupsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListTrafficDistributionGroupsResponse.ReadOnly
            ] = proxy(ListTrafficDistributionGroupsPaginated, request)
            def deleteUseCase(
                request: DeleteUseCaseRequest
            ): IO[AwsError, Unit] = proxy(DeleteUseCase, request)
            def listTaskTemplates(request: ListTaskTemplatesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.TaskTemplateMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTaskTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTaskTemplatesPaginated(
                request: ListTaskTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly
            ] = proxy(ListTaskTemplatesPaginated, request)
            def associateRoutingProfileQueues(
                request: AssociateRoutingProfileQueuesRequest
            ): IO[AwsError, Unit] =
              proxy(AssociateRoutingProfileQueues, request)
            def searchAvailablePhoneNumbers(
                request: SearchAvailablePhoneNumbersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.AvailableNumberSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchAvailablePhoneNumbers, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchAvailablePhoneNumbersPaginated(
                request: SearchAvailablePhoneNumbersRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly
            ] = proxy(SearchAvailablePhoneNumbersPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def describeContact(request: DescribeContactRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeContactResponse.ReadOnly
            ] = proxy(DescribeContact, request)
            def searchSecurityProfiles(
                request: SearchSecurityProfilesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly,
              zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
            ]] = proxy(SearchSecurityProfiles, request)
            def searchSecurityProfilesPaginated(
                request: SearchSecurityProfilesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly
            ] = proxy(SearchSecurityProfilesPaginated, request)
            def updateUserPhoneConfig(
                request: UpdateUserPhoneConfigRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserPhoneConfig, request)
            def listRoutingProfileQueues(
                request: ListRoutingProfileQueuesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRoutingProfileQueues, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRoutingProfileQueuesPaginated(
                request: ListRoutingProfileQueuesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly
            ] = proxy(ListRoutingProfileQueuesPaginated, request)
            def updateQueueStatus(
                request: UpdateQueueStatusRequest
            ): IO[AwsError, Unit] = proxy(UpdateQueueStatus, request)
            def replicateInstance(request: ReplicateInstanceRequest): IO[
              AwsError,
              zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly
            ] = proxy(ReplicateInstance, request)
            def listSecurityProfiles(
                request: ListSecurityProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.SecurityProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSecurityProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSecurityProfilesPaginated(
                request: ListSecurityProfilesRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListSecurityProfilesPaginated, request)
            def listSecurityProfilePermissions(
                request: ListSecurityProfilePermissionsRequest
            ): ZStream[Any, AwsError, SecurityProfilePermission] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListSecurityProfilePermissions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listSecurityProfilePermissionsPaginated(
                request: ListSecurityProfilePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly
            ] = proxy(ListSecurityProfilePermissionsPaginated, request)
            def deleteIntegrationAssociation(
                request: DeleteIntegrationAssociationRequest
            ): IO[AwsError, Unit] = proxy(DeleteIntegrationAssociation, request)
            def stopContactStreaming(request: StopContactStreamingRequest): IO[
              AwsError,
              zio.aws.connect.model.StopContactStreamingResponse.ReadOnly
            ] = proxy(StopContactStreaming, request)
            def listBots(request: ListBotsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.LexBotConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBots, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBotsPaginated(
                request: ListBotsRequest
            ): IO[AwsError, zio.aws.connect.model.ListBotsResponse.ReadOnly] =
              proxy(ListBotsPaginated, request)
            def deleteQuickConnect(
                request: DeleteQuickConnectRequest
            ): IO[AwsError, Unit] = proxy(DeleteQuickConnect, request)
            def listSecurityKeys(request: ListSecurityKeysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.SecurityKey.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSecurityKeys, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSecurityKeysPaginated(request: ListSecurityKeysRequest): IO[
              AwsError,
              zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly
            ] = proxy(ListSecurityKeysPaginated, request)
            def stopContact(request: StopContactRequest): IO[
              AwsError,
              zio.aws.connect.model.StopContactResponse.ReadOnly
            ] = proxy(StopContact, request)
            def createQueue(request: CreateQueueRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateQueueResponse.ReadOnly
            ] = proxy(CreateQueue, request)
            def updateQueueMaxContacts(
                request: UpdateQueueMaxContactsRequest
            ): IO[AwsError, Unit] = proxy(UpdateQueueMaxContacts, request)
            def deleteTrafficDistributionGroup(
                request: DeleteTrafficDistributionGroupRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DeleteTrafficDistributionGroupResponse.ReadOnly
            ] = proxy(DeleteTrafficDistributionGroup, request)
            def describeInstanceStorageConfig(
                request: DescribeInstanceStorageConfigRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly
            ] = proxy(DescribeInstanceStorageConfig, request)
            def describeAgentStatus(request: DescribeAgentStatusRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeAgentStatusResponse.ReadOnly
            ] = proxy(DescribeAgentStatus, request)
            def associateApprovedOrigin(
                request: AssociateApprovedOriginRequest
            ): IO[AwsError, Unit] = proxy(AssociateApprovedOrigin, request)
            def transferContact(request: TransferContactRequest): IO[
              AwsError,
              zio.aws.connect.model.TransferContactResponse.ReadOnly
            ] = proxy(TransferContact, request)
            def listLexBots(
                request: ListLexBotsRequest
            ): ZStream[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLexBots, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLexBotsPaginated(request: ListLexBotsRequest): IO[
              AwsError,
              zio.aws.connect.model.ListLexBotsResponse.ReadOnly
            ] = proxy(ListLexBotsPaginated, request)
            def getCurrentMetricData(
                request: GetCurrentMetricDataRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly,
              zio.aws.connect.model.CurrentMetricResult.ReadOnly
            ]] = proxy(GetCurrentMetricData, request)
            def getCurrentMetricDataPaginated(
                request: GetCurrentMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.GetCurrentMetricDataResponse.ReadOnly
            ] = proxy(GetCurrentMetricDataPaginated, request)
            def stopContactRecording(request: StopContactRecordingRequest): IO[
              AwsError,
              zio.aws.connect.model.StopContactRecordingResponse.ReadOnly
            ] = proxy(StopContactRecording, request)
            def describeInstanceAttribute(
                request: DescribeInstanceAttributeRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly
            ] = proxy(DescribeInstanceAttribute, request)
            def describeUser(request: DescribeUserRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeUserResponse.ReadOnly
            ] = proxy(DescribeUser, request)
            def updateContactFlowMetadata(
                request: UpdateContactFlowMetadataRequest
            ): IO[AwsError, Unit] = proxy(UpdateContactFlowMetadata, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.connect.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeUserHierarchyGroup(
                request: DescribeUserHierarchyGroupRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeUserHierarchyGroupResponse.ReadOnly
            ] = proxy(DescribeUserHierarchyGroup, request)
            def createTaskTemplate(request: CreateTaskTemplateRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly
            ] = proxy(CreateTaskTemplate, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def listUseCases(
                request: ListUseCasesRequest
            ): ZStream[Any, AwsError, zio.aws.connect.model.UseCase.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListUseCases, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listUseCasesPaginated(request: ListUseCasesRequest): IO[
              AwsError,
              zio.aws.connect.model.ListUseCasesResponse.ReadOnly
            ] = proxy(ListUseCasesPaginated, request)
            def suspendContactRecording(
                request: SuspendContactRecordingRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.SuspendContactRecordingResponse.ReadOnly
            ] = proxy(SuspendContactRecording, request)
            def describeContactFlow(request: DescribeContactFlowRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly
            ] = proxy(DescribeContactFlow, request)
            def startContactRecording(
                request: StartContactRecordingRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.StartContactRecordingResponse.ReadOnly
            ] = proxy(StartContactRecording, request)
            def associateInstanceStorageConfig(
                request: AssociateInstanceStorageConfigRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly
            ] = proxy(AssociateInstanceStorageConfig, request)
            def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
              proxy(DeleteUser, request)
            def listIntegrationAssociations(
                request: ListIntegrationAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIntegrationAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIntegrationAssociationsPaginated(
                request: ListIntegrationAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly
            ] = proxy(ListIntegrationAssociationsPaginated, request)
            def searchVocabularies(request: SearchVocabulariesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.VocabularySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchVocabularies, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchVocabulariesPaginated(
                request: SearchVocabulariesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly
            ] = proxy(SearchVocabulariesPaginated, request)
            def createIntegrationAssociation(
                request: CreateIntegrationAssociationRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly
            ] = proxy(CreateIntegrationAssociation, request)
            def disassociateLexBot(
                request: DisassociateLexBotRequest
            ): IO[AwsError, Unit] = proxy(DisassociateLexBot, request)
            def listInstanceAttributes(
                request: ListInstanceAttributesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.Attribute.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInstanceAttributes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInstanceAttributesPaginated(
                request: ListInstanceAttributesRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly
            ] = proxy(ListInstanceAttributesPaginated, request)
            def listHoursOfOperations(
                request: ListHoursOfOperationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHoursOfOperations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHoursOfOperationsPaginated(
                request: ListHoursOfOperationsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly
            ] = proxy(ListHoursOfOperationsPaginated, request)
            def updateContactFlowName(
                request: UpdateContactFlowNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateContactFlowName, request)
            def createInstance(request: CreateInstanceRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateInstanceResponse.ReadOnly
            ] = proxy(CreateInstance, request)
            def listUserHierarchyGroups(
                request: ListUserHierarchyGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUserHierarchyGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUserHierarchyGroupsPaginated(
                request: ListUserHierarchyGroupsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly
            ] = proxy(ListUserHierarchyGroupsPaginated, request)
            def disassociateInstanceStorageConfig(
                request: DisassociateInstanceStorageConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateInstanceStorageConfig, request)
            def updateSecurityProfile(
                request: UpdateSecurityProfileRequest
            ): IO[AwsError, Unit] = proxy(UpdateSecurityProfile, request)
            def describeContactFlowModule(
                request: DescribeContactFlowModuleRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeContactFlowModuleResponse.ReadOnly
            ] = proxy(DescribeContactFlowModule, request)
            def startOutboundVoiceContact(
                request: StartOutboundVoiceContactRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly
            ] = proxy(StartOutboundVoiceContact, request)
            def updateInstanceAttribute(
                request: UpdateInstanceAttributeRequest
            ): IO[AwsError, Unit] = proxy(UpdateInstanceAttribute, request)
            def updateUserHierarchyStructure(
                request: UpdateUserHierarchyStructureRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserHierarchyStructure, request)
            def describeQuickConnect(request: DescribeQuickConnectRequest): IO[
              AwsError,
              zio.aws.connect.model.DescribeQuickConnectResponse.ReadOnly
            ] = proxy(DescribeQuickConnect, request)
            def listApprovedOrigins(
                request: ListApprovedOriginsRequest
            ): ZStream[Any, AwsError, Origin] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListApprovedOrigins, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listApprovedOriginsPaginated(
                request: ListApprovedOriginsRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly
            ] = proxy(ListApprovedOriginsPaginated, request)
            def updateUserRoutingProfile(
                request: UpdateUserRoutingProfileRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserRoutingProfile, request)
            def createQuickConnect(request: CreateQuickConnectRequest): IO[
              AwsError,
              zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly
            ] = proxy(CreateQuickConnect, request)
            def putUserStatus(request: PutUserStatusRequest): IO[
              AwsError,
              zio.aws.connect.model.PutUserStatusResponse.ReadOnly
            ] = proxy(PutUserStatus, request)
            def updateQuickConnectName(
                request: UpdateQuickConnectNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateQuickConnectName, request)
            def createHoursOfOperation(
                request: CreateHoursOfOperationRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly
            ] = proxy(CreateHoursOfOperation, request)
            def createUserHierarchyGroup(
                request: CreateUserHierarchyGroupRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly
            ] = proxy(CreateUserHierarchyGroup, request)
            def deleteUserHierarchyGroup(
                request: DeleteUserHierarchyGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteUserHierarchyGroup, request)
            def associateLambdaFunction(
                request: AssociateLambdaFunctionRequest
            ): IO[AwsError, Unit] = proxy(AssociateLambdaFunction, request)
            def updateUserHierarchy(
                request: UpdateUserHierarchyRequest
            ): IO[AwsError, Unit] = proxy(UpdateUserHierarchy, request)
            def startTaskContact(request: StartTaskContactRequest): IO[
              AwsError,
              zio.aws.connect.model.StartTaskContactResponse.ReadOnly
            ] = proxy(StartTaskContact, request)
            def describeUserHierarchyStructure(
                request: DescribeUserHierarchyStructureRequest
            ): IO[
              AwsError,
              zio.aws.connect.model.DescribeUserHierarchyStructureResponse.ReadOnly
            ] = proxy(DescribeUserHierarchyStructure, request)
            def disassociateApprovedOrigin(
                request: DisassociateApprovedOriginRequest
            ): IO[AwsError, Unit] = proxy(DisassociateApprovedOrigin, request)
          }
        }
      }
    }
  }
}
