package zio.aws.connect.model
import zio.aws.connect.model.primitives.{Timestamp, ContactId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AgentContactReference(
    contactId: Optional[ContactId] = Optional.Absent,
    channel: Optional[zio.aws.connect.model.Channel] = Optional.Absent,
    initiationMethod: Optional[zio.aws.connect.model.ContactInitiationMethod] =
      Optional.Absent,
    agentContactState: Optional[zio.aws.connect.model.ContactState] =
      Optional.Absent,
    stateStartTimestamp: Optional[Timestamp] = Optional.Absent,
    connectedToAgentTimestamp: Optional[Timestamp] = Optional.Absent,
    queue: Optional[zio.aws.connect.model.QueueReference] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentContactReference = {
    import AgentContactReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentContactReference
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .optionallyWith(channel.map(value => value.unwrap))(_.channel)
      .optionallyWith(initiationMethod.map(value => value.unwrap))(
        _.initiationMethod
      )
      .optionallyWith(agentContactState.map(value => value.unwrap))(
        _.agentContactState
      )
      .optionallyWith(
        stateStartTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.stateStartTimestamp)
      .optionallyWith(
        connectedToAgentTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.connectedToAgentTimestamp)
      .optionallyWith(queue.map(value => value.buildAwsValue()))(_.queue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentContactReference.ReadOnly =
    zio.aws.connect.model.AgentContactReference.wrap(buildAwsValue())
}
object AgentContactReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentContactReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentContactReference =
      zio.aws.connect.model.AgentContactReference(
        contactId.map(value => value),
        channel.map(value => value),
        initiationMethod.map(value => value),
        agentContactState.map(value => value),
        stateStartTimestamp.map(value => value),
        connectedToAgentTimestamp.map(value => value),
        queue.map(value => value.asEditable)
      )
    def contactId: Optional[ContactId]
    def channel: Optional[zio.aws.connect.model.Channel]
    def initiationMethod
        : Optional[zio.aws.connect.model.ContactInitiationMethod]
    def agentContactState: Optional[zio.aws.connect.model.ContactState]
    def stateStartTimestamp: Optional[Timestamp]
    def connectedToAgentTimestamp: Optional[Timestamp]
    def queue: Optional[zio.aws.connect.model.QueueReference.ReadOnly]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getChannel: ZIO[Any, AwsError, zio.aws.connect.model.Channel] =
      AwsError.unwrapOptionField("channel", channel)
    def getInitiationMethod
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactInitiationMethod] =
      AwsError.unwrapOptionField("initiationMethod", initiationMethod)
    def getAgentContactState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactState] =
      AwsError.unwrapOptionField("agentContactState", agentContactState)
    def getStateStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stateStartTimestamp", stateStartTimestamp)
    def getConnectedToAgentTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("connectedToAgentTimestamp", connectedToAgentTimestamp)
    def getQueue
        : ZIO[Any, AwsError, zio.aws.connect.model.QueueReference.ReadOnly] =
      AwsError.unwrapOptionField("queue", queue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentContactReference
  ) extends zio.aws.connect.model.AgentContactReference.ReadOnly {
    override val contactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val channel: Optional[zio.aws.connect.model.Channel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.connect.model.Channel.wrap(value))
    override val initiationMethod
        : Optional[zio.aws.connect.model.ContactInitiationMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiationMethod())
        .map(value => zio.aws.connect.model.ContactInitiationMethod.wrap(value))
    override val agentContactState
        : Optional[zio.aws.connect.model.ContactState] = zio.aws.core.internal
      .optionalFromNullable(impl.agentContactState())
      .map(value => zio.aws.connect.model.ContactState.wrap(value))
    override val stateStartTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateStartTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val connectedToAgentTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectedToAgentTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val queue
        : Optional[zio.aws.connect.model.QueueReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queue())
        .map(value => zio.aws.connect.model.QueueReference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentContactReference
  ): zio.aws.connect.model.AgentContactReference.ReadOnly = new Wrapper(impl)
}
