package zio.aws.connect.model
import zio.aws.connect.model.primitives.{Timestamp, AgentResourceId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AgentInfo(
    id: Optional[AgentResourceId] = Optional.Absent,
    connectedToAgentTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentInfo = {
    import AgentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentInfo
      .builder()
      .optionallyWith(
        id.map(value => AgentResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        connectedToAgentTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.connectedToAgentTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentInfo.ReadOnly =
    zio.aws.connect.model.AgentInfo.wrap(buildAwsValue())
}
object AgentInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.AgentInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentInfo =
      zio.aws.connect.model.AgentInfo(
        id.map(value => value),
        connectedToAgentTimestamp.map(value => value)
      )
    def id: Optional[AgentResourceId]
    def connectedToAgentTimestamp: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, AgentResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getConnectedToAgentTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("connectedToAgentTimestamp", connectedToAgentTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentInfo
  ) extends zio.aws.connect.model.AgentInfo.ReadOnly {
    override val id: Optional[AgentResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.AgentResourceId(value))
    override val connectedToAgentTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectedToAgentTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentInfo
  ): zio.aws.connect.model.AgentInfo.ReadOnly = new Wrapper(impl)
}
