package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  AgentStatusId,
  TagValue,
  AgentStatusName,
  AgentStatusOrderNumber,
  AgentStatusDescription,
  ARN,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AgentStatus(
    agentStatusARN: Optional[ARN] = Optional.Absent,
    agentStatusId: Optional[AgentStatusId] = Optional.Absent,
    name: Optional[AgentStatusName] = Optional.Absent,
    description: Optional[AgentStatusDescription] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.AgentStatusType] = Optional.Absent,
    displayOrder: Optional[AgentStatusOrderNumber] = Optional.Absent,
    state: Optional[zio.aws.connect.model.AgentStatusState] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentStatus = {
    import AgentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentStatus
      .builder()
      .optionallyWith(
        agentStatusARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.agentStatusARN)
      .optionallyWith(
        agentStatusId.map(value =>
          AgentStatusId.unwrap(value): java.lang.String
        )
      )(_.agentStatusId)
      .optionallyWith(
        name.map(value => AgentStatusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AgentStatusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        displayOrder.map(value => AgentStatusOrderNumber.unwrap(value): Integer)
      )(_.displayOrder)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentStatus.ReadOnly =
    zio.aws.connect.model.AgentStatus.wrap(buildAwsValue())
}
object AgentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentStatus =
      zio.aws.connect.model.AgentStatus(
        agentStatusARN.map(value => value),
        agentStatusId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        displayOrder.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def agentStatusARN: Optional[ARN]
    def agentStatusId: Optional[AgentStatusId]
    def name: Optional[AgentStatusName]
    def description: Optional[AgentStatusDescription]
    def `type`: Optional[zio.aws.connect.model.AgentStatusType]
    def displayOrder: Optional[AgentStatusOrderNumber]
    def state: Optional[zio.aws.connect.model.AgentStatusState]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAgentStatusARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("agentStatusARN", agentStatusARN)
    def getAgentStatusId: ZIO[Any, AwsError, AgentStatusId] =
      AwsError.unwrapOptionField("agentStatusId", agentStatusId)
    def getName: ZIO[Any, AwsError, AgentStatusName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AgentStatusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDisplayOrder: ZIO[Any, AwsError, AgentStatusOrderNumber] =
      AwsError.unwrapOptionField("displayOrder", displayOrder)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentStatus
  ) extends zio.aws.connect.model.AgentStatus.ReadOnly {
    override val agentStatusARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.agentStatusARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val agentStatusId: Optional[AgentStatusId] = zio.aws.core.internal
      .optionalFromNullable(impl.agentStatusId())
      .map(value => zio.aws.connect.model.primitives.AgentStatusId(value))
    override val name: Optional[AgentStatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.AgentStatusName(value))
    override val description: Optional[AgentStatusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.AgentStatusDescription(value)
        )
    override val `type`: Optional[zio.aws.connect.model.AgentStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.AgentStatusType.wrap(value))
    override val displayOrder: Optional[AgentStatusOrderNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayOrder())
        .map(value =>
          zio.aws.connect.model.primitives.AgentStatusOrderNumber(value)
        )
    override val state: Optional[zio.aws.connect.model.AgentStatusState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.AgentStatusState.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentStatus
  ): zio.aws.connect.model.AgentStatus.ReadOnly = new Wrapper(impl)
}
