package zio.aws.connect.model
import zio.aws.connect.model.primitives.{ARN, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AgentStatusReference(
    statusStartTimestamp: Optional[Timestamp] = Optional.Absent,
    statusArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentStatusReference = {
    import AgentStatusReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentStatusReference
      .builder()
      .optionallyWith(
        statusStartTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.statusStartTimestamp)
      .optionallyWith(
        statusArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.statusArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentStatusReference.ReadOnly =
    zio.aws.connect.model.AgentStatusReference.wrap(buildAwsValue())
}
object AgentStatusReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentStatusReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentStatusReference =
      zio.aws.connect.model.AgentStatusReference(
        statusStartTimestamp.map(value => value),
        statusArn.map(value => value)
      )
    def statusStartTimestamp: Optional[Timestamp]
    def statusArn: Optional[ARN]
    def getStatusStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("statusStartTimestamp", statusStartTimestamp)
    def getStatusArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("statusArn", statusArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusReference
  ) extends zio.aws.connect.model.AgentStatusReference.ReadOnly {
    override val statusStartTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusStartTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val statusArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.statusArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusReference
  ): zio.aws.connect.model.AgentStatusReference.ReadOnly = new Wrapper(impl)
}
