package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{VocabularyId, InstanceId}
import scala.jdk.CollectionConverters._
final case class AssociateDefaultVocabularyRequest(
    instanceId: InstanceId,
    languageCode: zio.aws.connect.model.VocabularyLanguageCode,
    vocabularyId: Optional[VocabularyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest = {
    import AssociateDefaultVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        vocabularyId.map(value => VocabularyId.unwrap(value): java.lang.String)
      )(_.vocabularyId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateDefaultVocabularyRequest.ReadOnly =
    zio.aws.connect.model.AssociateDefaultVocabularyRequest
      .wrap(buildAwsValue())
}
object AssociateDefaultVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateDefaultVocabularyRequest =
      zio.aws.connect.model.AssociateDefaultVocabularyRequest(
        instanceId,
        languageCode,
        vocabularyId.map(value => value)
      )
    def instanceId: InstanceId
    def languageCode: zio.aws.connect.model.VocabularyLanguageCode
    def vocabularyId: Optional[VocabularyId]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.connect.model.VocabularyLanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyId: ZIO[Any, AwsError, VocabularyId] =
      AwsError.unwrapOptionField("vocabularyId", vocabularyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest
  ) extends zio.aws.connect.model.AssociateDefaultVocabularyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val languageCode: zio.aws.connect.model.VocabularyLanguageCode =
      zio.aws.connect.model.VocabularyLanguageCode.wrap(impl.languageCode())
    override val vocabularyId: Optional[VocabularyId] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyId())
      .map(value => zio.aws.connect.model.primitives.VocabularyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest
  ): zio.aws.connect.model.AssociateDefaultVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
