package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  ContactFlowId,
  InstanceId,
  PhoneNumberId
}
import scala.jdk.CollectionConverters._
final case class AssociatePhoneNumberContactFlowRequest(
    phoneNumberId: PhoneNumberId,
    instanceId: InstanceId,
    contactFlowId: ContactFlowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest = {
    import AssociatePhoneNumberContactFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest
      .builder()
      .phoneNumberId(PhoneNumberId.unwrap(phoneNumberId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest.ReadOnly =
    zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest
      .wrap(buildAwsValue())
}
object AssociatePhoneNumberContactFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest =
      zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest(
        phoneNumberId,
        instanceId,
        contactFlowId
      )
    def phoneNumberId: PhoneNumberId
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberId] =
      ZIO.succeed(phoneNumberId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest
  ) extends zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberId =
      zio.aws.connect.model.primitives.PhoneNumberId(impl.phoneNumberId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest
  ): zio.aws.connect.model.AssociatePhoneNumberContactFlowRequest.ReadOnly =
    new Wrapper(impl)
}
