package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.InstanceAttributeValue
import scala.jdk.CollectionConverters._
final case class Attribute(
    attributeType: Optional[zio.aws.connect.model.InstanceAttributeType] =
      Optional.Absent,
    value: Optional[InstanceAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Attribute = {
    import Attribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Attribute
      .builder()
      .optionallyWith(attributeType.map(value => value.unwrap))(_.attributeType)
      .optionallyWith(
        value.map(value =>
          InstanceAttributeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Attribute.ReadOnly =
    zio.aws.connect.model.Attribute.wrap(buildAwsValue())
}
object Attribute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Attribute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Attribute = zio.aws.connect.model
      .Attribute(attributeType.map(value => value), value.map(value => value))
    def attributeType: Optional[zio.aws.connect.model.InstanceAttributeType]
    def value: Optional[InstanceAttributeValue]
    def getAttributeType
        : ZIO[Any, AwsError, zio.aws.connect.model.InstanceAttributeType] =
      AwsError.unwrapOptionField("attributeType", attributeType)
    def getValue: ZIO[Any, AwsError, InstanceAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Attribute
  ) extends zio.aws.connect.model.Attribute.ReadOnly {
    override val attributeType
        : Optional[zio.aws.connect.model.InstanceAttributeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeType())
        .map(value => zio.aws.connect.model.InstanceAttributeType.wrap(value))
    override val value: Optional[InstanceAttributeValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.connect.model.primitives.InstanceAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Attribute
  ): zio.aws.connect.model.Attribute.ReadOnly = new Wrapper(impl)
}
