package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.PhoneNumber
import scala.jdk.CollectionConverters._
final case class AvailableNumberSummary(
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    phoneNumberCountryCode: Optional[
      zio.aws.connect.model.PhoneNumberCountryCode
    ] = Optional.Absent,
    phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AvailableNumberSummary = {
    import AvailableNumberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AvailableNumberSummary
      .builder()
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(phoneNumberCountryCode.map(value => value.unwrap))(
        _.phoneNumberCountryCode
      )
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AvailableNumberSummary.ReadOnly =
    zio.aws.connect.model.AvailableNumberSummary.wrap(buildAwsValue())
}
object AvailableNumberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AvailableNumberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AvailableNumberSummary =
      zio.aws.connect.model.AvailableNumberSummary(
        phoneNumber.map(value => value),
        phoneNumberCountryCode.map(value => value),
        phoneNumberType.map(value => value)
      )
    def phoneNumber: Optional[PhoneNumber]
    def phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode]
    def phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType]
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumberCountryCode
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberCountryCode] =
      AwsError.unwrapOptionField(
        "phoneNumberCountryCode",
        phoneNumberCountryCode
      )
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AvailableNumberSummary
  ) extends zio.aws.connect.model.AvailableNumberSummary.ReadOnly {
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCode())
        .map(value => zio.aws.connect.model.PhoneNumberCountryCode.wrap(value))
    override val phoneNumberType
        : Optional[zio.aws.connect.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberType())
        .map(value => zio.aws.connect.model.PhoneNumberType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AvailableNumberSummary
  ): zio.aws.connect.model.AvailableNumberSummary.ReadOnly = new Wrapper(impl)
}
