package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait Channel {
  def unwrap: software.amazon.awssdk.services.connect.model.Channel
}
object Channel {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.Channel
  ): zio.aws.connect.model.Channel = value match {
    case software.amazon.awssdk.services.connect.model.Channel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.Channel.VOICE =>
      val r = VOICE
      r
    case software.amazon.awssdk.services.connect.model.Channel.CHAT =>
      val r = CHAT
      r
    case software.amazon.awssdk.services.connect.model.Channel.TASK =>
      val r = TASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.Channel {
    override def unwrap: software.amazon.awssdk.services.connect.model.Channel =
      software.amazon.awssdk.services.connect.model.Channel.UNKNOWN_TO_SDK_VERSION
  }
  case object VOICE extends zio.aws.connect.model.Channel {
    override def unwrap: software.amazon.awssdk.services.connect.model.Channel =
      software.amazon.awssdk.services.connect.model.Channel.VOICE
  }
  case object CHAT extends zio.aws.connect.model.Channel {
    override def unwrap: software.amazon.awssdk.services.connect.model.Channel =
      software.amazon.awssdk.services.connect.model.Channel.CHAT
  }
  case object TASK extends zio.aws.connect.model.Channel {
    override def unwrap: software.amazon.awssdk.services.connect.model.Channel =
      software.amazon.awssdk.services.connect.model.Channel.TASK
  }
}
