package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.ChatStreamingEndpointARN
import scala.jdk.CollectionConverters._
final case class ChatStreamingConfiguration(
    streamingEndpointArn: ChatStreamingEndpointARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration = {
    import ChatStreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration
      .builder()
      .streamingEndpointArn(
        ChatStreamingEndpointARN.unwrap(streamingEndpointArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly =
    zio.aws.connect.model.ChatStreamingConfiguration.wrap(buildAwsValue())
}
object ChatStreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ChatStreamingConfiguration =
      zio.aws.connect.model.ChatStreamingConfiguration(streamingEndpointArn)
    def streamingEndpointArn: ChatStreamingEndpointARN
    def getStreamingEndpointArn: ZIO[Any, Nothing, ChatStreamingEndpointARN] =
      ZIO.succeed(streamingEndpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration
  ) extends zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly {
    override val streamingEndpointArn: ChatStreamingEndpointARN =
      zio.aws.connect.model.primitives
        .ChatStreamingEndpointARN(impl.streamingEndpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration
  ): zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
