package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  PhoneNumber,
  ClientToken,
  PhoneNumberDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ClaimPhoneNumberRequest(
    targetArn: ARN,
    phoneNumber: PhoneNumber,
    phoneNumberDescription: Optional[PhoneNumberDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest = {
    import ClaimPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest
      .builder()
      .targetArn(ARN.unwrap(targetArn): java.lang.String)
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .optionallyWith(
        phoneNumberDescription.map(value =>
          PhoneNumberDescription.unwrap(value): java.lang.String
        )
      )(_.phoneNumberDescription)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ClaimPhoneNumberRequest.ReadOnly =
    zio.aws.connect.model.ClaimPhoneNumberRequest.wrap(buildAwsValue())
}
object ClaimPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ClaimPhoneNumberRequest =
      zio.aws.connect.model.ClaimPhoneNumberRequest(
        targetArn,
        phoneNumber,
        phoneNumberDescription.map(value => value),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def targetArn: ARN
    def phoneNumber: PhoneNumber
    def phoneNumberDescription: Optional[PhoneNumberDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def getTargetArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(targetArn)
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
    def getPhoneNumberDescription: ZIO[Any, AwsError, PhoneNumberDescription] =
      AwsError.unwrapOptionField(
        "phoneNumberDescription",
        phoneNumberDescription
      )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest
  ) extends zio.aws.connect.model.ClaimPhoneNumberRequest.ReadOnly {
    override val targetArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.targetArn())
    override val phoneNumber: PhoneNumber =
      zio.aws.connect.model.primitives.PhoneNumber(impl.phoneNumber())
    override val phoneNumberDescription: Optional[PhoneNumberDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberDescription())
        .map(value =>
          zio.aws.connect.model.primitives.PhoneNumberDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest
  ): zio.aws.connect.model.ClaimPhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
