package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  Description,
  ContactId,
  Name,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Contact(
    arn: Optional[ARN] = Optional.Absent,
    id: Optional[ContactId] = Optional.Absent,
    initialContactId: Optional[ContactId] = Optional.Absent,
    previousContactId: Optional[ContactId] = Optional.Absent,
    initiationMethod: Optional[zio.aws.connect.model.ContactInitiationMethod] =
      Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    channel: Optional[zio.aws.connect.model.Channel] = Optional.Absent,
    queueInfo: Optional[zio.aws.connect.model.QueueInfo] = Optional.Absent,
    agentInfo: Optional[zio.aws.connect.model.AgentInfo] = Optional.Absent,
    initiationTimestamp: Optional[Timestamp] = Optional.Absent,
    disconnectTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent,
    scheduledTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Contact
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        id.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        initialContactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.initialContactId)
      .optionallyWith(
        previousContactId.map(value =>
          ContactId.unwrap(value): java.lang.String
        )
      )(_.previousContactId)
      .optionallyWith(initiationMethod.map(value => value.unwrap))(
        _.initiationMethod
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(channel.map(value => value.unwrap))(_.channel)
      .optionallyWith(queueInfo.map(value => value.buildAwsValue()))(
        _.queueInfo
      )
      .optionallyWith(agentInfo.map(value => value.buildAwsValue()))(
        _.agentInfo
      )
      .optionallyWith(
        initiationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.initiationTimestamp)
      .optionallyWith(
        disconnectTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.disconnectTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        scheduledTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Contact.ReadOnly =
    zio.aws.connect.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Contact] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Contact =
      zio.aws.connect.model.Contact(
        arn.map(value => value),
        id.map(value => value),
        initialContactId.map(value => value),
        previousContactId.map(value => value),
        initiationMethod.map(value => value),
        name.map(value => value),
        description.map(value => value),
        channel.map(value => value),
        queueInfo.map(value => value.asEditable),
        agentInfo.map(value => value.asEditable),
        initiationTimestamp.map(value => value),
        disconnectTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        scheduledTimestamp.map(value => value)
      )
    def arn: Optional[ARN]
    def id: Optional[ContactId]
    def initialContactId: Optional[ContactId]
    def previousContactId: Optional[ContactId]
    def initiationMethod
        : Optional[zio.aws.connect.model.ContactInitiationMethod]
    def name: Optional[Name]
    def description: Optional[Description]
    def channel: Optional[zio.aws.connect.model.Channel]
    def queueInfo: Optional[zio.aws.connect.model.QueueInfo.ReadOnly]
    def agentInfo: Optional[zio.aws.connect.model.AgentInfo.ReadOnly]
    def initiationTimestamp: Optional[Timestamp]
    def disconnectTimestamp: Optional[Timestamp]
    def lastUpdateTimestamp: Optional[Timestamp]
    def scheduledTimestamp: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("id", id)
    def getInitialContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("initialContactId", initialContactId)
    def getPreviousContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("previousContactId", previousContactId)
    def getInitiationMethod
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactInitiationMethod] =
      AwsError.unwrapOptionField("initiationMethod", initiationMethod)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getChannel: ZIO[Any, AwsError, zio.aws.connect.model.Channel] =
      AwsError.unwrapOptionField("channel", channel)
    def getQueueInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.QueueInfo.ReadOnly] =
      AwsError.unwrapOptionField("queueInfo", queueInfo)
    def getAgentInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentInfo.ReadOnly] =
      AwsError.unwrapOptionField("agentInfo", agentInfo)
    def getInitiationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("initiationTimestamp", initiationTimestamp)
    def getDisconnectTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("disconnectTimestamp", disconnectTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getScheduledTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimestamp", scheduledTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Contact
  ) extends zio.aws.connect.model.Contact.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val id: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val initialContactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.initialContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val previousContactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.previousContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val initiationMethod
        : Optional[zio.aws.connect.model.ContactInitiationMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiationMethod())
        .map(value => zio.aws.connect.model.ContactInitiationMethod.wrap(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description(value))
    override val channel: Optional[zio.aws.connect.model.Channel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.connect.model.Channel.wrap(value))
    override val queueInfo: Optional[zio.aws.connect.model.QueueInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueInfo())
        .map(value => zio.aws.connect.model.QueueInfo.wrap(value))
    override val agentInfo: Optional[zio.aws.connect.model.AgentInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentInfo())
        .map(value => zio.aws.connect.model.AgentInfo.wrap(value))
    override val initiationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiationTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val disconnectTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val scheduledTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Contact
  ): zio.aws.connect.model.Contact.ReadOnly = new Wrapper(impl)
}
