package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContactFilter(
    contactStates: Optional[Iterable[zio.aws.connect.model.ContactState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFilter = {
    import ContactFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFilter
      .builder()
      .optionallyWith(
        contactStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactStatesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFilter.ReadOnly =
    zio.aws.connect.model.ContactFilter.wrap(buildAwsValue())
}
object ContactFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFilter =
      zio.aws.connect.model.ContactFilter(contactStates.map(value => value))
    def contactStates: Optional[List[zio.aws.connect.model.ContactState]]
    def getContactStates
        : ZIO[Any, AwsError, List[zio.aws.connect.model.ContactState]] =
      AwsError.unwrapOptionField("contactStates", contactStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFilter
  ) extends zio.aws.connect.model.ContactFilter.ReadOnly {
    override val contactStates
        : Optional[List[zio.aws.connect.model.ContactState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ContactState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFilter
  ): zio.aws.connect.model.ContactFilter.ReadOnly = new Wrapper(impl)
}
