package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ContactFlowDescription,
  TagValue,
  ContactFlowName,
  ContactFlowContent,
  ContactFlowId,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ContactFlow(
    arn: Optional[ARN] = Optional.Absent,
    id: Optional[ContactFlowId] = Optional.Absent,
    name: Optional[ContactFlowName] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.ContactFlowType] = Optional.Absent,
    state: Optional[zio.aws.connect.model.ContactFlowState] = Optional.Absent,
    description: Optional[ContactFlowDescription] = Optional.Absent,
    content: Optional[ContactFlowContent] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlow = {
    import ContactFlow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlow
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        id.map(value => ContactFlowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ContactFlowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          ContactFlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        content.map(value => ContactFlowContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlow.ReadOnly =
    zio.aws.connect.model.ContactFlow.wrap(buildAwsValue())
}
object ContactFlow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlow =
      zio.aws.connect.model.ContactFlow(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        description.map(value => value),
        content.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ARN]
    def id: Optional[ContactFlowId]
    def name: Optional[ContactFlowName]
    def `type`: Optional[zio.aws.connect.model.ContactFlowType]
    def state: Optional[zio.aws.connect.model.ContactFlowState]
    def description: Optional[ContactFlowDescription]
    def content: Optional[ContactFlowContent]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ContactFlowName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, ContactFlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, AwsError, ContactFlowContent] =
      AwsError.unwrapOptionField("content", content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlow
  ) extends zio.aws.connect.model.ContactFlow.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val id: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val name: Optional[ContactFlowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ContactFlowName(value))
    override val `type`: Optional[zio.aws.connect.model.ContactFlowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.ContactFlowType.wrap(value))
    override val state: Optional[zio.aws.connect.model.ContactFlowState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.ContactFlowState.wrap(value))
    override val description: Optional[ContactFlowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.ContactFlowDescription(value)
        )
    override val content: Optional[ContactFlowContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.connect.model.primitives.ContactFlowContent(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlow
  ): zio.aws.connect.model.ContactFlow.ReadOnly = new Wrapper(impl)
}
