package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ControlPlaneTagFilter(
    orConditions: Optional[
      Iterable[Iterable[zio.aws.connect.model.TagCondition]]
    ] = Optional.Absent,
    andConditions: Optional[Iterable[zio.aws.connect.model.TagCondition]] =
      Optional.Absent,
    tagCondition: Optional[zio.aws.connect.model.TagCondition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter = {
    import ControlPlaneTagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter
      .builder()
      .optionallyWith(
        orConditions.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.orConditions)
      .optionallyWith(
        andConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andConditions)
      .optionallyWith(tagCondition.map(value => value.buildAwsValue()))(
        _.tagCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly =
    zio.aws.connect.model.ControlPlaneTagFilter.wrap(buildAwsValue())
}
object ControlPlaneTagFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ControlPlaneTagFilter =
      zio.aws.connect.model.ControlPlaneTagFilter(
        orConditions.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        andConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagCondition.map(value => value.asEditable)
      )
    def orConditions
        : Optional[List[List[zio.aws.connect.model.TagCondition.ReadOnly]]]
    def andConditions
        : Optional[List[zio.aws.connect.model.TagCondition.ReadOnly]]
    def tagCondition: Optional[zio.aws.connect.model.TagCondition.ReadOnly]
    def getOrConditions: ZIO[Any, AwsError, List[
      List[zio.aws.connect.model.TagCondition.ReadOnly]
    ]] = AwsError.unwrapOptionField("orConditions", orConditions)
    def getAndConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TagCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("andConditions", andConditions)
    def getTagCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.TagCondition.ReadOnly] =
      AwsError.unwrapOptionField("tagCondition", tagCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter
  ) extends zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly {
    override val orConditions
        : Optional[List[List[zio.aws.connect.model.TagCondition.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orConditions())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.connect.model.TagCondition.wrap(item)
            }.toList
          }.toList
        )
    override val andConditions
        : Optional[List[zio.aws.connect.model.TagCondition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.TagCondition.wrap(item)
          }.toList
        )
    override val tagCondition
        : Optional[zio.aws.connect.model.TagCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagCondition())
        .map(value => zio.aws.connect.model.TagCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ControlPlaneTagFilter
  ): zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly = new Wrapper(impl)
}
