package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  InstanceId,
  TagValue,
  AgentStatusName,
  AgentStatusOrderNumber,
  AgentStatusDescription,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateAgentStatusRequest(
    instanceId: InstanceId,
    name: AgentStatusName,
    description: Optional[AgentStatusDescription] = Optional.Absent,
    state: zio.aws.connect.model.AgentStatusState,
    displayOrder: Optional[AgentStatusOrderNumber] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest = {
    import CreateAgentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(AgentStatusName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AgentStatusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .state(state.unwrap)
      .optionallyWith(
        displayOrder.map(value => AgentStatusOrderNumber.unwrap(value): Integer)
      )(_.displayOrder)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateAgentStatusRequest.ReadOnly =
    zio.aws.connect.model.CreateAgentStatusRequest.wrap(buildAwsValue())
}
object CreateAgentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateAgentStatusRequest =
      zio.aws.connect.model.CreateAgentStatusRequest(
        instanceId,
        name,
        description.map(value => value),
        state,
        displayOrder.map(value => value),
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: AgentStatusName
    def description: Optional[AgentStatusDescription]
    def state: zio.aws.connect.model.AgentStatusState
    def displayOrder: Optional[AgentStatusOrderNumber]
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, AgentStatusName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, AgentStatusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, Nothing, zio.aws.connect.model.AgentStatusState] =
      ZIO.succeed(state)
    def getDisplayOrder: ZIO[Any, AwsError, AgentStatusOrderNumber] =
      AwsError.unwrapOptionField("displayOrder", displayOrder)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest
  ) extends zio.aws.connect.model.CreateAgentStatusRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: AgentStatusName =
      zio.aws.connect.model.primitives.AgentStatusName(impl.name())
    override val description: Optional[AgentStatusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.AgentStatusDescription(value)
        )
    override val state: zio.aws.connect.model.AgentStatusState =
      zio.aws.connect.model.AgentStatusState.wrap(impl.state())
    override val displayOrder: Optional[AgentStatusOrderNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayOrder())
        .map(value =>
          zio.aws.connect.model.primitives.AgentStatusOrderNumber(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest
  ): zio.aws.connect.model.CreateAgentStatusRequest.ReadOnly = new Wrapper(impl)
}
