package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  DirectoryAlias,
  InboundCallsEnabled,
  ClientToken,
  OutboundCallsEnabled,
  DirectoryId
}
import scala.jdk.CollectionConverters._
final case class CreateInstanceRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    identityManagementType: zio.aws.connect.model.DirectoryType,
    instanceAlias: Optional[DirectoryAlias] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    inboundCallsEnabled: InboundCallsEnabled,
    outboundCallsEnabled: OutboundCallsEnabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateInstanceRequest = {
    import CreateInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateInstanceRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identityManagementType(identityManagementType.unwrap)
      .optionallyWith(
        instanceAlias.map(value =>
          DirectoryAlias.unwrap(value): java.lang.String
        )
      )(_.instanceAlias)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .inboundCallsEnabled(
        InboundCallsEnabled.unwrap(inboundCallsEnabled): java.lang.Boolean
      )
      .outboundCallsEnabled(
        OutboundCallsEnabled.unwrap(outboundCallsEnabled): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateInstanceRequest.ReadOnly =
    zio.aws.connect.model.CreateInstanceRequest.wrap(buildAwsValue())
}
object CreateInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateInstanceRequest =
      zio.aws.connect.model.CreateInstanceRequest(
        clientToken.map(value => value),
        identityManagementType,
        instanceAlias.map(value => value),
        directoryId.map(value => value),
        inboundCallsEnabled,
        outboundCallsEnabled
      )
    def clientToken: Optional[ClientToken]
    def identityManagementType: zio.aws.connect.model.DirectoryType
    def instanceAlias: Optional[DirectoryAlias]
    def directoryId: Optional[DirectoryId]
    def inboundCallsEnabled: InboundCallsEnabled
    def outboundCallsEnabled: OutboundCallsEnabled
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentityManagementType
        : ZIO[Any, Nothing, zio.aws.connect.model.DirectoryType] =
      ZIO.succeed(identityManagementType)
    def getInstanceAlias: ZIO[Any, AwsError, DirectoryAlias] =
      AwsError.unwrapOptionField("instanceAlias", instanceAlias)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getInboundCallsEnabled: ZIO[Any, Nothing, InboundCallsEnabled] =
      ZIO.succeed(inboundCallsEnabled)
    def getOutboundCallsEnabled: ZIO[Any, Nothing, OutboundCallsEnabled] =
      ZIO.succeed(outboundCallsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateInstanceRequest
  ) extends zio.aws.connect.model.CreateInstanceRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val identityManagementType: zio.aws.connect.model.DirectoryType =
      zio.aws.connect.model.DirectoryType.wrap(impl.identityManagementType())
    override val instanceAlias: Optional[DirectoryAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAlias())
      .map(value => zio.aws.connect.model.primitives.DirectoryAlias(value))
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.connect.model.primitives.DirectoryId(value))
    override val inboundCallsEnabled: InboundCallsEnabled =
      zio.aws.connect.model.primitives
        .InboundCallsEnabled(impl.inboundCallsEnabled())
    override val outboundCallsEnabled: OutboundCallsEnabled =
      zio.aws.connect.model.primitives
        .OutboundCallsEnabled(impl.outboundCallsEnabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateInstanceRequest
  ): zio.aws.connect.model.CreateInstanceRequest.ReadOnly = new Wrapper(impl)
}
