package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, IntegrationAssociationId}
import scala.jdk.CollectionConverters._
final case class CreateIntegrationAssociationResponse(
    integrationAssociationId: Optional[IntegrationAssociationId] =
      Optional.Absent,
    integrationAssociationArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse = {
    import CreateIntegrationAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse
      .builder()
      .optionallyWith(
        integrationAssociationId.map(value =>
          IntegrationAssociationId.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationId)
      .optionallyWith(
        integrationAssociationArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly =
    zio.aws.connect.model.CreateIntegrationAssociationResponse
      .wrap(buildAwsValue())
}
object CreateIntegrationAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateIntegrationAssociationResponse =
      zio.aws.connect.model.CreateIntegrationAssociationResponse(
        integrationAssociationId.map(value => value),
        integrationAssociationArn.map(value => value)
      )
    def integrationAssociationId: Optional[IntegrationAssociationId]
    def integrationAssociationArn: Optional[ARN]
    def getIntegrationAssociationId
        : ZIO[Any, AwsError, IntegrationAssociationId] = AwsError
      .unwrapOptionField("integrationAssociationId", integrationAssociationId)
    def getIntegrationAssociationArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("integrationAssociationArn", integrationAssociationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse
  ) extends zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly {
    override val integrationAssociationId: Optional[IntegrationAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationAssociationId())
        .map(value =>
          zio.aws.connect.model.primitives.IntegrationAssociationId(value)
        )
    override val integrationAssociationArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationAssociationArn())
        .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse
  ): zio.aws.connect.model.CreateIntegrationAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
