package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SecurityProfileDescription,
  SecurityProfilePermission,
  InstanceId,
  TagValue,
  SecurityProfileName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    description: Optional[SecurityProfileDescription] = Optional.Absent,
    permissions: Optional[Iterable[SecurityProfilePermission]] =
      Optional.Absent,
    instanceId: InstanceId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest = {
    import CreateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.CreateSecurityProfileRequest.wrap(buildAwsValue())
}
object CreateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateSecurityProfileRequest =
      zio.aws.connect.model.CreateSecurityProfileRequest(
        securityProfileName,
        description.map(value => value),
        permissions.map(value => value),
        instanceId,
        tags.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def description: Optional[SecurityProfileDescription]
    def permissions: Optional[List[SecurityProfilePermission]]
    def instanceId: InstanceId
    def tags: Optional[Map[TagKey, TagValue]]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ) extends zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.connect.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val description: Optional[SecurityProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileDescription(value)
        )
    override val permissions: Optional[List[SecurityProfilePermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.SecurityProfilePermission(item)
          }.toList
        )
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ): zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
