package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TaskTemplateDescription,
  InstanceId,
  ClientToken,
  TaskTemplateName,
  ContactFlowId
}
import scala.jdk.CollectionConverters._
final case class CreateTaskTemplateRequest(
    instanceId: InstanceId,
    name: TaskTemplateName,
    description: Optional[TaskTemplateDescription] = Optional.Absent,
    contactFlowId: Optional[ContactFlowId] = Optional.Absent,
    constraints: Optional[zio.aws.connect.model.TaskTemplateConstraints] =
      Optional.Absent,
    defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults] =
      Optional.Absent,
    status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      Optional.Absent,
    fields: Iterable[zio.aws.connect.model.TaskTemplateField],
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest = {
    import CreateTaskTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(TaskTemplateName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          TaskTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        contactFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.contactFlowId)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(defaults.map(value => value.buildAwsValue()))(_.defaults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateTaskTemplateRequest.ReadOnly =
    zio.aws.connect.model.CreateTaskTemplateRequest.wrap(buildAwsValue())
}
object CreateTaskTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateTaskTemplateRequest =
      zio.aws.connect.model.CreateTaskTemplateRequest(
        instanceId,
        name,
        description.map(value => value),
        contactFlowId.map(value => value),
        constraints.map(value => value.asEditable),
        defaults.map(value => value.asEditable),
        status.map(value => value),
        fields.map { item =>
          item.asEditable
        },
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def name: TaskTemplateName
    def description: Optional[TaskTemplateDescription]
    def contactFlowId: Optional[ContactFlowId]
    def constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly]
    def defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly]
    def status: Optional[zio.aws.connect.model.TaskTemplateStatus]
    def fields: List[zio.aws.connect.model.TaskTemplateField.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, TaskTemplateName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, TaskTemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContactFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("contactFlowId", contactFlowId)
    def getConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("constraints", constraints)
    def getDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("defaults", defaults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connect.model.TaskTemplateField.ReadOnly
    ]] = ZIO.succeed(fields)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest
  ) extends zio.aws.connect.model.CreateTaskTemplateRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: TaskTemplateName =
      zio.aws.connect.model.primitives.TaskTemplateName(impl.name())
    override val description: Optional[TaskTemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateDescription(value)
        )
    override val contactFlowId: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.connect.model.TaskTemplateConstraints.wrap(value))
    override val defaults
        : Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaults())
        .map(value => zio.aws.connect.model.TaskTemplateDefaults.wrap(value))
    override val status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.TaskTemplateStatus.wrap(value))
    override val fields
        : List[zio.aws.connect.model.TaskTemplateField.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.connect.model.TaskTemplateField.wrap(item)
      }
      .toList
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest
  ): zio.aws.connect.model.CreateTaskTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
