package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TrafficDistributionGroupArn,
  TrafficDistributionGroupId
}
import scala.jdk.CollectionConverters._
final case class CreateTrafficDistributionGroupResponse(
    id: Optional[TrafficDistributionGroupId] = Optional.Absent,
    arn: Optional[TrafficDistributionGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse = {
    import CreateTrafficDistributionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse
      .builder()
      .optionallyWith(
        id.map(value =>
          TrafficDistributionGroupId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          TrafficDistributionGroupArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly =
    zio.aws.connect.model.CreateTrafficDistributionGroupResponse
      .wrap(buildAwsValue())
}
object CreateTrafficDistributionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.CreateTrafficDistributionGroupResponse =
      zio.aws.connect.model.CreateTrafficDistributionGroupResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[TrafficDistributionGroupId]
    def arn: Optional[TrafficDistributionGroupArn]
    def getId: ZIO[Any, AwsError, TrafficDistributionGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TrafficDistributionGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse
  ) extends zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly {
    override val id: Optional[TrafficDistributionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupId(value)
        )
    override val arn: Optional[TrafficDistributionGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse
  ): zio.aws.connect.model.CreateTrafficDistributionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
