package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, HierarchyGroupId}
import scala.jdk.CollectionConverters._
final case class CreateUserHierarchyGroupResponse(
    hierarchyGroupId: Optional[HierarchyGroupId] = Optional.Absent,
    hierarchyGroupArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse = {
    import CreateUserHierarchyGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse
      .builder()
      .optionallyWith(
        hierarchyGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.hierarchyGroupId)
      .optionallyWith(
        hierarchyGroupArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.hierarchyGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly =
    zio.aws.connect.model.CreateUserHierarchyGroupResponse.wrap(buildAwsValue())
}
object CreateUserHierarchyGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUserHierarchyGroupResponse =
      zio.aws.connect.model.CreateUserHierarchyGroupResponse(
        hierarchyGroupId.map(value => value),
        hierarchyGroupArn.map(value => value)
      )
    def hierarchyGroupId: Optional[HierarchyGroupId]
    def hierarchyGroupArn: Optional[ARN]
    def getHierarchyGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("hierarchyGroupId", hierarchyGroupId)
    def getHierarchyGroupArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("hierarchyGroupArn", hierarchyGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse
  ) extends zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly {
    override val hierarchyGroupId: Optional[HierarchyGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupId())
        .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val hierarchyGroupArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.hierarchyGroupArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse
  ): zio.aws.connect.model.CreateUserHierarchyGroupResponse.ReadOnly =
    new Wrapper(impl)
}
