package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  RoutingProfileId,
  InstanceId,
  TagValue,
  DirectoryUserId,
  Password,
  HierarchyGroupId,
  AgentUsername,
  TagKey,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class CreateUserRequest(
    username: AgentUsername,
    password: Optional[Password] = Optional.Absent,
    identityInfo: Optional[zio.aws.connect.model.UserIdentityInfo] =
      Optional.Absent,
    phoneConfig: zio.aws.connect.model.UserPhoneConfig,
    directoryUserId: Optional[DirectoryUserId] = Optional.Absent,
    securityProfileIds: Iterable[SecurityProfileId],
    routingProfileId: RoutingProfileId,
    hierarchyGroupId: Optional[HierarchyGroupId] = Optional.Absent,
    instanceId: InstanceId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUserRequest
      .builder()
      .username(AgentUsername.unwrap(username): java.lang.String)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(identityInfo.map(value => value.buildAwsValue()))(
        _.identityInfo
      )
      .phoneConfig(phoneConfig.buildAwsValue())
      .optionallyWith(
        directoryUserId.map(value =>
          DirectoryUserId.unwrap(value): java.lang.String
        )
      )(_.directoryUserId)
      .securityProfileIds(securityProfileIds.map { item =>
        SecurityProfileId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .optionallyWith(
        hierarchyGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.hierarchyGroupId)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateUserRequest.ReadOnly =
    zio.aws.connect.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUserRequest =
      zio.aws.connect.model.CreateUserRequest(
        username,
        password.map(value => value),
        identityInfo.map(value => value.asEditable),
        phoneConfig.asEditable,
        directoryUserId.map(value => value),
        securityProfileIds,
        routingProfileId,
        hierarchyGroupId.map(value => value),
        instanceId,
        tags.map(value => value)
      )
    def username: AgentUsername
    def password: Optional[Password]
    def identityInfo: Optional[zio.aws.connect.model.UserIdentityInfo.ReadOnly]
    def phoneConfig: zio.aws.connect.model.UserPhoneConfig.ReadOnly
    def directoryUserId: Optional[DirectoryUserId]
    def securityProfileIds: List[SecurityProfileId]
    def routingProfileId: RoutingProfileId
    def hierarchyGroupId: Optional[HierarchyGroupId]
    def instanceId: InstanceId
    def tags: Optional[Map[TagKey, TagValue]]
    def getUsername: ZIO[Any, Nothing, AgentUsername] = ZIO.succeed(username)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getIdentityInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.UserIdentityInfo.ReadOnly] =
      AwsError.unwrapOptionField("identityInfo", identityInfo)
    def getPhoneConfig
        : ZIO[Any, Nothing, zio.aws.connect.model.UserPhoneConfig.ReadOnly] =
      ZIO.succeed(phoneConfig)
    def getDirectoryUserId: ZIO[Any, AwsError, DirectoryUserId] =
      AwsError.unwrapOptionField("directoryUserId", directoryUserId)
    def getSecurityProfileIds: ZIO[Any, Nothing, List[SecurityProfileId]] =
      ZIO.succeed(securityProfileIds)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getHierarchyGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("hierarchyGroupId", hierarchyGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUserRequest
  ) extends zio.aws.connect.model.CreateUserRequest.ReadOnly {
    override val username: AgentUsername =
      zio.aws.connect.model.primitives.AgentUsername(impl.username())
    override val password: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.connect.model.primitives.Password(value))
    override val identityInfo
        : Optional[zio.aws.connect.model.UserIdentityInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityInfo())
        .map(value => zio.aws.connect.model.UserIdentityInfo.wrap(value))
    override val phoneConfig: zio.aws.connect.model.UserPhoneConfig.ReadOnly =
      zio.aws.connect.model.UserPhoneConfig.wrap(impl.phoneConfig())
    override val directoryUserId: Optional[DirectoryUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryUserId())
        .map(value => zio.aws.connect.model.primitives.DirectoryUserId(value))
    override val securityProfileIds: List[SecurityProfileId] = impl
      .securityProfileIds()
      .asScala
      .map { item =>
        zio.aws.connect.model.primitives.SecurityProfileId(item)
      }
      .toList
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val hierarchyGroupId: Optional[HierarchyGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupId())
        .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUserRequest
  ): zio.aws.connect.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
