package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, UserId}
import scala.jdk.CollectionConverters._
final case class CreateUserResponse(
    userId: Optional[UserId] = Optional.Absent,
    userArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        userArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateUserResponse.ReadOnly =
    zio.aws.connect.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUserResponse =
      zio.aws.connect.model.CreateUserResponse(
        userId.map(value => value),
        userArn.map(value => value)
      )
    def userId: Optional[UserId]
    def userArn: Optional[ARN]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUserResponse
  ) extends zio.aws.connect.model.CreateUserResponse.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.connect.model.primitives.UserId(value))
    override val userArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUserResponse
  ): zio.aws.connect.model.CreateUserResponse.ReadOnly = new Wrapper(impl)
}
