package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  InstanceId,
  VocabularyContent,
  TagValue,
  ClientToken,
  VocabularyName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateVocabularyRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    instanceId: InstanceId,
    vocabularyName: VocabularyName,
    languageCode: zio.aws.connect.model.VocabularyLanguageCode,
    content: VocabularyContent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateVocabularyRequest = {
    import CreateVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateVocabularyRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .content(VocabularyContent.unwrap(content): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateVocabularyRequest.ReadOnly =
    zio.aws.connect.model.CreateVocabularyRequest.wrap(buildAwsValue())
}
object CreateVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateVocabularyRequest =
      zio.aws.connect.model.CreateVocabularyRequest(
        clientToken.map(value => value),
        instanceId,
        vocabularyName,
        languageCode,
        content,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def instanceId: InstanceId
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.connect.model.VocabularyLanguageCode
    def content: VocabularyContent
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.connect.model.VocabularyLanguageCode] =
      ZIO.succeed(languageCode)
    def getContent: ZIO[Any, Nothing, VocabularyContent] = ZIO.succeed(content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateVocabularyRequest
  ) extends zio.aws.connect.model.CreateVocabularyRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val vocabularyName: VocabularyName =
      zio.aws.connect.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.connect.model.VocabularyLanguageCode =
      zio.aws.connect.model.VocabularyLanguageCode.wrap(impl.languageCode())
    override val content: VocabularyContent =
      zio.aws.connect.model.primitives.VocabularyContent(impl.content())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateVocabularyRequest
  ): zio.aws.connect.model.CreateVocabularyRequest.ReadOnly = new Wrapper(impl)
}
