package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  VocabularyName,
  VocabularyId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class DefaultVocabulary(
    instanceId: InstanceId,
    languageCode: zio.aws.connect.model.VocabularyLanguageCode,
    vocabularyId: VocabularyId,
    vocabularyName: VocabularyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DefaultVocabulary = {
    import DefaultVocabulary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DefaultVocabulary
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .languageCode(languageCode.unwrap)
      .vocabularyId(VocabularyId.unwrap(vocabularyId): java.lang.String)
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DefaultVocabulary.ReadOnly =
    zio.aws.connect.model.DefaultVocabulary.wrap(buildAwsValue())
}
object DefaultVocabulary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DefaultVocabulary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DefaultVocabulary =
      zio.aws.connect.model.DefaultVocabulary(
        instanceId,
        languageCode,
        vocabularyId,
        vocabularyName
      )
    def instanceId: InstanceId
    def languageCode: zio.aws.connect.model.VocabularyLanguageCode
    def vocabularyId: VocabularyId
    def vocabularyName: VocabularyName
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.connect.model.VocabularyLanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyId: ZIO[Any, Nothing, VocabularyId] =
      ZIO.succeed(vocabularyId)
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DefaultVocabulary
  ) extends zio.aws.connect.model.DefaultVocabulary.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val languageCode: zio.aws.connect.model.VocabularyLanguageCode =
      zio.aws.connect.model.VocabularyLanguageCode.wrap(impl.languageCode())
    override val vocabularyId: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.vocabularyId())
    override val vocabularyName: VocabularyName =
      zio.aws.connect.model.primitives.VocabularyName(impl.vocabularyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DefaultVocabulary
  ): zio.aws.connect.model.DefaultVocabulary.ReadOnly = new Wrapper(impl)
}
