package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  UseCaseId,
  IntegrationAssociationId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class DeleteUseCaseRequest(
    instanceId: InstanceId,
    integrationAssociationId: IntegrationAssociationId,
    useCaseId: UseCaseId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest = {
    import DeleteUseCaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .integrationAssociationId(
        IntegrationAssociationId.unwrap(
          integrationAssociationId
        ): java.lang.String
      )
      .useCaseId(UseCaseId.unwrap(useCaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteUseCaseRequest.ReadOnly =
    zio.aws.connect.model.DeleteUseCaseRequest.wrap(buildAwsValue())
}
object DeleteUseCaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteUseCaseRequest =
      zio.aws.connect.model
        .DeleteUseCaseRequest(instanceId, integrationAssociationId, useCaseId)
    def instanceId: InstanceId
    def integrationAssociationId: IntegrationAssociationId
    def useCaseId: UseCaseId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationAssociationId
        : ZIO[Any, Nothing, IntegrationAssociationId] =
      ZIO.succeed(integrationAssociationId)
    def getUseCaseId: ZIO[Any, Nothing, UseCaseId] = ZIO.succeed(useCaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest
  ) extends zio.aws.connect.model.DeleteUseCaseRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationAssociationId: IntegrationAssociationId =
      zio.aws.connect.model.primitives
        .IntegrationAssociationId(impl.integrationAssociationId())
    override val useCaseId: UseCaseId =
      zio.aws.connect.model.primitives.UseCaseId(impl.useCaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest
  ): zio.aws.connect.model.DeleteUseCaseRequest.ReadOnly = new Wrapper(impl)
}
