package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{AgentStatusId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeAgentStatusRequest(
    instanceId: InstanceId,
    agentStatusId: AgentStatusId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest = {
    import DescribeAgentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .agentStatusId(AgentStatusId.unwrap(agentStatusId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeAgentStatusRequest.ReadOnly =
    zio.aws.connect.model.DescribeAgentStatusRequest.wrap(buildAwsValue())
}
object DescribeAgentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeAgentStatusRequest =
      zio.aws.connect.model
        .DescribeAgentStatusRequest(instanceId, agentStatusId)
    def instanceId: InstanceId
    def agentStatusId: AgentStatusId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAgentStatusId: ZIO[Any, Nothing, AgentStatusId] =
      ZIO.succeed(agentStatusId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest
  ) extends zio.aws.connect.model.DescribeAgentStatusRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val agentStatusId: AgentStatusId =
      zio.aws.connect.model.primitives.AgentStatusId(impl.agentStatusId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest
  ): zio.aws.connect.model.DescribeAgentStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
