package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeContactFlowResponse(
    contactFlow: Optional[zio.aws.connect.model.ContactFlow] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse = {
    import DescribeContactFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse
      .builder()
      .optionallyWith(contactFlow.map(value => value.buildAwsValue()))(
        _.contactFlow
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly =
    zio.aws.connect.model.DescribeContactFlowResponse.wrap(buildAwsValue())
}
object DescribeContactFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactFlowResponse =
      zio.aws.connect.model
        .DescribeContactFlowResponse(contactFlow.map(value => value.asEditable))
    def contactFlow: Optional[zio.aws.connect.model.ContactFlow.ReadOnly]
    def getContactFlow
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlow.ReadOnly] =
      AwsError.unwrapOptionField("contactFlow", contactFlow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse
  ) extends zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly {
    override val contactFlow
        : Optional[zio.aws.connect.model.ContactFlow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactFlow())
        .map(value => zio.aws.connect.model.ContactFlow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse
  ): zio.aws.connect.model.DescribeContactFlowResponse.ReadOnly = new Wrapper(
    impl
  )
}
