package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{HoursOfOperationId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeHoursOfOperationRequest(
    instanceId: InstanceId,
    hoursOfOperationId: HoursOfOperationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest = {
    import DescribeHoursOfOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .hoursOfOperationId(
        HoursOfOperationId.unwrap(hoursOfOperationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeHoursOfOperationRequest.ReadOnly =
    zio.aws.connect.model.DescribeHoursOfOperationRequest.wrap(buildAwsValue())
}
object DescribeHoursOfOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeHoursOfOperationRequest =
      zio.aws.connect.model
        .DescribeHoursOfOperationRequest(instanceId, hoursOfOperationId)
    def instanceId: InstanceId
    def hoursOfOperationId: HoursOfOperationId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getHoursOfOperationId: ZIO[Any, Nothing, HoursOfOperationId] =
      ZIO.succeed(hoursOfOperationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest
  ) extends zio.aws.connect.model.DescribeHoursOfOperationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val hoursOfOperationId: HoursOfOperationId =
      zio.aws.connect.model.primitives
        .HoursOfOperationId(impl.hoursOfOperationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest
  ): zio.aws.connect.model.DescribeHoursOfOperationRequest.ReadOnly =
    new Wrapper(impl)
}
