package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHoursOfOperationResponse(
    hoursOfOperation: Optional[zio.aws.connect.model.HoursOfOperation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse = {
    import DescribeHoursOfOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse
      .builder()
      .optionallyWith(hoursOfOperation.map(value => value.buildAwsValue()))(
        _.hoursOfOperation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly =
    zio.aws.connect.model.DescribeHoursOfOperationResponse.wrap(buildAwsValue())
}
object DescribeHoursOfOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeHoursOfOperationResponse =
      zio.aws.connect.model.DescribeHoursOfOperationResponse(
        hoursOfOperation.map(value => value.asEditable)
      )
    def hoursOfOperation
        : Optional[zio.aws.connect.model.HoursOfOperation.ReadOnly]
    def getHoursOfOperation
        : ZIO[Any, AwsError, zio.aws.connect.model.HoursOfOperation.ReadOnly] =
      AwsError.unwrapOptionField("hoursOfOperation", hoursOfOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse
  ) extends zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly {
    override val hoursOfOperation
        : Optional[zio.aws.connect.model.HoursOfOperation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hoursOfOperation())
        .map(value => zio.aws.connect.model.HoursOfOperation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse
  ): zio.aws.connect.model.DescribeHoursOfOperationResponse.ReadOnly =
    new Wrapper(impl)
}
