package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAttributeResponse(
    attribute: Optional[zio.aws.connect.model.Attribute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse = {
    import DescribeInstanceAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse
      .builder()
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly =
    zio.aws.connect.model.DescribeInstanceAttributeResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeInstanceAttributeResponse =
      zio.aws.connect.model.DescribeInstanceAttributeResponse(
        attribute.map(value => value.asEditable)
      )
    def attribute: Optional[zio.aws.connect.model.Attribute.ReadOnly]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.connect.model.Attribute.ReadOnly] =
      AwsError.unwrapOptionField("attribute", attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse
  ) extends zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly {
    override val attribute: Optional[zio.aws.connect.model.Attribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.connect.model.Attribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse
  ): zio.aws.connect.model.DescribeInstanceAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
