package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceResponse(
    instance: Optional[zio.aws.connect.model.Instance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeInstanceResponse = {
    import DescribeInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeInstanceResponse
      .builder()
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeInstanceResponse.ReadOnly =
    zio.aws.connect.model.DescribeInstanceResponse.wrap(buildAwsValue())
}
object DescribeInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeInstanceResponse =
      zio.aws.connect.model
        .DescribeInstanceResponse(instance.map(value => value.asEditable))
    def instance: Optional[zio.aws.connect.model.Instance.ReadOnly]
    def getInstance
        : ZIO[Any, AwsError, zio.aws.connect.model.Instance.ReadOnly] =
      AwsError.unwrapOptionField("instance", instance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceResponse
  ) extends zio.aws.connect.model.DescribeInstanceResponse.ReadOnly {
    override val instance: Optional[zio.aws.connect.model.Instance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instance())
        .map(value => zio.aws.connect.model.Instance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceResponse
  ): zio.aws.connect.model.DescribeInstanceResponse.ReadOnly = new Wrapper(impl)
}
