package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.PhoneNumberId
import scala.jdk.CollectionConverters._
final case class DescribePhoneNumberRequest(phoneNumberId: PhoneNumberId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest = {
    import DescribePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest
      .builder()
      .phoneNumberId(PhoneNumberId.unwrap(phoneNumberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribePhoneNumberRequest.ReadOnly =
    zio.aws.connect.model.DescribePhoneNumberRequest.wrap(buildAwsValue())
}
object DescribePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribePhoneNumberRequest =
      zio.aws.connect.model.DescribePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: PhoneNumberId
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberId] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest
  ) extends zio.aws.connect.model.DescribePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberId =
      zio.aws.connect.model.primitives.PhoneNumberId(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest
  ): zio.aws.connect.model.DescribePhoneNumberRequest.ReadOnly = new Wrapper(
    impl
  )
}
