package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QuickConnectId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeQuickConnectRequest(
    instanceId: InstanceId,
    quickConnectId: QuickConnectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest = {
    import DescribeQuickConnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .quickConnectId(QuickConnectId.unwrap(quickConnectId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeQuickConnectRequest.ReadOnly =
    zio.aws.connect.model.DescribeQuickConnectRequest.wrap(buildAwsValue())
}
object DescribeQuickConnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeQuickConnectRequest =
      zio.aws.connect.model
        .DescribeQuickConnectRequest(instanceId, quickConnectId)
    def instanceId: InstanceId
    def quickConnectId: QuickConnectId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQuickConnectId: ZIO[Any, Nothing, QuickConnectId] =
      ZIO.succeed(quickConnectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest
  ) extends zio.aws.connect.model.DescribeQuickConnectRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val quickConnectId: QuickConnectId =
      zio.aws.connect.model.primitives.QuickConnectId(impl.quickConnectId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest
  ): zio.aws.connect.model.DescribeQuickConnectRequest.ReadOnly = new Wrapper(
    impl
  )
}
