package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSecurityProfileResponse(
    securityProfile: Optional[zio.aws.connect.model.SecurityProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse = {
    import DescribeSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse
      .builder()
      .optionallyWith(securityProfile.map(value => value.buildAwsValue()))(
        _.securityProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly =
    zio.aws.connect.model.DescribeSecurityProfileResponse.wrap(buildAwsValue())
}
object DescribeSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeSecurityProfileResponse =
      zio.aws.connect.model.DescribeSecurityProfileResponse(
        securityProfile.map(value => value.asEditable)
      )
    def securityProfile
        : Optional[zio.aws.connect.model.SecurityProfile.ReadOnly]
    def getSecurityProfile
        : ZIO[Any, AwsError, zio.aws.connect.model.SecurityProfile.ReadOnly] =
      AwsError.unwrapOptionField("securityProfile", securityProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse
  ) extends zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly {
    override val securityProfile
        : Optional[zio.aws.connect.model.SecurityProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfile())
        .map(value => zio.aws.connect.model.SecurityProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse
  ): zio.aws.connect.model.DescribeSecurityProfileResponse.ReadOnly =
    new Wrapper(impl)
}
