package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTrafficDistributionGroupResponse(
    trafficDistributionGroup: Optional[
      zio.aws.connect.model.TrafficDistributionGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse = {
    import DescribeTrafficDistributionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse
      .builder()
      .optionallyWith(
        trafficDistributionGroup.map(value => value.buildAwsValue())
      )(_.trafficDistributionGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly =
    zio.aws.connect.model.DescribeTrafficDistributionGroupResponse
      .wrap(buildAwsValue())
}
object DescribeTrafficDistributionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DescribeTrafficDistributionGroupResponse =
      zio.aws.connect.model.DescribeTrafficDistributionGroupResponse(
        trafficDistributionGroup.map(value => value.asEditable)
      )
    def trafficDistributionGroup
        : Optional[zio.aws.connect.model.TrafficDistributionGroup.ReadOnly]
    def getTrafficDistributionGroup: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TrafficDistributionGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trafficDistributionGroup",
      trafficDistributionGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse
  ) extends zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly {
    override val trafficDistributionGroup
        : Optional[zio.aws.connect.model.TrafficDistributionGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficDistributionGroup())
        .map(value =>
          zio.aws.connect.model.TrafficDistributionGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse
  ): zio.aws.connect.model.DescribeTrafficDistributionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
