package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, HierarchyGroupId}
import scala.jdk.CollectionConverters._
final case class DescribeUserHierarchyGroupRequest(
    hierarchyGroupId: HierarchyGroupId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest = {
    import DescribeUserHierarchyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest
      .builder()
      .hierarchyGroupId(
        HierarchyGroupId.unwrap(hierarchyGroupId): java.lang.String
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeUserHierarchyGroupRequest.ReadOnly =
    zio.aws.connect.model.DescribeUserHierarchyGroupRequest
      .wrap(buildAwsValue())
}
object DescribeUserHierarchyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeUserHierarchyGroupRequest =
      zio.aws.connect.model
        .DescribeUserHierarchyGroupRequest(hierarchyGroupId, instanceId)
    def hierarchyGroupId: HierarchyGroupId
    def instanceId: InstanceId
    def getHierarchyGroupId: ZIO[Any, Nothing, HierarchyGroupId] =
      ZIO.succeed(hierarchyGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest
  ) extends zio.aws.connect.model.DescribeUserHierarchyGroupRequest.ReadOnly {
    override val hierarchyGroupId: HierarchyGroupId =
      zio.aws.connect.model.primitives.HierarchyGroupId(impl.hierarchyGroupId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest
  ): zio.aws.connect.model.DescribeUserHierarchyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
