package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVocabularyResponse(
    vocabulary: zio.aws.connect.model.Vocabulary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse = {
    import DescribeVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse
      .builder()
      .vocabulary(vocabulary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly =
    zio.aws.connect.model.DescribeVocabularyResponse.wrap(buildAwsValue())
}
object DescribeVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeVocabularyResponse =
      zio.aws.connect.model.DescribeVocabularyResponse(vocabulary.asEditable)
    def vocabulary: zio.aws.connect.model.Vocabulary.ReadOnly
    def getVocabulary
        : ZIO[Any, Nothing, zio.aws.connect.model.Vocabulary.ReadOnly] =
      ZIO.succeed(vocabulary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse
  ) extends zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly {
    override val vocabulary: zio.aws.connect.model.Vocabulary.ReadOnly =
      zio.aws.connect.model.Vocabulary.wrap(impl.vocabulary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse
  ): zio.aws.connect.model.DescribeVocabularyResponse.ReadOnly = new Wrapper(
    impl
  )
}
