package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait DirectoryType {
  def unwrap: software.amazon.awssdk.services.connect.model.DirectoryType
}
object DirectoryType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.DirectoryType
  ): zio.aws.connect.model.DirectoryType = value match {
    case software.amazon.awssdk.services.connect.model.DirectoryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.DirectoryType.SAML =>
      val r = SAML
      r
    case software.amazon.awssdk.services.connect.model.DirectoryType.CONNECT_MANAGED =>
      val r = CONNECT_MANAGED
      r
    case software.amazon.awssdk.services.connect.model.DirectoryType.EXISTING_DIRECTORY =>
      val r = EXISTING_DIRECTORY
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.DirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.DirectoryType =
      software.amazon.awssdk.services.connect.model.DirectoryType.UNKNOWN_TO_SDK_VERSION
  }
  case object SAML extends zio.aws.connect.model.DirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.DirectoryType =
      software.amazon.awssdk.services.connect.model.DirectoryType.SAML
  }
  case object CONNECT_MANAGED extends zio.aws.connect.model.DirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.DirectoryType =
      software.amazon.awssdk.services.connect.model.DirectoryType.CONNECT_MANAGED
  }
  case object EXISTING_DIRECTORY extends zio.aws.connect.model.DirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.DirectoryType =
      software.amazon.awssdk.services.connect.model.DirectoryType.EXISTING_DIRECTORY
  }
}
