package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{AssociationId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateInstanceStorageConfigRequest(
    instanceId: InstanceId,
    associationId: AssociationId,
    resourceType: zio.aws.connect.model.InstanceStorageResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest = {
    import DisassociateInstanceStorageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateInstanceStorageConfigRequest.ReadOnly =
    zio.aws.connect.model.DisassociateInstanceStorageConfigRequest
      .wrap(buildAwsValue())
}
object DisassociateInstanceStorageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DisassociateInstanceStorageConfigRequest =
      zio.aws.connect.model.DisassociateInstanceStorageConfigRequest(
        instanceId,
        associationId,
        resourceType
      )
    def instanceId: InstanceId
    def associationId: AssociationId
    def resourceType: zio.aws.connect.model.InstanceStorageResourceType
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceStorageResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest
  ) extends zio.aws.connect.model.DisassociateInstanceStorageConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val associationId: AssociationId =
      zio.aws.connect.model.primitives.AssociationId(impl.associationId())
    override val resourceType
        : zio.aws.connect.model.InstanceStorageResourceType =
      zio.aws.connect.model.InstanceStorageResourceType
        .wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest
  ): zio.aws.connect.model.DisassociateInstanceStorageConfigRequest.ReadOnly =
    new Wrapper(impl)
}
